package ext.menu.events {
import ext.menu.Item;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.menu.events.ItemEvent")]
public class ItemEvent extends FlExtEvent {
  /**
   * Fires when this item is activated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#event-activate Original Ext JS documentation of 'activate'
   * @see ext.menu.Item
   * @eventType onActivate
   */
  public static const ACTIVATE:String = "onActivate";
  /**
   * Fires when this item is deactivated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Item.html#event-deactivate Original Ext JS documentation of 'deactivate'
   * @see ext.menu.Item
   * @eventType onDeactivate
   */
  public static const DEACTIVATE:String = "onDeactivate";
  public static const __PARAMETER_SEQUENCE__:Array = ["item", "eOpts"];

  public function ItemEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The activated item
   */
  public native function get item():Item;
}
}