package ext.menu.events {
import ext.event.Event;
import ext.menu.Menu;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.menu.events.Menu_eEvent")]
public class Menu_eEvent extends FlExtEvent {
  /**
   * Fires when the mouse enters this menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#event-mouseenter Original Ext JS documentation of 'mouseenter'
   * @see ext.menu.Menu
   * @eventType onMouseEnter
   */
  public static const MOUSE_ENTER:String = "onMouseEnter";
  /**
   * Fires when the mouse leaves this menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#event-mouseleave Original Ext JS documentation of 'mouseleave'
   * @see ext.menu.Menu
   * @eventType onMouseLeave
   */
  public static const MOUSE_LEAVE:String = "onMouseLeave";
  public static const __PARAMETER_SEQUENCE__:Array = ["menu", "e", "eOpts"];

  public function Menu_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The underlying →<code>ext.event.Event</code>
   * @see ext.event.Event
   */
  public native function get e():Event;

  /**
   * The menu
   */
  public native function get menu():Menu;
}
}