package ext.menu.events {
import ext.Component;
import ext.event.Event;
import ext.menu.Menu;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.menu.events.Menu_item_eEvent")]
public class Menu_item_eEvent extends FlExtEvent {
  /**
   * Fires when this menu is clicked
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#event-click Original Ext JS documentation of 'click'
   * @see ext.menu.Menu
   * @eventType onClick
   */
  public static const CLICK:String = "onClick";
  /**
   * Fires when the mouse is hovering over this menu
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.menu.Menu.html#event-mouseover Original Ext JS documentation of 'mouseover'
   * @see ext.menu.Menu
   * @eventType onMouseOver
   */
  public static const MOUSE_OVER:String = "onMouseOver";
  public static const __PARAMETER_SEQUENCE__:Array = ["menu", "item", "e", "eOpts"];

  public function Menu_item_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The underlying →<code>ext.event.Event</code>.
   * @see ext.event.Event
   */
  public native function get e():Event;

  /**
   * The menu item that was clicked. <code>undefined</code> if not applicable.
   */
  public native function get item():Component;

  /**
   * The menu which has been clicked
   */
  public native function get menu():Menu;
}
}