package ext.mixin {
import ext.Mixin;

[Native("Ext.mixin.Accessible", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This mixin defines certain config options, properties, and APIs to be used
 * by Components that implement accessible traits according to WAI-ARIA 1.0 specification.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html Original Ext JS documentation of 'Ext.mixin.Accessible'
 */
public class Accessible extends Mixin implements IAccessible {
  /**
   * @param config @inheritDoc
   */
  public function Accessible(config:Accessible = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * An object containing ARIA attributes to be set
   * on this Component's ARIA element. Use this to set the attributes that cannot be
   * determined by the Component's state, such as <code>aria-live</code>, <code>aria-flowto</code>, etc.
   * <p><b>Note</b> that this config is only meaningful at the Component rendering time,
   * and setting it after that will do nothing.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaAttributes Original Ext JS documentation of 'ariaAttributes'
   * @see #getAriaAttributes()
   * @see #setAriaAttributes()
   */
  public native function get ariaAttributes():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ariaAttributes(value:Object):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as description for this Component, set in <code>aria-describedby</code> attribute.
   * The selector works the same way as →<code>ariaLabelledBy</code>.
   * @see #ariaLabelledBy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaDescribedBy Original Ext JS documentation of 'ariaDescribedBy'
   */
  public native function get ariaDescribedBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDescribedBy(value:*):void;

  [ExtConfig]
  /**
   * ARIA label for this Component. It is best to use
   * →<code>ariaLabelledBy</code> option instead, because screen readers prefer
   * <code>aria-labelledby</code> attribute to <code>aria-label</code>. →<code>ariaLabel</code> and
   * →<code>ariaLabelledBy</code> config options are mutually exclusive.
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabel Original Ext JS documentation of 'ariaLabel'
   */
  public native function get ariaLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabel(value:String):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as label for this Component, set in <code>aria-labelledby</code> attribute.
   * If the selector is by <code>#id</code>, the label element can be any existing element,
   * not necessarily a child of the main Component element.
   * <p>→<code>ariaLabelledBy</code> and →<code>ariaLabel</code> config options are
   * mutually exclusive, and <code>→ariaLabelledBy</code> has the higher precedence.</p>
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabelledBy Original Ext JS documentation of 'ariaLabelledBy'
   */
  public native function get ariaLabelledBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabelledBy(value:*):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  public native function get ariaRole():String;

  /**
   * Returns the value of <code>ariaAttributes</code>.
   * @see #ariaAttributes
   */
  public native function getAriaAttributes():Object;

  /**
   * Sets the value of <code>ariaAttributes</code>.
   * @param ariaAttributes The new value.
   * @see #ariaAttributes
   */
  public native function setAriaAttributes(ariaAttributes:Object):void;
}
}