package ext.mixin {
import ext.Mixin;

[Native("Ext.mixin.Bufferable", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class makes buffered methods simple and also handles cleanup on <code>→destroy()</code>.</p>
 * <pre>
 *  Ext.define('Foo', {
 *      mixins: [
 *          'Ext.mixin.Bufferable'
 *      ],
 *
 *      bufferableMethods: {
 *          // Provides a "foobar" method that calls "doFoobar" with the
 *          // most recent arguments but delayed by 50ms from the last
 *          // call. Calls to "foobar" made during the 50ms wait restart
 *          // the timer and replace the arguments.
 *
 *          foobar: 50
 *      },
 *
 *      method: function() {
 *          this.foobar(42);  // call doFoobar in 50ms
 *
 *          if (this.isFoobarPending) {
 *              // test if "foobar" is pending
 *          }
 *
 *          this.flushFoobar();  // actually, call it now
 *
 *          this.cancelFoobar(); // or never mind
 *      },
 *
 *      doFoobar: function() {
 *          // time to do the "foobar" thing
 *      }
 *  });
 * </pre>
 * @see #destroy()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bufferable.html Original Ext JS documentation of 'Ext.mixin.Bufferable'
 */
public class BufferableMixin extends Mixin implements IBufferableMixin {
}
}