package ext.mixin {
import ext.Base;
import ext.data.Model;

[Native("Ext.mixin.Dirty", require)]
/**
 * @see ext.mixin.events.Dirty_dirtyEvent.DIRTY_CHANGE
 * @eventType ext.mixin.events.Dirty_dirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.mixin.events.Dirty_dirtyEvent')]
/**
 * This mixin provides a <code>→dirty</code> config that tracks the modified state of an object. If
 * the class using this mixin is <i>observable</i> (→<code>ext.mixin.Observable</code>), changes to the
 * <code>→dirty</code> config will fire the <code>→event:onDirtyChange</code> event.
 * @see #dirty
 * @see ext.mixin.Observable
 * @see #event:onDirtyChange
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html Original Ext JS documentation of 'Ext.mixin.Dirty'
 */
public class Dirty extends Base implements IDirty {
  [ExtConfig]
  [Bindable]
  /**
   * This config property describes the modified state of this object. In most
   * cases this config's value is maintained by the object and should be considered
   * readonly. The class implementor should be the only one to call the setter.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-dirty Original Ext JS documentation of 'dirty'
   * @see #getDirty()
   * @see #setDirty()
   */
  public native function get dirty():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dirty(value:Boolean):void;

  [ExtConfig]
  /**
   * This config property indicates that the <code>→dirty</code> state of this object should be
   * ignored. Because this capability is mixed in at a class level, this config can
   * be helpful when some instances do not participate in dirty state tracking.
   * <p>This option should be set at construction time. When set to <code>true</code>, the object
   * will always have <code>→dirty</code> value of <code>false</code>.</p>
   * @default false
   * @see #dirty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-ignoreDirty Original Ext JS documentation of 'ignoreDirty'
   */
  public native function get ignoreDirty():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreDirty(value:Boolean):void;

  [ExtConfig]
  /**
   * Set this config at construction time (or on the class body) to automatically set
   * the <code>→dirty</code> state based on the records passed to <code>→trackRecordState()</code>.
   * <p>This config defaults to <code>true</code> but only has an effect when the record tracking
   * methods are called (<code>→trackRecordState()</code>, <code>→untrackRecordState()</code> and <code>→clearRecordStates()</code>).</p>
   * @default true
   * @see #dirty
   * @see #trackRecordState()
   * @see #untrackRecordState()
   * @see #clearRecordStates()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-recordStateIsDirtyState Original Ext JS documentation of 'recordStateIsDirtyState'
   */
  public native function get recordStateIsDirtyState():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set recordStateIsDirtyState(value:Boolean):void;

  /**
   * Clears all record state tracking. This state is maintained by <code>→trackRecordState()</code>
   * and <code>→untrackRecordState()</code>.
   * @see #trackRecordState()
   * @see #untrackRecordState()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-clearRecordStates Original Ext JS documentation of 'clearRecordStates'
   */
  protected native function clearRecordStates():void;

  /**
   * Returns the value of <code>dirty</code>.
   * @see #dirty
   */
  public native function getDirty():Boolean;

  /**
   * Returns <code>true</code> if this object is <code>→dirty</code>.
   * @see #dirty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-isDirty Original Ext JS documentation of 'isDirty'
   */
  public native function isDirty():void;

  /**
   * Sets the value of <code>dirty</code>.
   * @param dirty The new value.
   * @see #dirty
   */
  public native function setDirty(dirty:Boolean):void;

  /**
   * This method is called to track a given record in the total number of dirty records
   * (modified, created or dropped). See <code>→untrackRecordState()</code> and <code>→clearRecordStates()</code>.
   * @param record The record to track.
   * @param initial Pass <code>true</code> the first time a record is introduced.
   * @return Returns <code>true</code> if the state of dirty records has changed.
   * @see #untrackRecordState()
   * @see #clearRecordStates()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-trackRecordState Original Ext JS documentation of 'trackRecordState'
   */
  protected native function trackRecordState(record:Model, initial:Boolean):Boolean;

  /**
   * This method is called to remove the tracking of a given record from the total number
   * of dirty records (modified, created or dropped). The record passed to this method
   * must have been previously passed to <code>→trackRecordState()</code>.
   * @param record The record to stop tracking.
   * @return Returns <code>true</code> if the state of dirty records has changed.
   * @see #trackRecordState()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-untrackRecordState Original Ext JS documentation of 'untrackRecordState'
   */
  protected native function untrackRecordState(record:Model):Boolean;
}
}