package ext.mixin {
import ext.Base;
import ext.Component;
import ext.dom.Element;
import ext.event.Event;

[Native("Ext.mixin.Focusable", require)]
/**
 * @see ext.mixin.events.Focusable_eventEvent.BLUR
 * @eventType ext.mixin.events.Focusable_eventEvent.BLUR
 */
[Event(name='onBlur', type='ext.mixin.events.Focusable_eventEvent')]
/**
 * @see ext.mixin.events.Focusable_eventEvent.FOCUS
 * @eventType ext.mixin.events.Focusable_eventEvent.FOCUS
 */
[Event(name='onFocus', type='ext.mixin.events.Focusable_eventEvent')]
/**
 * @see ext.mixin.events.Focusable_eventEvent.FOCUS_ENTER
 * @eventType ext.mixin.events.Focusable_eventEvent.FOCUS_ENTER
 */
[Event(name='onFocusEnter', type='ext.mixin.events.Focusable_eventEvent')]
/**
 * @see ext.mixin.events.Focusable_eventEvent.FOCUS_LEAVE
 * @eventType ext.mixin.events.Focusable_eventEvent.FOCUS_LEAVE
 */
[Event(name='onFocusLeave', type='ext.mixin.events.Focusable_eventEvent')]
/**
 * This mixin implements focus management functionality in Widgets and Components
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html Original Ext JS documentation of 'Ext.mixin.Focusable'
 */
public class Focusable extends Base implements IFocusable {
  /**
   * <code>true</code> if this currently focused element
   * is within this Component's or Container's hierarchy. This property is set separately
   * from →<code>hasFocus</code>, and can be <code>true</code> when <code>→hasFocus</code> is <code>false</code>.
   * <p>Examples:</p>
   * <ul>
   * <li>
   * <p>Text field with input element focused would be:
   * focusable: true,
   * hasFocus: true,
   * containsFocus: true</p>
   * </li>
   * <li>
   * <p>Date field with drop-down picker currently focused would be:
   * focusable: true,
   * hasFocus: false,
   * containsFocus: true</p>
   * </li>
   * <li>
   * <p>Form Panel with a child input field currently focused would be:
   * focusable: false,
   * hasFocus: false,
   * containsFocus: true</p>
   * </li>
   * </ul>
   * <p>See also →<code>hasFocus</code>.</p>
   * @default false
   * @see #hasFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-containsFocus Original Ext JS documentation of 'containsFocus'
   */
  public native function get containsFocus():Boolean;

  [ExtConfig]
  /**
   * CSS class that will be added to focused
   * component's →<code>focusClsEl</code>, and removed when component blurs.
   * @default 'x-focused'
   * @see #focusClsEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusCls(value:String):void;

  /**
   * The element that will have the
   * →<code>focusCls</code> applied when component's →<code>focusEl</code> is focused.
   * @see #focusCls
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-focusClsEl Original Ext JS documentation of 'focusClsEl'
   */
  public native function get focusClsEl():Element;

  /**
   * @private
   */
  public native function set focusClsEl(value:Element):void;

  /**
   * The element that will be focused
   * when →<code>focus()</code> method is called on this component. Usually this is
   * the same element that receives focus via mouse clicks, taps, and pressing
   * Tab key.
   * @default 'el'
   * @see #focus()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-focusEl Original Ext JS documentation of 'focusEl'
   */
  public native function get focusEl():Element;

  /**
   * @private
   */
  public native function set focusEl(value:Element):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default false
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  public native function get focusable():Boolean;

  /**
   * <code>true</code> if this component's →<code>focusEl</code> is focused.
   * See also →<code>containsFocus</code>.
   * @default false
   * @see #focusEl
   * @see #containsFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-hasFocus Original Ext JS documentation of 'hasFocus'
   */
  public native function get hasFocus():Boolean;

  /**
   * Template method to do any Focusable related initialization that
   * does not involve event listeners creation.
   * @default Ext.emptyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-initFocusable Original Ext JS documentation of 'initFocusable'
   */
  public native function get initFocusable():*;

  /**
   * @private
   */
  public native function set initFocusable(value:*):void;

  /**
   * Template method to do any pre-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeBlur Original Ext JS documentation of 'beforeBlur'
   */
  protected native function beforeBlur(e:Event):void;

  /**
   * Template method to do any pre-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeFocus Original Ext JS documentation of 'beforeFocus'
   */
  protected native function beforeFocus(e:Event):void;

  /**
   * Cancel any deferred focus on this component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-cancelFocus Original Ext JS documentation of 'cancelFocus'
   */
  protected native function cancelFocus():void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function focus(selectText:* = undefined, delay:* = undefined, callback:Function = null, scope:Function = null):Component;

  /**
   * Returns the element used to apply focus styling CSS class when Focusable's
   * →<code>focusEl</code> becomes focused. By default it is →<code>focusEl</code>.
   * @param focusEl Return focus styling element for the given
   * focused element. This is used by Components implementing multiple focusable
   * elements.
   * @return The focus styling element.
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusClsEl Original Ext JS documentation of 'getFocusClsEl'
   */
  protected native function getFocusClsEl(focusEl:Element = null):Element;

  /**
   * Returns the main focus holder element associated with this Focusable, i.e.
   * the element that will be focused when Focusable's →<code>focus()</code> method is
   * called. For most Focusables, this will be the →<code>focusEl</code>.
   * @see #focus()
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusEl Original Ext JS documentation of 'getFocusEl'
   */
  protected native function getFocusEl():Element;

  /**
   * Return the actual tabIndex for this Focusable.
   * @return tabIndex attribute value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getTabIndex Original Ext JS documentation of 'getTabIndex'
   */
  public native function getTabIndex():Number;

  /**
   * Template method to do any event listener initialization for a Focusable.
   * This generally happens after the focusEl is available.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-initFocusableEvents Original Ext JS documentation of 'initFocusableEvents'
   */
  protected native function initFocusableEvents(force:*):void;

  /**
   * Determine if this Focusable can receive focus at this time.
   * <p>Note that Containers can be non-focusable themselves while delegating
   * focus treatment to a child Component; see <i>defaultFocus</i> (→<code>ext.container.Container</code>)
   * for more information.</p>
   * @param deep Optionally determine if the container itself
   * is focusable, or if container's focus is delegated to a child component
   * and that child is focusable.
   * @default false
   * @return True if component is focusable, false if not.
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-isFocusable Original Ext JS documentation of 'isFocusable'
   */
  public native function isFocusable(deep:Boolean = false):Boolean;

  /**
   * Called when focus enters this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the <code>fromComponent</code> is <i>after</i> the <code>toComponent&#42; in the DOM tree, indicating that the user used</code>SHIFT+TAB<code>to move focus. Note that setting</code>tabIndex<code>values to affect tabbing order can cause this to be incorrect. Setting</code>tabIndex` values is not advised.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusEnter Original Ext JS documentation of 'onFocusEnter'
   */
  protected native function onFocusEnter(e:Object):void;

  /**
   * Called when focus exits from this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusLeave Original Ext JS documentation of 'onFocusLeave'
   */
  protected native function onFocusLeave(e:Event):void;

  /**
   * Called when focus moves <i>within</i> this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying Event object.
   * </li>
   * <li><code>toElement:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>fromElement:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the focus movement is backward in DOM order
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusMove Original Ext JS documentation of 'onFocusMove'
   */
  protected native function onFocusMove(info:Object):void;

  /**
   * Template method to do any post-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postBlur Original Ext JS documentation of 'postBlur'
   */
  protected native function postBlur(e:Event):void;

  /**
   * Template method to do any post-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postFocus Original Ext JS documentation of 'postFocus'
   */
  protected native function postFocus(e:Event):void;

  /**
   * Set the tabIndex property for this Focusable. If the focusEl
   * is available, set tabIndex attribute on it, too.
   * @param newTabIndex new tabIndex to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-setTabIndex Original Ext JS documentation of 'setTabIndex'
   */
  public native function setTabIndex(newTabIndex:Number):void;
}
}