package ext.mixin {
import ext.Component;
import ext.Mixin;
import ext.dom.Element;
import ext.event.Event;
import ext.util.KeyNav;

[Native("Ext.mixin.FocusableContainer", require)]
/**
 * A mixin for groups of Focusable things (Components, Widgets, etc) that
 * should respond to arrow keys to navigate among the peers, but keep only
 * one of the peers tabbable by default (tabIndex=0).
 * <p>Some examples: Toolbars, Tab bars, Panel headers, Menus</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html Original Ext JS documentation of 'Ext.mixin.FocusableContainer'
 */
public class FocusableContainer extends Mixin implements IFocusableContainer {
  [ExtConfig]
  /**
   * DOM tabIndex attribute to set on the
   * active Focusable child of this container when using the "Roaming tabindex"
   * technique.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-activeChildTabIndex Original Ext JS documentation of 'activeChildTabIndex'
   */
  public native function get activeChildTabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeChildTabIndex(value:Number):void;

  [ExtConfig]
  /**
   * Set this to <code>true</code>
   * to enable focusing disabled child items via keyboard.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-allowFocusingDisabledChildren Original Ext JS documentation of 'allowFocusingDisabledChildren'
   */
  public native function get allowFocusingDisabledChildren():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowFocusingDisabledChildren(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable or disable navigation
   * with arrow keys for this FocusableContainer. This option may be useful
   * with nested FocusableContainers, when only the root container should
   * handle keyboard events.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-focusableContainer Original Ext JS documentation of 'focusableContainer'
   */
  public native function get focusableContainer():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusableContainer(value:Boolean):void;

  /**
   * The name of the element
   * that FocusableContainer should bind its keyboard handler to. Similar to →<code>ariaEl</code>,
   * this name is resolved to the →<code>ext.dom.Element</code> instance after rendering.
   * @default "el"
   * @see #ariaEl
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#property-focusableContainerEl Original Ext JS documentation of 'focusableContainerEl'
   */
  public native function get focusableContainerEl():*;

  /**
   * @private
   */
  public native function set focusableContainerEl(value:*):void;

  [ExtConfig]
  /**
   * DOM tabIndex attribute to set on
   * inactive Focusable children of this container when using the "Roaming tabindex"
   * technique. This value rarely needs to be changed from its default.
   * @default -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-inactiveChildTabIndex Original Ext JS documentation of 'inactiveChildTabIndex'
   */
  public native function get inactiveChildTabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inactiveChildTabIndex(value:Number):void;

  [ExtConfig]
  /**
   * When <code>true</code>, FocusableContainer
   * will reset last focused position whenever focus leaves the container.
   * Subsequent tabbing into the container will always focus the first eligible
   * child item.
   * <p>When <code>false</code>, subsequent tabbing into the container will focus the child
   * item that was last focused before.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-resetFocusPosition Original Ext JS documentation of 'resetFocusPosition'
   */
  public native function get resetFocusPosition():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set resetFocusPosition(value:Boolean):void;

  /*
   * Undocumented internal API of Ext.mixin.FocusableContainer.
   */

  [ExtPrivate]
  [ArrayElementType("ext.Component")]
  internal native function getFocusables():Array;

  [ExtPrivate]
  internal native function onFocusableChildAdd(child:Component):void;

  [ExtPrivate]
  internal native function moveChildFocus(event:Event, forward:Boolean):Component;

  internal native function get focusableKeyNav():KeyNav;
  internal native function set focusableKeyNav(value:KeyNav):void;

  [ExtPrivate]
  internal native function afterFocusableChildBlur(child:Component):void;

  [ExtPrivate]
  internal native function beforeFocusableChildFocus(child:Component):void;

  [ExtPrivate]
  internal native function deactivateFocusable(child:Component):void;

  [ExtPrivate]
  internal native function findNextFocusableChild(options:Object):Component;

  [ExtPrivate]
  /**
   * An overrideable function which preprocesses all key events from within this FocusableContainer.
   * The base implementation vetoes processing of key events from input fields by returning `undefined`.
   * This may be overridden in subclasses with special requirements.
   * @param e A keyboard event that is significant to the operation of a FocusableContainer.
   * @returns The event if it is to be processed as a FocusableContainer navigation keystroke,
   * or `undefined` if it is to be ignore by the FocusableContainer navigation machinery.
   */
  internal native function processFocusableContainerKeyEvent(e:Event):Event;

  [ExtPrivate]
  internal native function initFocusableContainerKeyNav(el:Element):void;

}
}