package ext.mixin {
[Mixin("ext.mixin.AdvancedFocusableContainerMixin")]

/**
 * Adds extra functionality to an ext.util.FocusableContainer.
 *
 * Allows the container to be aware of nested focusable items (ext.util.Focusable)
 * instead of just considering its direct children.
 *
 * Allows to set navigation mode via tab key (enabled, disabled, exclusive).
 */
public interface IAdvancedFocusableContainerMixin extends IFocusableContainer {

  [ExtConfig] /**
   * Determines whether input fields are excluded from FocusableContainer navigation. If
   * true, the other focusable items are partitioned into groups of items that
   * lie between the input fields. FocusableContainer navigation then takes place
   * inside these partitions.
   */
  function get excludeInputFields():Boolean;

  [ExtConfig] function set excludeInputFields(exclude:Boolean):void;

  [ExtConfig] /**
   * This config option only takes effect if the nestedFocusableItems option is set to true.
   *
   * Determines a custom function to compute the focusable items of this container.
   *
   * @default Ext.container.Container.query.
   */
  function get getFocusablesFn():Function;

  [ExtConfig] function set getFocusablesFn(fn:Function):void;

  [ExtConfig] /**
   * Determines the flag to ignore FocusableContainer navigation when an input field is focused.
   * If true, it is not possible to navigate away from the input field via
   * FocusableContainer navigation.
   */
  function get ignoreInputFields():Boolean;

  [ExtConfig] function set ignoreInputFields(ignore:Boolean):void;

  [ExtConfig] /**
   * Determines the flag to determine if nested focusable items shall be considered instead of just
   * the direct children of the container.
   *
   * See also the getFocusablesFn config option.
   *
   * Defaults to true.
   */
  function get nestedFocusableItems():Boolean;

  [ExtConfig] function set nestedFocusableItems(nested:Boolean):void;

  [ExtConfig] /**
   * Determines the tab navigation mode as one of
   * <ul>
   *   <li><code>TAB_NAVIGATION_MODE_ONLY</code> - Only tab navigation allowed, arrow key navigation disabled</li>
   *   <li><code>TAB_NAVIGATION_MODE_ENABLE</code> - Tab navigation enabled (possibly in addition to arrow key navigation)</li>
   *   <li><code>TAB_NAVIGATION_MODE_DISABLE</code> - Tab navigation disabled</li>
   * </ul>
   *
   * @see AdvancedFocusableContainerMixin#TAB_NAVIGATION_MODE_ONLY
   * @see AdvancedFocusableContainerMixin#TAB_NAVIGATION_MODE_ENABLE
   * @see AdvancedFocusableContainerMixin#TAB_NAVIGATION_MODE_DISABLE
   */
  function get tabNavigationMode():int;

  [ExtConfig] function set tabNavigationMode(mode:int):void;
}
}
