package ext.mixin {
import ext.app.ViewController;
import ext.app.ViewModel;
import ext.data.Session;

[Mixin("ext.mixin.Bindable")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>This class is intended as a mixin for classes that want to provide a "bind" config that
 * connects to a <code>ViewModel</code>.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html Original Ext JS documentation of 'Ext.mixin.Bindable'
 * @see ext.mixin.Bindable
 */
public interface IBindable {
  [ExtConfig]
  [Bindable] /**
   * Setting this config option adds or removes data bindings for other configs.
   * For example, to bind the <code>title</code> config:
   * <pre>
   *  var panel = Ext.create({
   *      xtype: 'panel',
   *      bind: {
   *          title: 'Hello {user.name}'
   *      }
   *  });
   * </pre>
   * <p>To dynamically add bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: 'Greetings {user.name}!'
   *  });
   * </pre>
   * <p>To remove bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: null
   *  });
   * </pre>
   * <p>The bind expressions are presented to <code>→ext.app.ViewModel.bind()</code>. The
   * <code>ViewModel</code> instance is determined by <code>→lookupViewModel()</code>.</p>
   * <p><b>Note:</b> If bind is passed as a string, it will use the
   * →<code>ext.Component.defaultBindProperty</code> for the binding.</p>
   * @default null
   * @see ext.app.ViewModel#bind()
   * @see #lookupViewModel()
   * @see ext.Component#defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-bind Original Ext JS documentation of 'bind'
   * @see #getBind()
   * @see #setBind()
   */
  function get bind():*;

  [ExtConfig]
  [Bindable] function set bind(value:*):void;

  [ExtConfig]
  [Bindable] /**
   * A string alias, a configuration object or an instance of a <code>ViewController</code> for
   * this container. Sample usage:
   * <pre>
   * Ext.define('MyApp.UserController', {
   *     alias: 'controller.user'
   * });
   *
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: 'user'
   * });
   * // Or
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: {
   *         type: 'user',
   *         someConfig: true
   *     }
   * });
   *
   * // Can also instance at runtime
   * var ctrl = new MyApp.UserController();
   * var view = new UserContainer({
   *     controller: ctrl
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-controller Original Ext JS documentation of 'controller'
   * @see #getController()
   * @see #setController()
   */
  function get controller():*;

  [ExtConfig]
  [Bindable] function set controller(value:*):void;

  [ExtConfig]
  [Bindable] /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable] function set defaultListenerScope(value:Boolean):void;

  [ExtConfig] /**
   * Set to <code>true</code> for this component's <code>name</code> property to be tracked by its containing
   * <code>nameHolder</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-nameable Original Ext JS documentation of 'nameable'
   */
  function get nameable():Boolean;

  [ExtConfig] function set nameable(value:Boolean):void;

  [ExtConfig]
  [Bindable] /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default null
   * @since 5.0.0
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  function get publishes():*;

  [ExtConfig]
  [Bindable] function set publishes(value:*):void;

  [ExtConfig] /**
   * Specifies a name for this component inside its component hierarchy. This name
   * must be unique within its <i>view</i> (→<code>ext.container.Container.referenceHolder</code>)
   * or its →<code>ext.app.ViewController</code>. See the documentation in
   * →<code>ext.container.Container</code> for more information about references.
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed
   * by zero or more additional letters, underscores or digits. References are case
   * sensitive.</p>
   * @see ext.container.Container#referenceHolder
   * @see ext.app.ViewController
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-reference Original Ext JS documentation of 'reference'
   */
  function get reference():String;

  [ExtConfig] function set reference(value:String):void;

  [ExtConfig]
  [Bindable] /**
   * If provided this creates a new <code>Session</code> instance for this component. If this
   * is a <code>Container</code>, this will then be inherited by all child components.
   * <p>To create a new session you can specify <code>true</code>:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: true,
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * <p>Alternatively, a config object can be provided:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: {
   *          ...
   *      },
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-session Original Ext JS documentation of 'session'
   * @see #getSession()
   * @see #setSession()
   */
  function get session():*;

  [ExtConfig]
  [Bindable] function set session(value:*):void;

  [ExtConfig] /**
   * Set to <code>true</code> to allow this component's <code>name</code> to be shared by other items in the
   * same <code>nameHolder</code>. Such items will be returned in an array from <code>lookupName</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-shareableName Original Ext JS documentation of 'shareableName'
   */
  function get shareableName():Boolean;

  [ExtConfig] function set shareableName(value:Boolean):void;

  [ExtConfig]
  [Bindable] /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default null
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  function get twoWayBindable():*;

  [ExtConfig]
  [Bindable] function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable] /**
   * The <code>ViewModel</code> is a data provider for this component and its children. The
   * data contained in the <code>ViewModel</code> is typically used by adding <code>→bind</code> configs
   * to the components that want present or edit this data.
   * <p>When set, the <code>ViewModel</code> is created and links to any inherited <code>→viewModel</code>
   * instance from an ancestor container as the "parent". The <code>ViewModel</code> hierarchy,
   * once established, only supports creation or destruction of children. The
   * parent of a <code>ViewModel</code> cannot be changed on the fly.</p>
   * <p>If this is a root-level <code>ViewModel</code>, the data model connection is made to this
   * component's associated <code>Data Session (→ext.data.Session)</code>. This is
   * determined by calling <code>getInheritedSession</code>.</p>
   * @default null
   * @see #bind
   * @see #viewModel
   * @see ext.data.Session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-viewModel Original Ext JS documentation of 'viewModel'
   * @see #getViewModel()
   * @see #setViewModel()
   */
  function get viewModel():ViewModel;

  [ExtConfig]
  [Bindable] function set viewModel(value:ViewModel):void;

  /**
   * Returns the value of <code>bind</code>.
   * @see #bind
   */
  function getBind():*;

  /**
   * Returns the value of <code>controller</code>.
   * @see #controller
   */
  function getController():*;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  function getDefaultListenerScope():Boolean;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  function getPublishes():*;

  /**
   * Returns the value of <code>session</code>.
   * @see #session
   */
  function getSession():*;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  function getTwoWayBindable():*;

  /**
   * Returns the value of <code>viewModel</code>.
   * @see #viewModel
   */
  function getViewModel():*;

  /**
   * Determines if the passed property name is bound to ViewModel data.
   * @since 6.5.0
   * @param name The property name to test. Defaults to the
   * →<code>defaultBindProperty</code>
   * @return <code>true</code> if the passed property receives data from a ViewModel.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-isBound Original Ext JS documentation of 'isBound'
   * @see ext.mixin.Bindable#defaultBindProperty
   */
  function isBound(name:String = null):Boolean;

  /**
   * Gets the controller that controls this view. May be a controller that belongs
   * to a view higher in the hierarchy.
   * @since 5.0.1
   * @param skipThis <code>true</code> to not consider the controller directly attached
   * to this view (if it exists).
   * @default false
   * @return The controller. <code>null</code> if no controller is found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-lookupController Original Ext JS documentation of 'lookupController'
   */
  function lookupController(skipThis:Boolean = false):ViewController;

  /**
   * Returns the <code>→ext.data.Session</code> for this instance. This property may come
   * from this instance's <code>→session</code> or be inherited from this object's parent.
   * @since 5.0.0
   * @param skipThis Pass <code>true</code> to ignore a <code>→session</code> configured on
   * this instance and only consider an inherited session.
   * @default false
   * @see ext.data.Session
   * @see ext.mixin.Bindable#session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-lookupSession Original Ext JS documentation of 'lookupSession'
   */
  function lookupSession(skipThis:Boolean = false):Session;

  /**
   * Returns the <code>→ext.app.ViewModel</code> for this instance. This property may come from this
   * this instance's <code>→viewModel</code> or be inherited from this object's parent.
   * @since 5.0.0
   * @param skipThis Pass <code>true</code> to ignore a <code>→viewModel</code> configured on
   * this instance and only consider an inherited view model.
   * @default false
   * @see ext.app.ViewModel
   * @see ext.mixin.Bindable#viewModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-lookupViewModel Original Ext JS documentation of 'lookupViewModel'
   */
  function lookupViewModel(skipThis:Boolean = false):ViewModel;

  /**
   * Sets the value of <code>bind</code>.
   * @param bind The new value.
   * @see #bind
   */
  function setBind(bind:*):void;

  /**
   * Sets the value of <code>controller</code>.
   * @param controller The new value.
   * @see #controller
   */
  function setController(controller:*):void;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>session</code>.
   * @param session The new value.
   * @see #session
   */
  function setSession(session:*):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>viewModel</code>.
   * @param viewModel The new value.
   * @see #viewModel
   */
  function setViewModel(viewModel:*):void;
}
}