package ext.mixin {
import ext.Component;
import ext.IMixin;

[Mixin("ext.mixin.Container")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Common methods for both classic &amp; modern containers</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html Original Ext JS documentation of 'Ext.mixin.Container'
 * @see ext.mixin.Container
 */
public interface IContainer extends IMixin {
  /**
   * <code>true</code> in this class to identify an object as an instantiated Container, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#property-isContainer Original Ext JS documentation of 'isContainer'
   */
  function get isContainer():Boolean;

  function set isContainer(value:Boolean):void;

  [ExtConfig] /**
   * When <code>true</code> child components are tracked by their <code>name</code> property and can be
   * retrieved using the <code>→lookupName()</code> method.
   * @default false
   * @see #lookupName()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#cfg-nameHolder Original Ext JS documentation of 'nameHolder'
   */
  function get nameHolder():Boolean;

  [ExtConfig] function set nameHolder(value:Boolean):void;

  [ExtConfig] /**
   * If <code>true</code>, this container will be marked as being a point in the hierarchy where
   * references to items with a specified <code>reference</code> config will be held. The container
   * will automatically become a referenceHolder if a →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for more information
   * about references &amp; reference holders.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#cfg-referenceHolder Original Ext JS documentation of 'referenceHolder'
   */
  function get referenceHolder():Boolean;

  [ExtConfig] function set referenceHolder(value:Boolean):void;

  /**
   * Returns an object holding the descendants of this container keyed by their
   * <code>name</code>. This object should not be held past the scope of the function calling this
   * method. It will not be valid if items are added or removed from this or any
   * sub-container.
   * <p>The intended usage is shown here (assume there are 3 components with names of
   * "foo", "bar" and "baz" at some level below this container):</p>
   * <pre>
   *  onClick: function () {
   *      var items = this.getNamedItems();
   *
   *      // using "items" we can access any descendant by its "name"
   *
   *      items.foo.getValue() + items.bar.getValue() + items.baz.getValue();
   *  }
   * </pre>
   * <p>If <code>this</code> component has a <code>name</code> assigned to it, it is <b>not</b> included in this
   * object. That name is understood to belong to the ancestor container configured
   * as the <code>→nameHolder</code>.</p>
   * @since 6.5.0
   * @return An object with each named child. This will be <code>null</code> if this
   * container has no descendants with a <code>name</code> specified.
   * @see ext.mixin.Container#nameHolder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#method-getNamedItems Original Ext JS documentation of 'getNamedItems'
   */
  function getNamedItems():Object;

  /**
   * Returns an object holding the descendants of this view keyed by their
   * <code>→ext.Component.reference</code>. This object should not be held
   * past the scope of the function calling this method. It will not be valid if items
   * are added or removed from this or any sub-container.
   * <p>The intended usage is shown here (assume there are 3 components with reference
   * values of "foo", "bar" and "baz" at some level below this container):</p>
   * <pre>
   *  onClick: function () {
   *      var refs = this.getReferences();
   *
   *      // using "refs" we can access any descendant by its "reference"
   *
   *      refs.foo.getValue() + refs.bar.getValue() + refs.baz.getValue();
   *  }
   * </pre>
   * <p>If <code>this</code> component has a <code>→ext.Component.reference</code> assigned
   * to it, that is <b>not</b> included in this object. That reference is understood to
   * belong to the ancestor container configured as the <code>→referenceHolder</code>.</p>
   * @since 5.0.0
   * @return An object with each child reference. This will be <code>null</code> if this
   * container has no descendants with a <code>→ext.Component.reference</code>
   * specified.
   * @see ext.Component#reference
   * @see ext.mixin.Container#referenceHolder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#method-getReferences Original Ext JS documentation of 'getReferences'
   */
  function getReferences():Object;

  /**
   * Gets a reference to the component with the specified
   * →<code>ext.Component.reference</code> value.
   * <p>The method is a short-hand for the →<code>lookupReference()</code> method.</p>
   * @since 6.0.1
   * @param ref The value of the <code>reference</code> to lookup.
   * @return The referenced component or <code>null</code> if it is not found.
   * @see ext.Component#reference
   * @see ext.mixin.Container#lookupReference()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#method-lookup Original Ext JS documentation of 'lookup'
   */
  function lookup(ref:String):Component;

  /**
   * Gets a reference to the component with the specified <code>name</code> property.
   * @since 6.5.0
   * @param name The name of the descendant to lookup.
   * @return The component or <code>null</code> if it is not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#method-lookupName Original Ext JS documentation of 'lookupName'
   */
  function lookupName(name:String):Component;

  /**
   * Gets a reference to the component with the specified →<code>reference</code> value.
   * <p>The →<code>lookup()</code> method is a short-hand version of this method.</p>
   * @since 5.0
   * @param ref The name of the reference to lookup.
   * @return The referenced component or <code>null</code> if it is not found.
   * @see ext.mixin.Container#reference
   * @see ext.mixin.Container#lookup()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Container.html#method-lookupReference Original Ext JS documentation of 'lookupReference'
   */
  function lookupReference(ref:String):Component;
}
}