package ext.mixin {

[Mixin("ext.mixin.Dirty")]
/**
 * This mixin provides a <code>→dirty</code> config that tracks the modified state of an object. If
 * the class using this mixin is <i>observable</i> (→<code>ext.mixin.Observable</code>), changes to the
 * <code>→dirty</code> config will fire the <code>→event:onDirtyChange</code> event.
 * @see ext.mixin.Dirty#dirty
 * @see ext.mixin.Observable
 * @see ext.mixin.Dirty#event:onDirtyChange
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html Original Ext JS documentation of 'Ext.mixin.Dirty'
 * @see ext.mixin.Dirty
 */
public interface IDirty {
  [ExtConfig]
  [Bindable] /**
   * This config property describes the modified state of this object. In most
   * cases this config's value is maintained by the object and should be considered
   * readonly. The class implementor should be the only one to call the setter.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-dirty Original Ext JS documentation of 'dirty'
   * @see #getDirty()
   * @see #setDirty()
   */
  function get dirty():Boolean;

  [ExtConfig]
  [Bindable] function set dirty(value:Boolean):void;

  [ExtConfig] /**
   * This config property indicates that the <code>→dirty</code> state of this object should be
   * ignored. Because this capability is mixed in at a class level, this config can
   * be helpful when some instances do not participate in dirty state tracking.
   * <p>This option should be set at construction time. When set to <code>true</code>, the object
   * will always have <code>→dirty</code> value of <code>false</code>.</p>
   * @default false
   * @see #dirty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#cfg-ignoreDirty Original Ext JS documentation of 'ignoreDirty'
   */
  function get ignoreDirty():Boolean;

  [ExtConfig] function set ignoreDirty(value:Boolean):void;

  /**
   * Returns the value of <code>dirty</code>.
   * @see #dirty
   */
  function getDirty():Boolean;

  /**
   * Returns <code>true</code> if this object is <code>→dirty</code>.
   * @see ext.mixin.Dirty#dirty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#method-isDirty Original Ext JS documentation of 'isDirty'
   */
  function isDirty():void;

  /**
   * Sets the value of <code>dirty</code>.
   * @param dirty The new value.
   * @see #dirty
   */
  function setDirty(dirty:Boolean):void;
}
}