package ext.mixin {

[Mixin("ext.mixin.Factoryable")]
/**
 * This mixin automates use of <code>→ext.Factory</code>. When mixed in to a class, the <code>alias</code> of the
 * class is retrieved and combined with an optional <code>→factoryConfig</code> property on that class
 * to produce the configuration to pass to <code>→ext.Factory</code>.
 * <p>The factory method created by <code>→ext.Factory</code> is also added as a static method to the
 * target class.</p>
 * <p>Given a class declared like so:</p>
 * <pre>
 *  Ext.define('App.bar.Thing', {
 *      mixins: [
 *          'Ext.mixin.Factoryable'
 *      ],
 *
 *      alias: 'bar.thing',  // this is detected by Factoryable
 *
 *      factoryConfig: {
 *          defaultType: 'thing',  // this is the default deduced from the alias
 *          // other configs
 *      },
 *
 *      ...
 *  });
 * </pre>
 * <p>The produced factory function can be used to create instances using the following
 * forms:</p>
 * <pre>
 *  var obj;
 *
 *  obj = App.bar.Thing.create('thing'); // same as "new App.bar.Thing()"
 *
 *  obj = App.bar.Thing.create({
 *      type: 'thing'       // same as above
 *  });
 *
 *  obj = App.bar.Thing.create({
 *      xclass: 'App.bar.Thing'  // same as above
 *  });
 *
 *  var obj2 = App.bar.Thing.create(obj);
 *  // obj === obj2  (passing an instance returns the instance)
 * </pre>
 * <p>Alternatively the produced factory is available as a static method of <code>→ext.Factory</code>.</p>
 * @see ext.Factory
 * @see ext.mixin.Factoryable#factoryConfig
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Factoryable.html Original Ext JS documentation of 'Ext.mixin.Factoryable'
 * @see ext.mixin.Factoryable
 */
public interface IFactoryable {
  /**
   * If this property is specified by the target class of this mixin its properties are
   * used to configure the created <code>→ext.Factory</code>.
   * @see ext.Factory
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Factoryable.html#property-factoryConfig Original Ext JS documentation of 'factoryConfig'
   */
  function get factoryConfig():Object;

  function set factoryConfig(value:Object):void;
}
}