package ext.mixin {
import ext.IMixin;

[Mixin("ext.mixin.FocusableContainer")]
/**
 * A mixin for groups of Focusable things (Components, Widgets, etc) that
 * should respond to arrow keys to navigate among the peers, but keep only
 * one of the peers tabbable by default (tabIndex=0).
 * <p>Some examples: Toolbars, Tab bars, Panel headers, Menus</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html Original Ext JS documentation of 'Ext.mixin.FocusableContainer'
 * @see ext.mixin.FocusableContainer
 */
public interface IFocusableContainer extends IMixin {
  [ExtConfig] /**
   * DOM tabIndex attribute to set on the
   * active Focusable child of this container when using the "Roaming tabindex"
   * technique.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-activeChildTabIndex Original Ext JS documentation of 'activeChildTabIndex'
   */
  function get activeChildTabIndex():Number;

  [ExtConfig] function set activeChildTabIndex(value:Number):void;

  [ExtConfig] /**
   * Set this to <code>true</code>
   * to enable focusing disabled child items via keyboard.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-allowFocusingDisabledChildren Original Ext JS documentation of 'allowFocusingDisabledChildren'
   */
  function get allowFocusingDisabledChildren():Boolean;

  [ExtConfig] function set allowFocusingDisabledChildren(value:Boolean):void;

  [ExtConfig] /**
   * Enable or disable navigation
   * with arrow keys for this FocusableContainer. This option may be useful
   * with nested FocusableContainers, when only the root container should
   * handle keyboard events.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-focusableContainer Original Ext JS documentation of 'focusableContainer'
   */
  function get focusableContainer():Boolean;

  [ExtConfig] function set focusableContainer(value:Boolean):void;

  /**
   * The name of the element
   * that FocusableContainer should bind its keyboard handler to. Similar to →<code>ariaEl</code>,
   * this name is resolved to the →<code>ext.dom.Element</code> instance after rendering.
   * @default "el"
   * @see #ariaEl
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#property-focusableContainerEl Original Ext JS documentation of 'focusableContainerEl'
   */
  function get focusableContainerEl():*;

  function set focusableContainerEl(value:*):void;

  [ExtConfig] /**
   * DOM tabIndex attribute to set on
   * inactive Focusable children of this container when using the "Roaming tabindex"
   * technique. This value rarely needs to be changed from its default.
   * @default -1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-inactiveChildTabIndex Original Ext JS documentation of 'inactiveChildTabIndex'
   */
  function get inactiveChildTabIndex():Number;

  [ExtConfig] function set inactiveChildTabIndex(value:Number):void;

  [ExtConfig] /**
   * When <code>true</code>, FocusableContainer
   * will reset last focused position whenever focus leaves the container.
   * Subsequent tabbing into the container will always focus the first eligible
   * child item.
   * <p>When <code>false</code>, subsequent tabbing into the container will focus the child
   * item that was last focused before.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.FocusableContainer.html#cfg-resetFocusPosition Original Ext JS documentation of 'resetFocusPosition'
   */
  function get resetFocusPosition():Boolean;

  [ExtConfig] function set resetFocusPosition(value:Boolean):void;
}
}