package ext.mixin {
import ext.IMixin;

[Mixin("ext.mixin.Mashup")]
/**
 * This mixin allows users to easily require external scripts in their classes. This load
 * process delays application launch (<code>Ext.onReady</code>) until all such scripts are loaded
 * ensuring that your class will have access to its required scripts from the start.
 * <p>For example:</p>
 * <pre>
 *  Ext.define('Feed', {
 *      mixins: ['Ext.mixin.Mashup'],
 *
 *      requiredScripts: [
 *          '//www.foo.com/code/bar.js' // preserve http/s
 *      ],
 *
 *      // The code in "bar.js" will be available at application launch
 *  });
 * </pre>
 * <p>If your required script needs to be dynamic, for example it contains a key for an API, you can
 * use the →<code>ext.Manifest.mashup</code> object.</p>
 * @see ext.Manifest#mashup
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Mashup.html Original Ext JS documentation of 'Ext.mixin.Mashup'
 * @see ext.mixin.Mashup
 */
public interface IMashup extends IMixin {
  [ExtConfig] /**
   * Scripts that are required to be loaded in order for your Mashup to work.
   * These scripts can also use <i>template</i> (→<code>ext.Template</code>) syntax if there is data in the
   * →<code>ext.Manifest.mashup</code> object for the class <code>xtype</code>.
   * <p>For example, <code>Ext.ux.google.Map</code> needs an API key and so its <code>→requiredScripts</code> looks
   * like this:</p>
   * <pre>
   *  requiredScripts: {
   *      '//maps.googleapis.com/maps/api/js?key={key}'
   *  }
   * </pre>
   * <p>The <code>key</code> property is provided in <code>app.json</code> or directly in <code>Ext.manifest</code>:</p>
   * <pre>
   *  "mashup": {
   *      "map": {  // the xtype
   *          "key": "[GOOGLE_MAPS_KEY]"
   *      }
   *  }
   * </pre>
   * <p>For non-components (classes that have no <code>xtype</code>), the <code>mashupConfig</code> can be used
   * to supply the configuration key:</p>
   * <pre>
   *  mashupConfig: {
   *      key: 'map'
   *  }
   * </pre>
   * @see ext.Template
   * @see ext.Manifest#mashup
   * @see #requiredScripts
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Mashup.html#cfg-requiredScripts Original Ext JS documentation of 'requiredScripts'
   */
  function get requiredScripts():*;

  [ExtConfig] function set requiredScripts(value:*):void;
}
}