package ext.mixin {
import ext.Component;

[Mixin("ext.mixin.Queryable")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>A mixin for providing query related methods for →<code>ext.ComponentQuery</code> for classes that
 * implement getRefItems.</p>
 * @see ext.#ComponentQuery ext.ComponentQuery
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html Original Ext JS documentation of 'Ext.mixin.Queryable'
 * @see ext.mixin.Queryable
 */
public interface IQueryable {
  /**
   * Retrieves the first direct child of this container which matches the passed selector
   * or component. The passed in selector must comply with an Ext.ComponentQuery selector,
   * or it can be an actual Ext.Component.
   * @param selector An Ext.ComponentQuery selector. If no selector is
   * specified, the first child will be returned.
   * @return The matching child Ext.Component (or <code>null</code> if no match was found).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-child Original Ext JS documentation of 'child'
   */
  function child(selector:* = undefined):Component;

  /**
   * Retrieves the first descendant of this container which matches the passed selector.
   * The passed in selector must comply with an Ext.ComponentQuery selector, or it can be
   * an actual Ext.Component.
   * @param selector An Ext.ComponentQuery selector or Ext.Component.
   * If no selector is
   * specified, the first child will be returned.
   * @return The matching descendant Ext.Component (or <code>null</code> if no match
   * was found).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-down Original Ext JS documentation of 'down'
   */
  function down(selector:* = undefined):Component;

  [ArrayElementType("ext.Component")] /**
   * Retrieves all descendant components which match the passed selector.
   * Executes an Ext.ComponentQuery.query using this container as its root.
   * @param selector Selector complying to an Ext.ComponentQuery selector.
   * If no selector is specified all items will be returned.
   * @return Components which matched the selector
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-query Original Ext JS documentation of 'query'
   */
  function query(selector:String = null):Array;

  [ArrayElementType("ext.Component")] /**
   * Retrieves all descendant components which match the passed function.
   * The function should return false for components that are to be
   * excluded from the selection.
   * @param fn The matcher function. It will be called with a single argument,
   * the component being tested.
   * @param scope The scope in which to run the function. If not specified,
   * it will default to the active component.
   * @return Components matched by the passed function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-queryBy Original Ext JS documentation of 'queryBy'
   */
  function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * Finds a component at any level under this container matching the id/itemId.
   * This is a shorthand for calling ct.down('#' + id);
   * @param id The id to find
   * @return The matching id, null if not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-queryById Original Ext JS documentation of 'queryById'
   */
  function queryById(id:String):Component;

  /**
   * Traverses the tree rooted at this node in post-order mode, calling the passed function
   * on the nodes at each level. That is the function is called upon each node <b>after</b> being
   * called on its children).
   * <p>This method is used at each level down the cascade. Currently
   * →<code>ext.Component</code>s and →<code>ext.data.TreeModel</code>s are queryable.</p>
   * <p>If you have tree-structured data, you can make your nodes queryable, and use ComponentQuery
   * on them.</p>
   * @param selector A ComponentQuery selector used to filter candidate nodes before
   * calling the function. An empty string matches any node.
   * @param fn The function to call. Return <code>false</code> to abort the traverse.
   * <ul>
   * <li><code>node:Object</code> (optional) —
   * The node being visited.
   * </li>
   * </ul>
   * @param scope The context (<code>this</code> reference) in which the function is executed.
   * @param extraArgs A set of arguments to be appended to the function's argument list
   * to pass down extra data known to the caller <b>after</b> the node being visited.
   * @see ext.Component
   * @see ext.data.TreeModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-visitPostOrder Original Ext JS documentation of 'visitPostOrder'
   */
  function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * Traverses the tree rooted at this node in pre-order mode, calling the passed function
   * on the nodes at each level. That is the function is called upon each node <b>before</b>
   * being called on its children).
   * <p>This method is used at each level down the cascade. Currently
   * →<code>ext.Component</code>s and →<code>ext.data.TreeModel</code>s are queryable.</p>
   * <p>If you have tree-structured data, you can make your nodes queryable, and use ComponentQuery
   * on them.</p>
   * @param selector A ComponentQuery selector used to filter candidate nodes before
   * calling the function. An empty string matches any node.
   * @param fn The function to call. Return <code>false</code> to abort the traverse.
   * <ul>
   * <li><code>node:Object</code> (optional) —
   * The node being visited.
   * </li>
   * </ul>
   * @param scope The context (<code>this</code> reference) in which the function is executed.
   * @param extraArgs A set of arguments to be appended to the function's argument list
   * to pass down extra data known to the caller <b>after</b> the node being visited.
   * @see ext.Component
   * @see ext.data.TreeModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Queryable.html#method-visitPreOrder Original Ext JS documentation of 'visitPreOrder'
   */
  function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;
}
}