package ext.mixin {
import ext.Base;

[Native("Ext.mixin.ItemRippler", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.ItemRippler.html Original Ext JS documentation of 'Ext.mixin.ItemRippler'
 */
public class ItemRipplerMixin extends Base implements IItemRipplerMixin {
  [ExtConfig]
  [Bindable]
  /**
   * @default null
   * @since 6.5.0
   * <ul>
   * <li><code>color:String</code> (optional) —
   * The background color of the ripple.
   * Default ripple →<code>ext.Widget.ripple</code> settings for each item in the data view
   * <p>For complex items, individual elements can suppress ripples by adding the
   * <code>x-no-ripple</code> class to disable rippling for a tree of elements.</p>
   * </li>
   * </ul>
   * @see ext.Widget#ripple
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.ItemRippler.html#cfg-itemRipple Original Ext JS documentation of 'itemRipple'
   * @see #getItemRipple()
   * @see #setItemRipple()
   */
  public native function get itemRipple():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set itemRipple(value:*):void;

  /**
   * Returns the value of <code>itemRipple</code>.
   * @see #itemRipple
   */
  public native function getItemRipple():*;

  /**
   * Sets the value of <code>itemRipple</code>.
   * @param itemRipple The new value.
   * @see #itemRipple
   */
  public native function setItemRipple(itemRipple:*):void;
}
}