package ext.mixin {
import ext.Mixin;

[Native("Ext.mixin.Responsive", require)]
/**
 * This mixin provides classes with a <code>→responsiveConfig</code> config that allows instances to
 * conditionally control config properties. This mixin is typically applied to the
 * <code>→ext.Component</code> and <code>→ext.Widget</code> classes via the <code>→ext.Responsive</code> override:
 * <pre>
 *  Ext.application({
 *      requires: [
 *          'Ext.Responsive'
 *      ],
 *
 *      // ...
 *  });
 * </pre>
 * <p>Once this mixin is applied, config properties can be declaratively managed based on
 * current device characteristics (such as viewport width):</p>
 * <pre>
 *  Ext.create({
 *      xtype: 'panel',
 *      title: 'Some Title',
 *
 *      layout: {
 *          type: 'hbox
 *      },
 *
 *      responsiveConfig: {
 *          'width &lt; 800': {
 *              layout: {
 *                  vertical: true
 *              }
 *          },
 *          'width &gt;= 800': {
 *              layout: {
 *                  vertical: false
 *              }
 *          }
 *      }
 *  });
 * </pre>
 * <p>To use this mixin on other classes, you can mix it in directly:</p>
 * <pre>
 *  Ext.define('ResponsiveClass', {
 *      mixin: [
 *          'Ext.mixin.Responsive'
 *      ],
 *
 *      responsiveConfig: {
 *          portrait: {
 *          },
 *
 *          landscape: {
 *          }
 *      }
 *  });
 * </pre>
 * <p>For details see <code>→responsiveConfig</code>.</p>
 * @see #responsiveConfig
 * @see ext.Component
 * @see ext.Widget
 * @see ext.Responsive
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Responsive.html Original Ext JS documentation of 'Ext.mixin.Responsive'
 */
public class Responsive extends Mixin implements IResponsive {
  /**
   * @param config @inheritDoc
   */
  public function Responsive(config:Responsive = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * This object consists of keys that represent the conditions on which configs
   * will be applied. For example:
   * <pre>
   *  responsiveConfig: {
   *      landscape: {
   *          region: 'west'
   *      },
   *      portrait: {
   *          region: 'north'
   *      }
   *  }
   * </pre>
   * <p>In this case the keys ("landscape" and "portrait") are the criteria (or "rules")
   * and the object to their right contains the configs that will apply when that
   * rule is true.</p>
   * <p>These rules can be any valid JavaScript expression but the following values
   * are considered in scope:</p>
   * <ul>
   * <li><code>landscape</code> - True if the device orientation is landscape (always <code>true</code> on
   * desktop devices).</li>
   * <li><code>portrait</code> - True if the device orientation is portrait (always <code>false</code> on
   * desktop devices).</li>
   * <li><code>tall</code> - True if <code>width</code> &lt; <code>height</code> regardless of device type.</li>
   * <li><code>wide</code> - True if <code>width</code> &gt; <code>height</code> regardless of device type.</li>
   * <li><code>width</code> - The width of the viewport in pixels.</li>
   * <li><code>height</code> - The height of the viewport in pixels.</li>
   * <li><code>platform</code> - An object containing various booleans describing the platform
   * (see <code>→ext.Ext.platformTags</code>). The properties of this
   * object are also available implicitly (without "platform." prefix) but this
   * sub-object may be useful to resolve ambiguity (for example, if one of the
   * <code>→responsiveFormulas</code> overlaps and hides any of these properties).
   * Previous to Ext JS 5.1, the <code>platformTags</code> were only available using this
   * prefix.</li>
   * </ul>
   * <p>A more complex example:</p>
   * <pre>
   *  responsiveConfig: {
   *      'desktop || width &gt; 800': {
   *          region: 'west'
   *      },
   *
   *      '!(desktop || width &gt; 800)': {
   *          region: 'north'
   *      }
   *  }
   * </pre>
   * <p><b>NOTE</b>: If multiple rules set a single config (like above), it is important
   * that the rules be mutually exclusive. That is, only one rule should set each
   * config. If multiple rules are actively setting a single config, the order of
   * these (and therefore the config's value) is unspecified.</p>
   * <p>For a config to participate as a <code>→responsiveConfig</code> it must have a "setter"
   * method. In the above example, a "setRegion" method must exist.</p>
   * @default undefined
   * @since 5.0.0
   * @see ext.SExt#platformTags ext.Ext.platformTags
   * @see #responsiveFormulas
   * @see #responsiveConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Responsive.html#cfg-responsiveConfig Original Ext JS documentation of 'responsiveConfig'
   * @see #getResponsiveConfig()
   * @see #setResponsiveConfig()
   */
  public native function get responsiveConfig():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set responsiveConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * It is common when using <code>→responsiveConfig</code> to have recurring expressions that
   * make for complex configurations. Using <code>→responsiveFormulas</code> allows you to cut
   * down on this repetition by adding new properties to the "scope" for the rules
   * in a <code>→responsiveConfig</code>.
   * <p>For example:</p>
   * <pre>
   *  Ext.define('MyApp.view.main.Main', {
   *      extend: 'Ext.container.Container',
   *
   *      mixins: [
   *          'Ext.mixin.Responsive'
   *      ],
   *
   *      responsiveFormulas: {
   *          small: 'width &lt; 600',
   *
   *          medium: 'width &gt;= 600 &amp;&amp; width &lt; 800',
   *
   *          large: 'width &gt;= 800',
   *
   *          tuesday: function(context) {
   *              return (new Date()).getDay() === 2;
   *          }
   *      }
   *  });
   * </pre>
   * <p>With the above declaration, any <code>→responsiveConfig</code> can now use these values
   * like so:</p>
   * <pre>
   *  responsiveConfig: {
   *      small: {
   *          hidden: true
   *      },
   *      'medium &amp;&amp; !tuesday': {
   *          hidden: false,
   *          region: 'north'
   *      },
   *      large: {
   *          hidden: false,
   *          region: 'west'
   *      }
   *  }
   * </pre>
   * @since 5.0.1
   * @see #responsiveConfig
   * @see #responsiveFormulas
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Responsive.html#cfg-responsiveFormulas Original Ext JS documentation of 'responsiveFormulas'
   * @see #getResponsiveFormulas()
   * @see #setResponsiveFormulas()
   */
  public native function get responsiveFormulas():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set responsiveFormulas(value:Object):void;

  /**
   * This method removes this instance from the Responsive collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Responsive.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the value of <code>responsiveConfig</code>.
   * @see #responsiveConfig
   */
  public native function getResponsiveConfig():Object;

  /**
   * Returns the value of <code>responsiveFormulas</code>.
   * @see #responsiveFormulas
   */
  public native function getResponsiveFormulas():Object;

  /**
   * Sets the value of <code>responsiveConfig</code>.
   * @param responsiveConfig The new value.
   * @see #responsiveConfig
   */
  public native function setResponsiveConfig(responsiveConfig:Object):void;

  /**
   * Sets the value of <code>responsiveFormulas</code>.
   * @param responsiveFormulas The new value.
   * @see #responsiveFormulas
   */
  public native function setResponsiveFormulas(responsiveFormulas:Object):void;
}
}