package ext.mixin {
import ext.Base;

[Native("Ext.mixin.StoreWatcher", require)]
/**
 * This mixin is used to track and listen to the <code>store</code> of its <code>→owner</code> component. The
 * component must support a <code>storechange</code> event (as do grids and dataviews) as well as
 * a <code>getStore</code> method.
 * @see #owner
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.StoreWatcher.html Original Ext JS documentation of 'Ext.mixin.StoreWatcher'
 */
public class StoreWatcherMixin extends Base {
  [ExtConfig]
  [Bindable]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.StoreWatcher.html#cfg-owner Original Ext JS documentation of 'owner'
   * @see #getOwner()
   * @see #setOwner()
   */
  public native function get owner():Base;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set owner(value:Base):void;

  [ExtConfig]
  [Bindable]
  /**
   * The events and associated handlers to which to listen on the <code>→owner</code>.
   * @default {
   *     destroyable: true,
   *     storechange: 'onOwnerStoreChange'
   * }
   * @see #owner
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.StoreWatcher.html#cfg-ownerListeners Original Ext JS documentation of 'ownerListeners'
   * @see #getOwnerListeners()
   * @see #setOwnerListeners()
   */
  public native function get ownerListeners():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ownerListeners(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The events and associated handlers to which to listen on the <code>source</code> of the
   * connected <code>store</code>. That is, these listeners are attached to the unfiltered
   * collection. When <code>remoteFilter</code> is <code>true</code> there is no unfiltered collection so
   * these listeners are attached to the only collection that exists (which is
   * filtered by the server).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.StoreWatcher.html#cfg-sourceListeners Original Ext JS documentation of 'sourceListeners'
   * @see #getSourceListeners()
   * @see #setSourceListeners()
   */
  public native function get sourceListeners():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sourceListeners(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The events and associated handlers to which to listen on the <code>store</code> of the
   * <code>→owner</code>.
   * @see #owner
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.StoreWatcher.html#cfg-storeListeners Original Ext JS documentation of 'storeListeners'
   * @see #getStoreListeners()
   * @see #setStoreListeners()
   */
  public native function get storeListeners():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set storeListeners(value:Object):void;

  /**
   * Returns the value of <code>owner</code>.
   * @see #owner
   */
  public native function getOwner():Base;

  /**
   * Returns the value of <code>ownerListeners</code>.
   * @see #ownerListeners
   */
  public native function getOwnerListeners():Object;

  /**
   * Returns the value of <code>sourceListeners</code>.
   * @see #sourceListeners
   */
  public native function getSourceListeners():Object;

  /**
   * Returns the value of <code>storeListeners</code>.
   * @see #storeListeners
   */
  public native function getStoreListeners():Object;

  /**
   * Sets the value of <code>owner</code>.
   * @param owner The new value.
   * @see #owner
   */
  public native function setOwner(owner:Base):void;

  /**
   * Sets the value of <code>ownerListeners</code>.
   * @param ownerListeners The new value.
   * @see #ownerListeners
   */
  public native function setOwnerListeners(ownerListeners:Object):void;

  /**
   * Sets the value of <code>sourceListeners</code>.
   * @param sourceListeners The new value.
   * @see #sourceListeners
   */
  public native function setSourceListeners(sourceListeners:Object):void;

  /**
   * Sets the value of <code>storeListeners</code>.
   * @param storeListeners The new value.
   * @see #storeListeners
   */
  public native function setStoreListeners(storeListeners:Object):void;
}
}