package ext.mixin.events {
import ext.Base;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.mixin.events.Dirty_dirtyEvent")]
public class Dirty_dirtyEvent extends FlExtEvent {
  /**
   * Fires when a change in the object's →<code>dirty</code> state is detected.
   * <p><b>Note:</b> In order for this event to fire, the class that mixes in this mixin
   * must be <code>→ext.mixin.Observable</code>.</p>
   * @see ext.mixin.Dirty#dirty
   * @see ext.mixin.Observable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Dirty.html#event-dirtychange Original Ext JS documentation of 'dirtychange'
   * @see ext.mixin.Dirty
   * @eventType onDirtyChange
   */
  public static const DIRTY_CHANGE:String = "onDirtyChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "dirty", "eOpts"];

  public function Dirty_dirtyEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Whether or not the object is now dirty.
   */
  public native function get dirty():Boolean;

  public native function get source():Base;
}
}