package ext {

[Native("Ext.os", require)]
/**
 * Provides useful information about the current operating system environment.
 * <p>Example:</p>
 * <pre>
 * if (Ext.os.is.Windows) {
 *     // Windows specific code here
 * }
 *
 * if (Ext.os.is.iOS) {
 *     // iPad, iPod, iPhone, etc.
 * }
 *
 * console.log("Version " + Ext.os.version);
 * </pre>
 * <p>For a full list of supported values, refer to the →<code>matches()</code> property/method.</p>
 * @see Sos#matches()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.os.html Original Ext JS documentation of 'Ext.os'
 */
public const os:Sos = new Sos;
}