package ext.panel {
import ext.Component;
import ext.container.Container;
import ext.container.IDockingContainer;
import ext.dom.Element;
import ext.toolbar.Toolbar;

[Native("Ext.panel.Panel", require)]
/**
 * @see ext.panel.events.Panel_component_indexEvent.DOCKED_ADD
 * @eventType ext.panel.events.Panel_component_indexEvent.DOCKED_ADD
 */
[Event(name='onDockedAdd', type='ext.panel.events.Panel_component_indexEvent')]
/**
 * @see ext.panel.events.Panel_componentEvent.DOCKED_REMOVE
 * @eventType ext.panel.events.Panel_componentEvent.DOCKED_REMOVE
 */
[Event(name='onDockedRemove', type='ext.panel.events.Panel_componentEvent')]
/**
 * @see ext.panel.events.PanelEvent.BEFORE_CLOSE
 * @eventType ext.panel.events.PanelEvent.BEFORE_CLOSE
 */
[Event(name='onBeforeClose', type='ext.panel.events.PanelEvent')]
/**
 * @see ext.panel.events.Panel_direction_animateEvent.BEFORE_COLLAPSE
 * @eventType ext.panel.events.Panel_direction_animateEvent.BEFORE_COLLAPSE
 */
[Event(name='onBeforeCollapse', type='ext.panel.events.Panel_direction_animateEvent')]
/**
 * @see ext.panel.events.Panel_animateEvent.BEFORE_EXPAND
 * @eventType ext.panel.events.Panel_animateEvent.BEFORE_EXPAND
 */
[Event(name='onBeforeExpand', type='ext.panel.events.Panel_animateEvent')]
/**
 * @see ext.panel.events.PanelEvent.CLOSE
 * @eventType ext.panel.events.PanelEvent.CLOSE
 */
[Event(name='onClose', type='ext.panel.events.PanelEvent')]
/**
 * @see ext.panel.events.PanelEvent.COLLAPSE
 * @eventType ext.panel.events.PanelEvent.COLLAPSE
 */
[Event(name='onCollapse', type='ext.panel.events.PanelEvent')]
/**
 * @see ext.panel.events.PanelEvent.EXPAND
 * @eventType ext.panel.events.PanelEvent.EXPAND
 */
[Event(name='onExpand', type='ext.panel.events.PanelEvent')]
/**
 * @see ext.panel.events.PanelEvent.FLOAT
 * @eventType ext.panel.events.PanelEvent.FLOAT
 */
[Event(name='onFloat', type='ext.panel.events.PanelEvent')]
/**
 * @see ext.panel.events.Panel_newGlyph_oldGlyphEvent.GLYPH_CHANGE
 * @eventType ext.panel.events.Panel_newGlyph_oldGlyphEvent.GLYPH_CHANGE
 */
[Event(name='onGlyphChange', type='ext.panel.events.Panel_newGlyph_oldGlyphEvent')]
/**
 * @see ext.panel.events.Panel_newIconAlign_oldIconAlignEvent.ICON_ALIGN_CHANGE
 * @eventType ext.panel.events.Panel_newIconAlign_oldIconAlignEvent.ICON_ALIGN_CHANGE
 */
[Event(name='onIconAlignChange', type='ext.panel.events.Panel_newIconAlign_oldIconAlignEvent')]
/**
 * @see ext.panel.events.Panel_newIcon_oldIconEvent.ICON_CHANGE
 * @eventType ext.panel.events.Panel_newIcon_oldIconEvent.ICON_CHANGE
 */
[Event(name='onIconChange', type='ext.panel.events.Panel_newIcon_oldIconEvent')]
/**
 * @see ext.panel.events.Panel_newIconCls_oldIconClsEvent.ICON_CLS_CHANGE
 * @eventType ext.panel.events.Panel_newIconCls_oldIconClsEvent.ICON_CLS_CHANGE
 */
[Event(name='onIconClsChange', type='ext.panel.events.Panel_newIconCls_oldIconClsEvent')]
/**
 * @see ext.panel.events.Panel_newTitleAlign_oldTitleAlignEvent.TITLE_ALIGN_CHANGE
 * @eventType ext.panel.events.Panel_newTitleAlign_oldTitleAlignEvent.TITLE_ALIGN_CHANGE
 */
[Event(name='onTitleAlignChange', type='ext.panel.events.Panel_newTitleAlign_oldTitleAlignEvent')]
/**
 * @see ext.panel.events.Panel_newTitle_oldTitleEvent.TITLE_CHANGE
 * @eventType ext.panel.events.Panel_newTitle_oldTitleEvent.TITLE_CHANGE
 */
[Event(name='onTitleChange', type='ext.panel.events.Panel_newTitle_oldTitleEvent')]
/**
 * @see ext.panel.events.Panel_newTitlePosition_oldTitlePositionEvent.TITLE_POSITION_CHANGE
 * @eventType ext.panel.events.Panel_newTitlePosition_oldTitlePositionEvent.TITLE_POSITION_CHANGE
 */
[Event(name='onTitlePositionChange', type='ext.panel.events.Panel_newTitlePosition_oldTitlePositionEvent')]
/**
 * @see ext.panel.events.Panel_newTitleRotation_oldTitleRotationEvent.TITLE_ROTATION_CHANGE
 * @eventType ext.panel.events.Panel_newTitleRotation_oldTitleRotationEvent.TITLE_ROTATION_CHANGE
 */
[Event(name='onTitleRotationChange', type='ext.panel.events.Panel_newTitleRotation_oldTitleRotationEvent')]
/**
 * @see ext.panel.events.PanelEvent.UNFLOAT
 * @eventType ext.panel.events.PanelEvent.UNFLOAT
 */
[Event(name='onUnfloat', type='ext.panel.events.PanelEvent')]
/**
 * Panel is a container that has specific functionality and structural components that make it
 * the perfect building block for application-oriented user interfaces.
 * <p>Panels are, by virtue of their inheritance from →<code>ext.container.Container</code>, capable of being
 * configured with a →<code>ext.container.Container.layout</code>, and containing child Components.</p>
 * <p>When either specifying child →<code>items</code> of a Panel, or dynamically
 * <i>adding</i> (→<code>ext.container.Container.add()</code>) Components to a Panel, remember to consider
 * how you wish the Panel to arrange those child elements, and whether those child elements
 * need to be sized using one of Ext's built-in <code>→ext.container.Container.layout</code>
 * schemes. By default, Panels use the →<code>ext.layout.container.AutoLayout</code> scheme. This simply
 * renders child components, appending them one after the other inside the Container,
 * and <b>does not apply any sizing</b> at all.</p>
 * <p>A Panel may also contain <i>bottom</i> (→<code>bbar</code>) and <i>top</i> (→<code>tbar</code>) toolbars, along with separate
 * <i>header</i> (→<code>ext.panel.PanelHeader</code>), <i>footer</i> (→<code>fbar</code>) and body sections.</p>
 * <p>Panel also provides built-in <i>collapsible, expandable</i> (→<code>collapsible</code>) and →<code>closable</code>
 * behavior. Panels can be easily dropped into any →<code>ext.container.Container</code>
 * or layout, and the layout and rendering pipeline is
 * <i>completely managed by the framework</i> (→<code>ext.container.Container.add()</code>).</p>
 * <p><b>Note:</b> By default, the <code>close (→closable)</code> header tool <i>destroys</i> the Panel resulting
 * in removal of the Panel and the destruction of any descendant Components. This makes the Panel
 * object, and all its descendants <b>unusable</b>. To enable the close tool to simply <i>hide</i> a Panel
 * for later re-use, configure the Panel with <code>→closeAction: 'hide'</code>.</p>
 * <p>Usually, Panels are used as constituents within an application, in which case, they would be used
 * as child items of Containers, and would themselves use Ext.Components as child
 * →<code>items</code>. However to illustrate simply rendering a Panel into the document,
 * here's how to do it:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Hello',
 *     width: 200,
 *     html: '&lt;p&gt;World!&lt;/p&gt;',
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>A more realistic scenario is a Panel created to house input fields which will not be rendered,
 * but used as a constituent part of a Container:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var filterPanel = Ext.create('Ext.panel.Panel', {
 *     bodyPadding: 5,  // Don't want content to crunch against the borders
 *     width: 300,
 *     title: 'Filters',
 *     items: [{
 *         xtype: 'datefield',
 *         fieldLabel: 'Start date'
 *     }, {
 *         xtype: 'datefield',
 *         fieldLabel: 'End date'
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>Note that the Panel above is configured to render into the document and assigned a size.
 * In a real world scenario, the Panel will often be added inside a Container which will use a
 * →<code>layout</code> to render, size and position its child Components.</p>
 * <p>Panels will often use specific →<code>layout</code>s to provide an application with shape
 * and structure by containing and arranging child Components:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var resultsPanel = Ext.create('Ext.panel.Panel', {
 *     title: 'Results',
 *     width: 600,
 *     height: 400,
 *     renderTo: Ext.getBody(),
 *     layout: {
 *         type: 'vbox',       // Arrange child items vertically
 *         align: 'stretch',    // Each takes up full width
 *         padding: 5
 *     },
 *     items: [{
 *         // Results grid specified as a config object with an xtype of 'grid'
 *         xtype: 'grid',
 *         // One header just for show. There's no data
 *         columns: [{header: 'Column One'}],
 *         store: Ext.create('Ext.data.ArrayStore', {}), // A dummy empty data store
 *         // Use 1/3 of Container's height (hint to Box layout)
 *         flex: 1
 *     }, {
 *         xtype: 'splitter'   // A splitter between the two child items
 *     }, {
 *         // Details Panel specified as a config object (no xtype defaults to 'panel').
 *         title: 'Details',
 *         bodyPadding: 5,
 *         items: [{
 *             fieldLabel: 'Data item',
 *             xtype: 'textfield'
 *         }], // An array of form fields
 *         flex: 2             // Use 2/3 of Container's height (hint to Box layout)
 *     }]
 * });
 * </pre>
 * <p>The example illustrates one possible method of displaying search results. The Panel contains
 * a grid with the resulting data arranged in rows. Each selected row may be displayed in detail
 * in the Panel below. The <i>vbox</i> (→<code>ext.layout.container.VBoxLayout</code>) layout is used to arrange
 * the two vertically. It is configured to stretch child items horizontally to full width.
 * Child items may either be configured with a numeric height, or with a <code>→flex</code> value to distribute
 * available space proportionately.</p>
 * <p>This Panel itself may be a child item of, for example, a →<code>ext.tab.TabPanel</code> which
 * will size its child items to fit within its content area.</p>
 * <p>Using these techniques, as long as the <b>layout</b> is chosen and configured correctly,
 * an application may have any level of nested containment, all dynamically sized according to
 * configuration, the user's preference and available
 * browser size.</p>
 * @see ext.container.Container
 * @see ext.container.Container#layout
 * @see #items
 * @see ext.container.Container#add()
 * @see ext.layout.container.AutoLayout
 * @see #bbar
 * @see #tbar
 * @see ext.panel.PanelHeader
 * @see #fbar
 * @see #collapsible
 * @see #closable
 * @see #closeAction
 * @see #layout
 * @see ext.layout.container.VBoxLayout
 * @see #flex
 * @see ext.tab.TabPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html Original Ext JS documentation of 'Ext.panel.Panel'
 */
public class Panel extends Container implements IDockingContainer {
  /**
   * @param config @inheritDoc
   */
  public function Panel(config:Panel = null) {
    super();
  }

  [ExtConfig]
  /**
   * <code>true</code> to animate the transition when the panel is collapsed, <code>false</code> to skip the animation
   * (defaults to <code>true</code> if the →<code>ext.fx.Anim</code> class is available, otherwise <code>false</code>).
   * May also be specified as the animation duration in milliseconds.
   * @default Ext.enableFx
   * @see ext.fx.Anim
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-animCollapse Original Ext JS documentation of 'animCollapse'
   */
  public native function get animCollapse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animCollapse(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'panel'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * Convenience config. Short for 'Bottom Bar'.
   * <pre>
   * bbar: [
   *   { xtype: 'button', text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'bottom',
   *     items: [
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-bbar Original Ext JS documentation of 'bbar'
   */
  public native function get bbar():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bbar(value:*):void;

  /**
   * The Panel's body →<code>ext.dom.Element</code> which may be used to contain HTML content.
   * The content may be specified in the →<code>html</code> config, or it may be loaded using the
   * →<code>loader</code> config. Read-only.
   * <p>If this is used to load visible HTML elements in either way, then
   * the Panel may not be used as a Layout for hosting nested Panels.</p>
   * <p>If this Panel is intended to be used as the host of a Layout (See →<code>layout</code>
   * then the body Element must not be loaded or changed - it is under the control
   * of the Panel's Layout.</p>
   * @see ext.dom.Element
   * @see #html
   * @see #loader
   * @see #layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#property-body Original Ext JS documentation of 'body'
   */
  public native function get body():Element;

  [ExtConfig]
  /**
   * A shortcut to add or remove the border on the body of a panel. In the classic theme
   * this only applies to a panel which has the →<code>frame</code> configuration set to <code>true</code>.
   * @since 2.3.0
   * @see #frame
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-bodyBorder Original Ext JS documentation of 'bodyBorder'
   */
  public native function get bodyBorder():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyBorder(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class, space-delimited string of classes, or array of classes to be applied
   * to the panel's body element. The following examples are all valid:
   * <pre>
   * bodyCls: 'foo'
   * bodyCls: 'foo bar'
   * bodyCls: ['foo', 'bar']
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-bodyCls Original Ext JS documentation of 'bodyCls'
   */
  public native function get bodyCls():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyCls(value:*):void;

  [ExtConfig]
  /**
   * A shortcut for setting a padding style on the body element. The value can either be
   * a number to be applied to all sides, or a normal css string describing padding.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-bodyPadding Original Ext JS documentation of 'bodyPadding'
   */
  public native function get bodyPadding():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyPadding(value:*):void;

  [ExtConfig]
  /**
   * Custom CSS styles to be applied to the panel's body element, which can be supplied
   * as a valid CSS style string, an object containing style property name/value pairs
   * or a function that returns such a string or object.
   * For example, these two formats are interpreted to be equivalent:
   * <pre>
   * bodyStyle: 'background:#ffc; padding:10px;'
   *
   * bodyStyle: {
   *     background: '#ffc',
   *     padding: '10px'
   * }
   * </pre>
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-bodyStyle Original Ext JS documentation of 'bodyStyle'
   */
  public native function get bodyStyle():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyStyle(value:*):void;

  [ExtConfig]
  /**
   * Specify as <code>false</code> to render the Panel with zero width borders.
   * <p>Leaving the value as <code>true</code> uses the selected theme's
   * →<code>ext.panel.Panel.style:$panel-border-width</code></p>
   * <p>Defaults to <code>false</code> when using or extending Neptune.</p>
   * <p><b>Note:</b> is ignored when →<code>frame</code> is set to <b>true</b>.</p>
   * @default true
   * @see ext.panel.Panel#style:$panel-border-width
   * @see #frame
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-border Original Ext JS documentation of 'border'
   * @see #setBorder()
   */
  override public native function get border():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set border(value:*):void;

  [ExtConfig]
  /**
   * The alignment of any buttons added to this panel. Valid values are 'right', 'left'
   * and 'center' (defaults to 'right' for buttons/fbar, 'left' for other toolbar types).
   * <p><b>NOTE:</b> The preferred way to specify toolbars is to use the dockedItems config.
   * Instead of buttonAlign you would add the layout: { pack: 'start' | 'center' | 'end' } option
   * to the dockedItem config.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-buttonAlign Original Ext JS documentation of 'buttonAlign'
   */
  public native function get buttonAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonAlign(value:String):void;

  [ExtConfig]
  /**
   * Convenience config used for adding buttons docked to the bottom of the panel. This is a
   * synonym for the →<code>fbar</code> config.
   * <pre>
   * buttons: [
   *   { text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'bottom',
   *     ui: 'footer',
   *     defaults: {
   *         minWidth: 200
   *     },
   *     items: [
   *         { xtype: 'component', flex: 1 },
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * <p>The →<code>minButtonWidth</code> is used as the default
   * →<code>ext.button.Button.minWidth</code> for each of the buttons in the buttons toolbar.</p>
   * @see #fbar
   * @see #minButtonWidth
   * @see ext.button.Button#minWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-buttons Original Ext JS documentation of 'buttons'
   */
  public native function get buttons():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttons(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'bodyWrap',
   *     'body'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to display the 'close' tool button and allow the user to close the window,
   * false to hide the button and disallow closing the window.
   * <p>By default, when close is requested by clicking the close button in the header,
   * the →<code>close()</code> method will be called. This will
   * <i>destroy (→<code>ext.Component.destroy()</code>)</i> the Panel and its content
   * meaning that it may not be reused.</p>
   * <p>To make closing a Panel <i>hide</i> the Panel so that it may be reused, set →<code>closeAction</code>
   * to 'hide'.</p>
   * @default false
   * @see #close()
   * @see ext.Component#destroy()
   * @see #closeAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-closable Original Ext JS documentation of 'closable'
   * @see #getClosable()
   * @see #setClosable()
   */
  public native function get closable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set closable(value:Boolean):void;

  [ExtConfig]
  /**
   * The action to take when the close header tool is clicked...
   * <ul>
   * <li>
   * <p><b><code>'→destroy()'</code></b> :</p>
   * <p>→<code>remove()</code> the window from the DOM and
   * →<code>ext.Component.destroy()</code> it and all descendant Components.
   * The window will <b>not</b> be available to be redisplayed via the →<code>show()</code> method.</p>
   * </li>
   * <li>
   * <p><b><code>'→hide()'</code></b> :</p>
   * <p>→<code>hide()</code> the window by setting visibility to hidden and applying negative
   * offsets. The window will be available to be redisplayed via the →<code>show()</code>
   * method.</p>
   * </li>
   * </ul>
   * <p><b>Note:</b> This behavior has changed! setting <i>does</i> affect the →<code>close()</code> method
   * which will invoke the appropriate closeAction.</p>
   * @default 'destroy'
   * @see #destroy()
   * @see #remove()
   * @see ext.Component#destroy()
   * @see #show()
   * @see #hide()
   * @see #close()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-closeAction Original Ext JS documentation of 'closeAction'
   */
  public native function get closeAction():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set closeAction(value:String):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when the <b>close</b>
   * <i>tool</i> (→<code>ext.panel.Tool</code>) is focused. Will also be set as the close tool's
   * →<code>ext.panel.Tool.tooltip</code> text.
   * <p><b>Note:</b> Applicable when the panel is →<code>closable</code>: true</p>
   * @default 'Close panel'
   * @see ext.panel.Tool
   * @see ext.panel.Tool#tooltip
   * @see #closable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-closeToolText Original Ext JS documentation of 'closeToolText'
   */
  public native function get closeToolText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set closeToolText(value:String):void;

  [ExtConfig]
  /**
   * The direction to collapse the Panel when the toggle button is clicked.
   * <p>Defaults to the →<code>headerPosition</code></p>
   * <p><b>Important: This config is <i>ignored</i> for →<code>collapsible</code> Panels which are direct child
   * items of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).</b></p>
   * <p>Specify as <code>'top'</code>, <code>'bottom'</code>, <code>'left'</code> or <code>'right'</code>.</p>
   * @see #headerPosition
   * @see #collapsible
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapseDirection Original Ext JS documentation of 'collapseDirection'
   */
  public native function get collapseDirection():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseDirection(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> to make sure the collapse/expand toggle button always renders first (to the left of)
   * any other tools in the panel's title bar, <code>false</code> to render it last.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapseFirst Original Ext JS documentation of 'collapseFirst'
   */
  public native function get collapseFirst():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseFirst(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Important: this config is only effective for →<code>collapsible</code> Panels which are direct
   * child items of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).</b>
   * <p>When <i>not</i> a direct child item of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>),
   * then the Panel's header remains visible, and the body is collapsed to zero dimensions.
   * If the Panel has no header, then a new header (orientated correctly depending on the
   * →<code>collapseDirection</code>) will be inserted to show a the title and a re-expand tool.</p>
   * <p>When a child item of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>), this config
   * has three possible values:</p>
   * <ul>
   * <li>
   * <p><code>undefined</code> - When collapsed, a placeholder →<code>ext.panel.PanelHeader</code> is injected
   * into the layout to represent the Panel and to provide a UI with a Tool to allow the user
   * to re-expand the Panel.</p>
   * </li>
   * <li>
   * <p><code>"header"</code> - The Panel collapses to leave its header visible as when not inside a
   * <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).</p>
   * </li>
   * <li>
   * <p><code>"mini"</code> - The Panel collapses without a visible header.</p>
   * </li>
   * </ul>
   * @see #collapsible
   * @see ext.layout.container.BorderLayout
   * @see #collapseDirection
   * @see ext.panel.PanelHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapseMode Original Ext JS documentation of 'collapseMode'
   */
  public native function get collapseMode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseMode(value:String):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when <b>collapse</b>
   * <i>tool</i> (→<code>ext.panel.Tool</code>) is focused. Will also be set as the collapse tool's
   * →<code>ext.panel.Tool.tooltip</code> text.
   * <p><b>Note:</b> Applicable when the panel is →<code>collapsible</code>: true</p>
   * @default 'Collapse panel'
   * @see ext.panel.Tool
   * @see ext.panel.Tool#tooltip
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapseToolText Original Ext JS documentation of 'collapseToolText'
   */
  public native function get collapseToolText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseToolText(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * <code>true</code> to render the panel collapsed, <code>false</code> to render it expanded.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapsed Original Ext JS documentation of 'collapsed'
   * @see #getCollapsed()
   * @see #setCollapsed()
   */
  public native function get collapsed():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set collapsed(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class to add to the panel's element after it has been collapsed.
   * @default 'collapsed'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapsedCls Original Ext JS documentation of 'collapsedCls'
   */
  public native function get collapsedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsedCls(value:String):void;

  [ExtConfig]
  /**
   * True to make the panel collapsible and have an expand/collapse toggle Tool added
   * into the header tool button area. False to keep the panel sized either statically,
   * or by an owning layout manager, with no toggle Tool.
   * When a panel is used in a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>), the
   * →<code>floatable</code> option can influence the behavior of collapsing.
   * See →<code>collapseMode</code> and →<code>collapseDirection</code>
   * @default undefined
   * @see ext.layout.container.BorderLayout
   * @see #floatable
   * @see #collapseMode
   * @see #collapseDirection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-collapsible Original Ext JS documentation of 'collapsible'
   */
  public native function get collapsible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsible(value:Boolean):void;

  [ExtConfig]
  /**
   * The sizing and positioning of a Component's internal Elements is the responsibility
   * of the Component's layout manager which sizes a Component's internal structure in response
   * to the Component being sized.
   * <p>Generally, developers will not use this configuration as all provided Components which need
   * their internal elements sizing (Such as <i>input fields</i> (→<code>ext.form.field.BaseField</code>)) come with
   * their own componentLayout managers.</p>
   * <p>The <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used on instances of the
   * base Ext.Component class which simply sizes the Component's encapsulating element to the
   * height and width specified in the →<code>setSize()</code> method.</p>
   * @default 'dock'
   * @see ext.form.field.BaseField
   * @see ext.layout.container.AutoLayout
   * @see #setSize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-componentLayout Original Ext JS documentation of 'componentLayout'
   */
  override public native function get componentLayout():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set componentLayout(value:*):void;

  [ExtConfig]
  /**
   * True to constrain the panel within its containing element, false to allow it to fall outside
   * of its containing element. By default floating components such as Windows will be rendered to
   * <code>document.body</code>. To render and constrain the window within another element specify
   * →<code>renderTo</code>. Optionally the header only can be constrained using
   * →<code>constrainHeader</code>.
   * @default false
   * @see #renderTo
   * @see #constrainHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  override public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set constrain(value:Boolean):void;

  [ExtConfig]
  /**
   * True to constrain the panel header within its containing element (allowing the panel body
   * to fall outside of its containing element) or false to allow the header to fall outside
   * its containing element.
   * Optionally the entire panel can be constrained using →<code>constrain</code>.
   * @default false
   * @see #constrain
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-constrainHeader Original Ext JS documentation of 'constrainHeader'
   */
  public native function get constrainHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainHeader(value:Boolean):void;

  /**
   * The name of the padding property that is used by the layout to manage
   * padding. See →<code>ext.layout.container.AutoLayout.managePadding</code>
   * @default 'bodyPadding'
   * @see ext.layout.container.AutoLayout#managePadding
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#property-contentPaddingProperty Original Ext JS documentation of 'contentPaddingProperty'
   */
  override public native function get contentPaddingProperty():String;

  /**
   * @private
   */
  override public native function set contentPaddingProperty(value:String):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'title'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * Reference name of the component to act as the default button for this Panel.
   * Default button is activated by pressing Enter key while focus is contained within
   * the Panel's →<code>defaultButtonTarget</code>.
   * <p>The most obvious use for <code>→defaultButton</code> is submitting a form:</p>
   * <pre>
   *  var loginWindow = new Ext.window.Window({
   *      autoShow: true,
   *      width: 300,
   *      layout: 'form',
   *      title: 'Enter login information',
   *      referenceHolder: true,
   *      defaultFocus: 'textfield',
   *      defaultButton: 'okButton',
   *
   *      items: [{
   *          xtype: 'textfield',
   *          fieldLabel: 'User name'
   *      }, {
   *          xtype: 'textfield',
   *          fieldLabel: 'Password'
   *      }],
   *
   *      buttons: [{
   *          reference: 'okButton',
   *          text: 'Login',
   *          handler: function() {
   *              Ext.Msg.alert('Submit', 'Your login is being processed');
   *          }
   *      }]
   *  });
   * </pre>
   * @see #defaultButtonTarget
   * @see #defaultButton
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-defaultButton Original Ext JS documentation of 'defaultButton'
   */
  public native function get defaultButton():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultButton(value:String):void;

  [ExtConfig]
  /**
   * Name of the element that will be the target of
   * →<code>defaultButton</code> keydown listener. The default element is Panel body, which
   * means that pressing Enter key while focus is on docked items will not fire <code>→defaultButton</code>
   * action.
   * <p>If you want <code>→defaultButton</code> action to fire in docked items, set this config to <code>"el"</code>.</p>
   * @see #defaultButton
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-defaultButtonTarget Original Ext JS documentation of 'defaultButtonTarget'
   */
  public native function get defaultButtonTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultButtonTarget(value:String):void;

  [ExtConfig]
  /**
   * This object holds the default weights applied to dockedItems that have no weight.
   * These start with a weight of 1, to allow negative weights to insert before top items
   * and are odd numbers so that even weights can be used to get between different dock orders.
   * <p>To make default docking order match border layout, do this:</p>
   * <pre>
   *  Ext.panel.Panel.prototype.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };
   * </pre>
   * <p>Changing these defaults as above or individually on this object will effect all Panels.
   * To change the defaults on a single panel, you should replace the entire object:</p>
   * <pre>
   *  initComponent: function() {
   *      // NOTE: Don't change members of defaultDockWeights since the object is shared.
   *      this.defaultDockWeights = { top: 1, bottom: 3, left: 5, right: 7 };
   *
   *      this.callParent();
   *  }
   * </pre>
   * <p>To change only one of the default values, you do this:</p>
   * <pre>
   *  initComponent: function() {
   *      // NOTE: Don't change members of defaultDockWeights since the object is shared.
   *      this.defaultDockWeights = Ext.applyIf({ top: 10 }, this.defaultDockWeights);
   *
   *      this.callParent();
   *  }
   * </pre>
   * @default {
   *     top: {
   *         render: 1,
   *         visual: 1
   *     },
   *     left: {
   *         render: 3,
   *         visual: 5
   *     },
   *     right: {
   *         render: 5,
   *         visual: 7
   *     },
   *     bottom: {
   *         render: 7,
   *         visual: 3
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#cfg-defaultDockWeights Original Ext JS documentation of 'defaultDockWeights'
   */
  public native function get defaultDockWeights():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultDockWeights(value:Object):void;

  [ExtConfig]
  [ArrayElementType("ext.Component")]
  /**
   * A component or series of components to be added as docked items to this panel. The docked
   * items can be docked to either the top, right, left or bottom of a panel. This is typically
   * used for things like toolbars or tab bars:
   * <pre>
   * var panel = new Ext.panel.Panel({
   *     dockedItems: [{
   *         xtype: 'toolbar',
   *         dock: 'top',
   *         items: [{
   *             text: 'Docked to the top'
   *         }]
   *     }]
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-dockedItems Original Ext JS documentation of 'dockedItems'
   */
  public native function get dockedItems():Array;

  [ExtConfig]
  [ArrayElementType("ext.Component")]
  /**
   * @private
   */
  public native function set dockedItems(value:Array):void;

  [ExtConfig]
  /**
   * Specify as true to make a →<code>floating</code> Component draggable using the Component's
   * encapsulating element as the drag handle.
   * <p>This may also be specified as a config object for the
   * →<code>ext.util.ComponentDragger</code> which is instantiated to perform dragging.</p>
   * <p>For example to create a Component which may only be dragged around using a certain internal
   * element as the drag handle, use the delegate option:</p>
   * <pre>
   * new Ext.Component({
   *     constrain: true,
   *     floating: true,
   *     style: {
   *         backgroundColor: '#fff',
   *         border: '1px solid black'
   *     },
   *     html: '&lt;h1 style="cursor:move"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',
   *     draggable: {
   *         delegate: 'h1'
   *     }
   * }).show();
   * </pre>
   * <p><b>NOTE:</b> The private →<code>null</code> class is used instead of
   * ComponentDragger when →<code>simpleDrag</code> is false (<i>default</i>). In this case you
   * may pass a config for →<code>ext.dd.DragSource</code>.</p>
   * <p>See also →<code>dd</code>.</p>
   * @default false
   * @see #floating
   * @see ext.util.ComponentDragger
   * @see null
   * @see #simpleDrag
   * @see ext.dd.DragSource
   * @see #dd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-draggable Original Ext JS documentation of 'draggable'
   */
  override public native function get draggable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set draggable(value:*):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when <b>expand</b> <i>tool</i> (→<code>ext.panel.Tool</code>)
   * is focused. Will also be set as the expand tool's
   * →<code>ext.panel.Tool.tooltip</code> text.
   * <p><b>Note:</b> Applicable when the panel is →<code>collapsible</code>: true</p>
   * @default 'Expand panel'
   * @see ext.panel.Tool
   * @see ext.panel.Tool#tooltip
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-expandToolText Original Ext JS documentation of 'expandToolText'
   */
  public native function get expandToolText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandToolText(value:String):void;

  [ExtConfig]
  /**
   * Convenience config used for adding items to the bottom of the panel. Short for Footer Bar.
   * <pre>
   * fbar: [
   *   { type: 'button', text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'bottom',
   *     ui: 'footer',
   *     defaults: {
   *         minWidth: 200
   *     },
   *     items: [
   *         { xtype: 'component', flex: 1 },
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * <p>The →<code>minButtonWidth</code> is used as the default
   * →<code>ext.button.Button.minWidth</code> for each of the buttons in the fbar.</p>
   * @default null
   * @see #minButtonWidth
   * @see ext.button.Button#minWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-fbar Original Ext JS documentation of 'fbar'
   */
  public native function get fbar():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fbar(value:*):void;

  [ExtConfig]
  /**
   * <b>Important: This config is only effective for →<code>collapsible</code> Panels which are direct
   * child items of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).</b>
   * <p>true to allow clicking a collapsed Panel's →<code>placeholder</code> to display the Panel floated
   * above the layout, false to force the user to fully expand a collapsed region by clicking
   * the expand button to see it again.</p>
   * @default true
   * @see #collapsible
   * @see ext.layout.container.BorderLayout
   * @see #placeholder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-floatable Original Ext JS documentation of 'floatable'
   */
  public native function get floatable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set floatable(value:Boolean):void;

  [ExtConfig]
  /**
   * True to apply a frame to the panel.
   * <p><b>Note:</b> <code>frame: true</code> overrides <i>border:false</i> (→<code>border</code>)</p>
   * @default false
   * @see #border
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-frame Original Ext JS documentation of 'frame'
   */
  override public native function get frame():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set frame(value:Boolean):void;

  [ExtConfig]
  /**
   * True to apply a frame to the panel panels header (if 'frame' is true).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-frameHeader Original Ext JS documentation of 'frameHeader'
   */
  public native function get frameHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set frameHeader(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * Pass as <code>false</code> to prevent a Header from being created and shown.
   * <p>Pass as a config object (optionally containing an <code>→xtype</code>) to custom-configure this Panel's
   * header.</p>
   * <p>See →<code>ext.panel.PanelHeader</code> for all the options that may be specified here.</p>
   * <p>A <i>panel header</i> (→<code>ext.panel.PanelHeader</code>) is a →<code>ext.container.Container</code> which contains
   * the Panel's →<code>title</code> and →<code>tools</code>. You may also configure the Panel's <code>→header</code>
   * option with its own child items which go <i>before</i> the →<code>tools</code></p>
   * <p>By default the panel →<code>title</code> is inserted after items configured in this config,
   * but before any tools. To insert the title at any point in the full array, specify the
   * →<code>ext.panel.PanelHeader.titlePosition</code> config:</p>
   * <pre>
   * new Ext.panel.Panel({
   *     title: 'Test',
   *     tools: [{
   *         type: 'refresh'
   *     }, {
   *         type: 'help'
   *     }],
   *     titlePosition: 2 // Title will come AFTER the two tools
   *     ...
   * });
   * </pre>
   * @see #xtype
   * @see ext.panel.PanelHeader
   * @see ext.container.Container
   * @see #title
   * @see #tools
   * @see #header
   * @see ext.panel.PanelHeader#titlePosition
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-header Original Ext JS documentation of 'header'
   */
  public native function get header():PanelHeader;

  [ExtConfig]
  /**
   * @private
   */
  public native function set header(value:PanelHeader):void;

  [ExtConfig]
  /**
   * Optional CSS class to apply to the header element on mouseover
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-headerOverCls Original Ext JS documentation of 'headerOverCls'
   */
  public native function get headerOverCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set headerOverCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Specify as <code>'top'</code>, <code>'bottom'</code>, <code>'left'</code> or <code>'right'</code>.
   * @default 'top'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-headerPosition Original Ext JS documentation of 'headerPosition'
   * @see #getHeaderPosition()
   * @see #setHeaderPosition()
   */
  public native function get headerPosition():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set headerPosition(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> to hide the expand/collapse toggle button when <code>→collapsible == true</code>,
   * <code>false</code> to display it.
   * @default false
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-hideCollapseTool Original Ext JS documentation of 'hideCollapseTool'
   */
  public native function get hideCollapseTool():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideCollapseTool(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-icon Original Ext JS documentation of 'icon'
   * @see #getIcon()
   * @see #setIcon()
   */
  public native function get icon():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The side of the title to render the icon.
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-iconAlign Original Ext JS documentation of 'iconAlign'
   * @see #getIconAlign()
   * @see #setIconAlign()
   */
  public native function get iconAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconAlign(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #getIconCls()
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Panel, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#property-isPanel Original Ext JS documentation of 'isPanel'
   */
  public native function get isPanel():Boolean;

  /**
   * @private
   */
  public native function set isPanel(value:Boolean):void;

  [ExtConfig]
  /**
   * Convenience config. Short for 'Left Bar' (left-docked, vertical toolbar).
   * <pre>
   * lbar: [
   *   { xtype: 'button', text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'left',
   *     items: [
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-lbar Original Ext JS documentation of 'lbar'
   */
  public native function get lbar():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lbar(value:*):void;

  [ExtConfig]
  /**
   * For panels that are collapsed to the left or right,
   * →<code>ext.panel.PanelHeader.titlePosition</code> may be temporarily changed for UI consistency.
   * Setting this config to true will force the specified titlePosition to be maintained
   * @default false
   * @since 6.5.1
   * @see ext.panel.PanelHeader#titlePosition
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-maintainTitlePosition Original Ext JS documentation of 'maintainTitlePosition'
   */
  public native function get maintainTitlePosition():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maintainTitlePosition(value:Boolean):void;

  [ExtConfig]
  /**
   * When true, the dock component layout writes
   * height information to the panel's DOM elements based on its shrink wrap height
   * calculation. This ensures that the browser respects the calculated height.
   * When false, the dock component layout will not write heights on the panel or its
   * body element. In some simple layout cases, not writing the heights to the DOM may
   * be desired because this allows the browser to respond to direct DOM manipulations
   * (like animations).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-manageHeight Original Ext JS documentation of 'manageHeight'
   */
  public native function get manageHeight():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set manageHeight(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of the element property in this Panel to mask when masked by a LoadMask.
   * <p>Defaults to <code>"el"</code> to indicate that any LoadMask should be rendered into this Panel's
   * encapsulating element.</p>
   * <p>This could be configured to be <code>"body"</code> so that only the body is masked and toolbars
   * and the header are still mouse-accessible.</p>
   * @default 'el'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-maskElement Original Ext JS documentation of 'maskElement'
   */
  override public native function get maskElement():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set maskElement(value:String):void;

  [ExtConfig]
  /**
   * Minimum width of all footer toolbar buttons in pixels. If set, this will be used
   * as the default value for the →<code>ext.button.Button.minWidth</code> config of each Button
   * added to the <b>footer toolbar</b> via the →<code>fbar</code> or →<code>buttons</code> configurations.
   * It will be ignored for buttons that have a minWidth configured some other way,
   * e.g. in their own config object or via the →<code>ext.container.Container.defaults</code>
   * of their parent container.
   * @default 75
   * @see ext.button.Button#minWidth
   * @see #fbar
   * @see #buttons
   * @see ext.container.Container#defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-minButtonWidth Original Ext JS documentation of 'minButtonWidth'
   */
  public native function get minButtonWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minButtonWidth(value:Number):void;

  [ExtConfig]
  /**
   * True to overlap the header in a panel over the framing of the panel itself. This is needed
   * when <code>frame: true</code> (and is done automatically for you). Otherwise it is undefined.
   * If you manually add rounded corners to a panel header which does not have <code>frame: true</code>,
   * this will need to be set to true.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-overlapHeader Original Ext JS documentation of 'overlapHeader'
   */
  public native function get overlapHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overlapHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Important: This config is only effective for →<code>collapsible</code> Panels which are direct
   * child items of a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>) when not using
   * the <code>'header'</code> →<code>collapseMode</code>.</b>
   * <p><b>Optional.</b> A Component (or config object for a Component) to show in place of this Panel
   * when this Panel is collapsed by a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).
   * Defaults to a generated →<code>ext.panel.PanelHeader</code> containing a
   * →<code>ext.panel.Tool</code> to re-expand the Panel.</p>
   * @see #collapsible
   * @see ext.layout.container.BorderLayout
   * @see #collapseMode
   * @see ext.panel.PanelHeader
   * @see ext.panel.Tool
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-placeholder Original Ext JS documentation of 'placeholder'
   */
  public native function get placeholder():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set placeholder(value:*):void;

  [ExtConfig]
  /**
   * The <i>mode</i> (→<code>ext.dom.Element.setVisibilityMode()</code>) for hiding collapsed panels when
   * using →<code>collapseMode</code> "placeholder".
   * @default Ext.Element.VISIBILITY
   * @see ext.dom.Element#setVisibilityMode()
   * @see #collapseMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-placeholderCollapseHideMode Original Ext JS documentation of 'placeholderCollapseHideMode'
   */
  public native function get placeholderCollapseHideMode():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set placeholderCollapseHideMode(value:Number):void;

  [Deprecated(replacement="header", since="4.1.0")]
  [ExtConfig]
  /**
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-preventHeader Original Ext JS documentation of 'preventHeader'
   */
  public native function get preventHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * Convenience config. Short for 'Right Bar' (right-docked, vertical toolbar).
   * <pre>
   * rbar: [
   *   { xtype: 'button', text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'right',
   *     items: [
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-rbar Original Ext JS documentation of 'rbar'
   */
  public native function get rbar():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rbar(value:*):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default [
   *     // headingEl can also be inserted in updateHeader
   *     '<tpl if="headingText">',
   *     '<div id="{id}-headingEl" data-ref="headingEl" role="heading"',
   *     ' class="',
   *     Ext.baseCSSPrefix,
   *     'hidden-clip" style="height:0">',
   *     '{headingText}',
   *     '</div>',
   *     '</tpl>',
   *     '<tpl if="hasTabGuard">{% this.renderTabGuard(out, values, \'before\'); %}</tpl>',
   *     '<div id="{id}-bodyWrap" data-ref="bodyWrap" class="{baseCls}-bodyWrap"',
   *     '<tpl if="bodyWrapAriaAttributes">',
   *     '<tpl foreach="bodyWrapAriaAttributes"> {$}="{.}"</tpl>',
   *     '<tpl else>',
   *     ' role="presentation"',
   *     '</tpl>',
   *     '>',
   *     // If this Panel is framed, the framing template renders the docked items round the frame
   *     '{% this.renderDockedItems(out,values,0); %}',
   *     '<div id="{id}-body" data-ref="body" class="{baseCls}-body<tpl if="bodyCls"> {bodyCls}</tpl>',
   *     ' {baseCls}-body-{ui}<tpl if="uiCls">',
   *     '<tpl for="uiCls"> {parent.baseCls}-body-{parent.ui}-{.}</tpl>',
   *     '</tpl>{childElCls}"',
   *     '<tpl if="bodyAriaAttributes">',
   *     '<tpl foreach="bodyAriaAttributes"> {$}="{.}"</tpl>',
   *     '<tpl else>',
   *     ' role="presentation"',
   *     '</tpl>',
   *     '<tpl if="bodyStyle"> style="{bodyStyle}"</tpl>>',
   *     '{%this.renderContainer(out,values);%}',
   *     '</div>',
   *     '{% this.renderDockedItems(out,values,1); %}',
   *     '</div>',
   *     '<tpl if="hasTabGuard">{% this.renderTabGuard(out, values, \'after\'); %}</tpl>'
   * ]
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  /**
   * The possible values for shrinkWrap are...
   * <ul>
   * <li>0 (or <code>false</code>): Neither width nor height depend on content.</li>
   * <li>1: Width depends on content (shrink wraps), but height does not.</li>
   * <li>2: Height depends on content (shrink wraps), but width does not.</li>
   * <li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>
   * </ul>
   * <p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed
   * to a block-level element.</p>
   * <p><b><i>Panels (subclasses and instances)</i></b></p>
   * <p>By default, when a panel is configured to shrink wrap in a given dimension, only
   * the panel's "content" (items and html content inside the panel body) contributes
   * to its size, and the content of docked items is ignored. Optionally you can use
   * the →<code>shrinkWrapDock</code> config to allow docked items to contribute to the
   * panel's size as well. For example, if shrinkWrap and shrinkWrapDock are both set
   * to true, the width of the panel would be the width of the panel's content and the
   * panel's header text.</p>
   * @default 2
   * @see #shrinkWrapDock
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-shrinkWrap Original Ext JS documentation of 'shrinkWrap'
   */
  override public native function get shrinkWrap():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shrinkWrap(value:*):void;

  [ExtConfig]
  /**
   * Allows for this panel to include the →<code>dockedItems</code> when trying to determine
   * the overall size of the panel. This option is only applicable when this panel is
   * also shrink wrapping in the same dimensions. See →<code>ext.panel.Panel.shrinkWrap</code> for
   * an explanation of the configuration options.
   * @default false
   * @see #dockedItems
   * @see ext.panel.Panel#shrinkWrap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-shrinkWrapDock Original Ext JS documentation of 'shrinkWrapDock'
   */
  public native function get shrinkWrapDock():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shrinkWrapDock(value:*):void;

  [ExtConfig]
  /**
   * When →<code>draggable</code> is <code>true</code>, Specify this as <code>true</code> to cause the <code>→draggable</code>
   * config to work the same as it does in →<code>ext.window.Window</code>. This Panel
   * just becomes movable. No DragDrop instances receive any notifications.
   * For example:
   * <p><b>Example:</b></p>
   * <pre>
   * var win = Ext.create('widget.window', {
   *     height: 300,
   *     width: 300,
   *     title: 'Constraining Window',
   *     closable: false,
   *     items: {
   *         title: "Floating Panel",
   *         width: 100,
   *         height: 100,
   *         floating: true,
   *         draggable: true,
   *         constrain: true,
   *         simpleDrag: true
   *     }
   * });
   * win.show();
   * // Floating components begin life hidden
   * win.child('[title=Floating Panel]').show();
   * </pre>
   * @default false
   * @see #draggable
   * @see ext.window.Window
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-simpleDrag Original Ext JS documentation of 'simpleDrag'
   */
  public native function get simpleDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set simpleDrag(value:Boolean):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * By default the following stateEvents are added:</p>
   * <ul>
   * <li>→<code>event:onResize</code> - <i>(added by Ext.Component)</i></li>
   * <li>→<code>event:onCollapse</code></li>
   * <li>→<code>event:onExpand</code></li>
   * </ul>
   * @see #stateEvents
   * @see #stateful
   * @see #event:onResize
   * @see #event:onCollapse
   * @see #event:onExpand
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  override public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set stateEvents(value:Array):void;

  [ExtConfig]
  /**
   * Convenience config. Short for 'Top Bar'.
   * <pre>
   * tbar: [
   *   { xtype: 'button', text: 'Button 1' }
   * ]
   * </pre>
   * <p>is equivalent to</p>
   * <pre>
   * dockedItems: [{
   *     xtype: 'toolbar',
   *     dock: 'top',
   *     items: [
   *         { xtype: 'button', text: 'Button 1' }
   *     ]
   * }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-tbar Original Ext JS documentation of 'tbar'
   */
  public native function get tbar():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tbar(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The title text or config object for the →<code>ext.panel.PanelTitle</code> component.
   * When a <code>→title</code> is specified, the →<code>ext.panel.PanelHeader</code> will
   * automatically be created and displayed unless →<code>header</code> is set to <code>false</code>.
   * @default null
   * @see ext.panel.PanelTitle
   * @see #title
   * @see ext.panel.PanelHeader
   * @see #header
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-title Original Ext JS documentation of 'title'
   * @see #getTitle()
   * @see #setTitle()
   */
  public native function get title():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set title(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The alignment of the title text within the available space between the
   * icon and the tools.
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-titleAlign Original Ext JS documentation of 'titleAlign'
   * @see #getTitleAlign()
   * @see #setTitleAlign()
   */
  public native function get titleAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titleAlign(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> to allow expanding and collapsing the panel (when <code>→collapsible = true</code>)
   * by clicking anywhere in the header bar, <code>false</code>) to allow it only by clicking to tool
   * button). When a panel is used in a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>),
   * the →<code>floatable</code> option can influence the behavior of collapsing.
   * @default undefined
   * @see #collapsible
   * @see ext.layout.container.BorderLayout
   * @see #floatable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-titleCollapse Original Ext JS documentation of 'titleCollapse'
   */
  public native function get titleCollapse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set titleCollapse(value:Boolean):void;

  [ExtConfig("title")]
  /**
   * Alias for <code>title</code> to allow specifying the title as a <code>PanelTitle</code> config object.
   * @see #title
   */
  public native function set titleConfig(value:PanelTitle):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ordinal position among the header items (tools and other components specified
   * using the →<code>items</code> config) at which the title component is inserted.
   * See <i>Panel's header config</i> (→<code>ext.panel.Panel.header</code>).
   * <p>If not specified, the title is inserted after any →<code>items</code>, but <i>before</i>
   * any →<code>ext.panel.Panel.tools</code>.</p>
   * <p>Note that if an →<code>icon</code> or →<code>iconCls</code> has been configured, then the icon
   * component will be the first item before all specified tools or →<code>items</code>.
   * This configuration does not include the icon.</p>
   * @default 0
   * @since 6.5.1
   * @see #items
   * @see ext.panel.Panel#header
   * @see ext.panel.Panel#tools
   * @see #icon
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-titlePosition Original Ext JS documentation of 'titlePosition'
   * @see #getTitlePosition()
   * @see #setTitlePosition()
   */
  public native function get titlePosition():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titlePosition(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the header's title text. Can be one of the following values:
   * <ul>
   * <li><code>'default'</code> - use the default rotation, depending on the dock position of the header</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the dock position of the header:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>1</code></li>
   * </ul>
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-titleRotation Original Ext JS documentation of 'titleRotation'
   * @see #getTitleRotation()
   * @see #setTitleRotation()
   */
  public native function get titleRotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titleRotation(value:*):void;

  [ExtConfig]
  /**
   * An array of →<code>ext.panel.Tool</code> configs/instances to be added to the header tool area.
   * The tools are stored as child components of the header container. They can be accessed using
   * →<code>down()</code> and {#query}, as well as the other component methods. The toggle tool
   * is automatically created if →<code>collapsible</code> is set to true.
   * <p>Note that, apart from the toggle tool which is provided when a panel is collapsible,
   * these tools only provide the visual button. Any required functionality must be provided
   * by adding handlers that implement the necessary behavior.</p>
   * <p>Example usage:</p>
   * <pre>
   * tools: [{
   *     type:'refresh',
   *     tooltip: 'Refresh form Data',
   *     // hidden:true,
   *     handler: function(event, toolEl, panelHeader) {
   *         // refresh logic
   *     }
   * },
   * {
   *     type:'help',
   *     tooltip: 'Get Help',
   *     callback: function(panel, tool, event) {
   *         // show help here
   *     }
   * }]
   * </pre>
   * <p>The difference between <code>handler</code> and <code>callback</code> is the signature. For details on
   * the distinction, see →<code>ext.panel.Tool</code>.</p>
   * @see ext.panel.Tool
   * @see #down()
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#cfg-tools Original Ext JS documentation of 'tools'
   */
  public native function get tools():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tools(value:*):void;

  /**
   * Adds a CSS class to the body element. If not rendered, the class will
   * be added when the panel is rendered.
   * @param cls The class to add
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-addBodyCls Original Ext JS documentation of 'addBodyCls'
   */
  public native function addBodyCls(cls:*):Panel;

  /**
   * @inheritDoc
   */
  public native function addDocked(items:*, pos:Number = NaN):Array;

  /**
   * Add tools to this panel <i>header</i> (→<code>ext.panel.PanelHeader</code>)
   * <pre>
   * panel.addTool({
   *     type: 'gear',
   *     handler: function() {
   *         // ....
   *     }
   * });
   *
   * panel.addTool([{
   *     type: 'gear',
   *     handler: 'viewControllerGearMethod'
   * }, {
   *     type: 'save',
   *     handler: 'viewControllerSaveMethod'
   * }]);
   * </pre>
   * <p>By default the tools will be accessible via keyboard, with the exception of
   * automatically added collapse/expand and close tools.</p>
   * <p>If you implement keyboard equivalents of your tools' actions elsewhere and do not
   * want the tools to participate in keyboard navigation, you can make them
   * presentational instead:</p>
   * <pre>
   * panel.addTool({
   *     type: 'mytool',
   *     focusable: false,
   *     ariaRole: 'presentation'
   *     // ...
   * });
   * </pre>
   * @param tools The tool or tools to
   * add.
   * @see ext.panel.PanelHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-addTool Original Ext JS documentation of 'addTool'
   */
  public native function addTool(tools:*):void;

  /**
   * Template method to be implemented in subclasses to add their tools after
   * the collapsible tool.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-addTools Original Ext JS documentation of 'addTools'
   */
  protected native function addTools():void;

  /**
   * Invoked after the Panel is Collapsed.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-afterCollapse Original Ext JS documentation of 'afterCollapse'
   */
  protected native function afterCollapse(animated:Boolean):void;

  /**
   * Invoked after the Panel is Expanded.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-afterExpand Original Ext JS documentation of 'afterExpand'
   */
  protected native function afterExpand(animated:Boolean):void;

  /**
   * Closes the Panel. By default, this method, removes it from the DOM,
   * →<code>ext.Component.destroy()</code>s the Panel object and all its descendant
   * Components. The →<code>event:onBeforeClose</code> event is fired before the
   * close happens and will cancel the close action if it returns false.
   * <p><b>Note:</b> This method is also affected by the →<code>closeAction</code> setting.
   * For more explicit control use →<code>destroy()</code> and →<code>hide()</code> methods.</p>
   * @see ext.Component#destroy()
   * @see #event:onBeforeClose
   * @see #closeAction
   * @see #destroy()
   * @see #hide()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-close Original Ext JS documentation of 'close'
   */
  public native function close():void;

  /**
   * Collapses the panel body so that the body becomes hidden. Docked Components parallel
   * to the border towards which the collapse takes place will remain visible. Fires the
   * →<code>event:onBeforeCollapse</code> event which will cancel the collapse action if it returns false.
   * @param direction The direction to collapse towards. Must be one of
   * <ul>
   * <li>Ext.Component.DIRECTION_TOP</li>
   * <li>Ext.Component.DIRECTION_RIGHT</li>
   * <li>Ext.Component.DIRECTION_BOTTOM</li>
   * <li>Ext.Component.DIRECTION_LEFT</li>
   * </ul>
   * <p>Defaults to →<code>collapseDirection</code>.</p>
   * @param animate True to animate the transition, else false
   * (defaults to the value of the →<code>animCollapse</code> panel config). May
   * also be specified as the animation duration in milliseconds.
   * @return this
   * @see #event:onBeforeCollapse
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-collapse Original Ext JS documentation of 'collapse'
   * @see #collapseDirection
   * @see #animCollapse
   */
  public native function collapse(direction:String = null, animate:* = undefined):Panel;

  /**
   * converts a collapsdDir into an anchor argument for Element.slideIn
   * overridden in rtl mode to switch "l" and "r"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-convertCollapseDir Original Ext JS documentation of 'convertCollapseDir'
   */
  public native function convertCollapseDir(collapseDir:*):void;

  /**
   * Expands the panel body so that it becomes visible. Fires the →<code>event:onBeforeExpand</code>
   * event which will cancel the expand action if it returns false.
   * @param animate True to animate the transition, else false
   * (defaults to the value of the →<code>animCollapse</code> panel config). May
   * also be specified as the animation duration in milliseconds.
   * @return this
   * @see #event:onBeforeExpand
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-expand Original Ext JS documentation of 'expand'
   * @see #animCollapse
   */
  public native function expand(animate:Boolean = false):Panel;

  [Deprecated(message="Use <code>getDockedItems(...)</code>, <code>down(...)</code> or <code>query(...)</code> with selector <code>'toolbar[dock=\"bottom\"][ui!=\"footer\"]'</code> instead. Use selector <code>'toolbar[dock=\"bottom\"]'</code> for not filtering out footer toolbars. Adapt <code>ui</code> parameter if your footer UI style has a different name.\n\n", since="6.0")]
  /**
   * Returns the <i>toolbar</i> (→<code>ext.toolbar.Toolbar</code>) from the bottom (→<code>bbar</code>) section of the panel.
   * @return The toolbar
   * @see ext.toolbar.Toolbar
   * @see #bbar
   */
  public native function getBottomToolbar():Toolbar;

  /**
   * Returns the value of <code>closable</code>.
   * @see #closable
   */
  public native function getClosable():Boolean;

  /**
   * Returns the current collapsed state of the panel.
   * @return False when not collapsed, otherwise the value of
   * →<code>collapseDirection</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-getCollapsed Original Ext JS documentation of 'getCollapsed'
   * @see #collapseDirection
   */
  public native function getCollapsed():*;

  /**
   * Attempts a default component lookup (see →<code>ext.container.Container.getComponent()</code>).
   * If the component is not found in the normal items, the dockedItems are searched
   * and the matched component (if any) returned (see →<code>getDockedComponent()</code>).
   * Note that docked items will only be matched by component id or itemId -- if you pass
   * a numeric index only non-docked child components will be searched.
   * @since 2.3.0
   * @param comp The component id, itemId or position to find
   * @return The component (if found)
   * @see ext.container.Container#getComponent()
   * @see #getDockedComponent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-getComponent Original Ext JS documentation of 'getComponent'
   */
  override public native function getComponent(comp:*):Component;

  /**
   * @inheritDoc
   */
  public native function getDockedComponent(comp:*):Component;

  /**
   * @inheritDoc
   */
  public native function getDockedItems(selector:String, beforeBody:Boolean = undefined):Array;

  [Deprecated(message="Use <code>getDockedItems(...)</code>, <code>down(...)</code> or <code>query(...)</code> with selector <code>'toolbar[dock=\"bottom\"][ui=\"footer\"]'</code> instead. Adapt <code>ui</code> parameter if your footer UI style has a different name.\n\n", since="6.0")]
  /**
   * Returns the <i>toolbar</i> (→<code>ext.toolbar.Toolbar</code>) from the footer (→<code>fbar</code>) section of the panel.
   * @return The toolbar
   * @see ext.toolbar.Toolbar
   * @see #fbar
   */
  public native function getFooterToolbar():Toolbar;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Gets the →<code>ext.panel.PanelHeader</code> for this panel.
   * @see ext.panel.PanelHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-getHeader Original Ext JS documentation of 'getHeader'
   */
  public native function getHeader():PanelHeader;

  /**
   * Returns the value of <code>headerPosition</code>.
   * @see #headerPosition
   */
  public native function getHeaderPosition():String;

  /**
   * Returns the value of <code>icon</code>.
   * @see #icon
   */
  public native function getIcon():String;

  /**
   * Returns the value of <code>iconAlign</code>.
   * @see #iconAlign
   */
  public native function getIconAlign():String;

  /**
   * Returns the value of <code>iconCls</code>.
   * @see #iconCls
   */
  public native function getIconCls():String;

  /**
   * Returns the value of <code>title</code>.
   * @see #title
   */
  public native function getTitle():*;

  /**
   * Returns the value of <code>titleAlign</code>.
   * @see #titleAlign
   */
  public native function getTitleAlign():String;

  /**
   * Returns the value of <code>titlePosition</code>.
   * @see #titlePosition
   */
  public native function getTitlePosition():Number;

  /**
   * Returns the value of <code>titleRotation</code>.
   * @see #titleRotation
   */
  public native function getTitleRotation():*;

  [Deprecated(message="Use <code>getDockedItems(...)</code>, <code>down(...)</code> or <code>query(...)</code> with selector <code>'toolbar[dock=\"top\"]'</code> instead.\n\n", since="6.0")]
  /**
   * Returns the <i>toolbar</i> (→<code>ext.toolbar.Toolbar</code>) from the top (→<code>tbar</code>) section of the panel.
   * @return The toolbar
   * @see ext.toolbar.Toolbar
   * @see #tbar
   */
  public native function getTopToolbar():Toolbar;

  /**
   * Initializes an Item Collection for docked items to be inserted into. If items
   * already exist, they will be added to the new collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-initDockingItems Original Ext JS documentation of 'initDockingItems'
   */
  protected native function initDockingItems():void;

  /**
   * @inheritDoc
   */
  public native function insertDocked(pos:Number, items:*):void;

  /**
   * Invoked after a docked item is added to the Panel.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-onDockedAdd Original Ext JS documentation of 'onDockedAdd'
   */
  protected native function onDockedAdd(component:Component):void;

  /**
   * Invoked after a docked item is removed from the Panel.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.container.DockingContainer.html#method-onDockedRemove Original Ext JS documentation of 'onDockedRemove'
   */
  protected native function onDockedRemove(component:Component):void;

  /**
   * Method to manage awareness of when components are removed from their
   * respective Container, firing a #removed event. References are properly
   * cleaned up after removing a component from its owning container.
   * <p>Allows addition of behavior when a Component is removed from
   * its parent Container. At this stage, the Component has been
   * removed from its parent Container's collection of child items,
   * but has not been destroyed (It will be destroyed if the parent
   * Container's <code>→autoDestroy</code> is <code>true</code>, or if the remove call was
   * passed a truthy second parameter). After calling the
   * superclass's <code>→onRemoved()</code>, the <code>→ownerCt</code> and the <code>refOwner</code> will not
   * be present.</p>
   * @param destroying Will be passed as <code>true</code> if the Container performing
   * the remove operation will delete this Component upon remove.
   * @see #autoDestroy
   * @see #onRemoved()
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-onRemoved Original Ext JS documentation of 'onRemoved'
   */
  override protected native function onRemoved(destroying:Boolean):void;

  /**
   * Removes a CSS class from the body element.
   * @param cls The class to remove
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-removeBodyCls Original Ext JS documentation of 'removeBodyCls'
   */
  public native function removeBodyCls(cls:*):Panel;

  /**
   * @inheritDoc
   */
  public native function removeDocked(item:Component, flags:* = undefined):void;

  /**
   * Sets the body style according to the passed parameters.
   * @param style A full style specification string, or object, or the name of a style
   * property to set.
   * @param value If the first param was a style property name, the style property value.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-setBodyStyle Original Ext JS documentation of 'setBodyStyle'
   */
  public native function setBodyStyle(style:*, value:String):Panel;

  /**
   * @param border The border, see →<code>border</code>. If a falsey value is passed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-setBorder Original Ext JS documentation of 'setBorder'
   * @see #border
   */
  override public native function setBorder(border:*):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>closable</code>.
   * @param closable The new value.
   * @see #closable
   */
  public native function setClosable(closable:Boolean):void;

  /**
   * Collapses or expands the panel.
   * @param collapsed <code>true</code> to collapse the panel, <code>false</code> to expand it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-setCollapsed Original Ext JS documentation of 'setCollapsed'
   */
  public native function setCollapsed(collapsed:Boolean):void;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Sets the value of <code>headerPosition</code>.
   * @param headerPosition The new value.
   * @see #headerPosition
   */
  public native function setHeaderPosition(headerPosition:String):void;

  /**
   * Sets the value of <code>icon</code>.
   * @param icon The new value.
   * @see #icon
   */
  public native function setIcon(icon:String):void;

  /**
   * Sets the value of <code>iconAlign</code>.
   * @param iconAlign The new value.
   * @see #iconAlign
   */
  public native function setIconAlign(iconAlign:String):void;

  /**
   * Sets the value of <code>iconCls</code>.
   * @param iconCls The new value.
   * @see #iconCls
   */
  public native function setIconCls(iconCls:String):void;

  /**
   * Sets the value of <code>title</code>.
   * @param title The new value.
   * @see #title
   */
  public native function setTitle(title:String):void;

  /**
   * Sets the value of <code>titleAlign</code>.
   * @param titleAlign The new value.
   * @see #titleAlign
   */
  public native function setTitleAlign(titleAlign:String):void;

  /**
   * Sets the value of <code>titlePosition</code>.
   * @param titlePosition The new value.
   * @see #titlePosition
   */
  public native function setTitlePosition(titlePosition:Number):void;

  /**
   * Sets the value of <code>titleRotation</code>.
   * @param titleRotation The new value.
   * @see #titleRotation
   */
  public native function setTitleRotation(titleRotation:*):void;

  /**
   * Sets the UI for the component. This will remove any existing UIs on the component.
   * It will also loop through any <code>→uiCls</code> set on the component and rename them so they include
   * the new UI.
   * @param ui The new UI for the component.
   * @see #uiCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-setUI Original Ext JS documentation of 'setUI'
   */
  override public native function setUI(ui:String):void;

  /**
   * Shortcut for performing an →<code>expand()</code> or →<code>collapse()</code> based
   * on the current state of the panel.
   * @return this
   * @see #expand()
   * @see #collapse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#method-toggleCollapse Original Ext JS documentation of 'toggleCollapse'
   */
  public native function toggleCollapse():Panel;
}
}