package ext.panel {

[Native("Ext.panel.Header", require)]
/**
 * @see ext.panel.events.PanelHeader_eEvent.CLICK
 * @eventType ext.panel.events.PanelHeader_eEvent.CLICK
 */
[Event(name='onClick', type='ext.panel.events.PanelHeader_eEvent')]
/**
 * @see ext.panel.events.PanelHeader_eEvent.DBLCLICK
 * @eventType ext.panel.events.PanelHeader_eEvent.DBLCLICK
 */
[Event(name='onDblclick', type='ext.panel.events.PanelHeader_eEvent')]
/**
 * Simple header class which is used for on →<code>ext.panel.Panel</code> and →<code>ext.window.Window</code>.
 * @see ext.panel.Panel
 * @see ext.window.Window
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html Original Ext JS documentation of 'Ext.panel.Header'
 */
public class PanelHeader extends PanelBar {
  /**
   * @param config @inheritDoc
   */
  public function PanelHeader(config:PanelHeader = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-icon Original Ext JS documentation of 'icon'
   * @see #getIcon()
   * @see #setIcon()
   */
  public native function get icon():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The side of the title to render the icon.
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-iconAlign Original Ext JS documentation of 'iconAlign'
   * @see #getIconAlign()
   * @see #setIconAlign()
   */
  public native function get iconAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconAlign(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #getIconCls()
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Header, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#property-isHeader Original Ext JS documentation of 'isHeader'
   */
  public native function get isHeader():Boolean;

  /**
   * @private
   */
  public native function set isHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * The index at which the any →<code>items</code> will be inserted into the Header's
   * items collection. By default this will effectively be the <code>1</code> position
   * placing the items following the panel →<code>ext.panel.Panel.title</code>.
   * <p>Set to <code>0</code> to have the items <i>inserted</i> (→<code>insert()</code>) before the panel title.</p>
   * <pre>
   * Ext.create('Ext.panel.Panel', {
   *     title: 'Hello',
   *     width: 200,
   *     html: '&lt;p&gt;World!&lt;/p&gt;',
   *     renderTo: Ext.getBody(),
   *     tools: [{
   *         type: 'pin'
   *     }],
   *     header: {
   *         //itemPosition: 0,	// before panel title
   *         //itemPosition: 1, // after panel title
   *         //itemPosition: 2, // after pin tool
   *         items: [{
   *             xtype: 'button',
   *             text: 'Header Button'
   *         }]
   *     }
   * });
   * </pre>
   * @see #items
   * @see ext.panel.Panel#title
   * @see #insert()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-itemPosition Original Ext JS documentation of 'itemPosition'
   */
  public native function get itemPosition():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemPosition(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The title text or config object for the →<code>ext.panel.PanelTitle</code> component.
   * @default {
   *     $value: {
   *         xtype: 'title',
   *         flex: 1
   *     },
   *     merge: function(newValue, oldValue) {
   *         if (typeof newValue !== 'object') {
   *             newValue = {
   *                 text: newValue
   *             };
   *         }
   *         return Ext.merge(oldValue ? Ext.Object.chain(oldValue) : {}, newValue);
   *     }
   * }
   * @see ext.panel.PanelTitle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-title Original Ext JS documentation of 'title'
   * @see #getTitle()
   * @see #setTitle()
   */
  public native function get title():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set title(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The alignment of the title text within the available space between the
   * icon and the tools.
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-titleAlign Original Ext JS documentation of 'titleAlign'
   * @see #getTitleAlign()
   * @see #setTitleAlign()
   */
  public native function get titleAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titleAlign(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The ordinal position among the header items (tools and other components specified
   * using the →<code>items</code> config) at which the title component is inserted.
   * See <i>Panel's header config</i> (→<code>ext.panel.Panel.header</code>).
   * <p>If not specified, the title is inserted after any →<code>items</code>, but <i>before</i>
   * any →<code>ext.panel.Panel.tools</code>.</p>
   * <p>Note that if an →<code>icon</code> or →<code>iconCls</code> has been configured, then the icon
   * component will be the first item before all specified tools or →<code>items</code>.
   * This configuration does not include the icon.</p>
   * @default 0
   * @see #items
   * @see ext.panel.Panel#header
   * @see ext.panel.Panel#tools
   * @see #icon
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-titlePosition Original Ext JS documentation of 'titlePosition'
   * @see #getTitlePosition()
   * @see #setTitlePosition()
   */
  public native function get titlePosition():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titlePosition(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the header's title text. Can be one of the following values:
   * <ul>
   * <li><code>'default'</code> - use the default rotation, depending on the dock position of the header</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the dock position of the header:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>1</code></li>
   * </ul>
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#cfg-titleRotation Original Ext JS documentation of 'titleRotation'
   * @see #getTitleRotation()
   * @see #setTitleRotation()
   */
  public native function get titleRotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set titleRotation(value:*):void;

  /**
   * Add a tool to the header
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#method-addTool Original Ext JS documentation of 'addTool'
   */
  public native function addTool(tool:Object):void;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Returns the value of <code>icon</code>.
   * @see #icon
   */
  public native function getIcon():String;

  /**
   * Returns the value of <code>iconAlign</code>.
   * @see #iconAlign
   */
  public native function getIconAlign():String;

  /**
   * Returns the value of <code>iconCls</code>.
   * @see #iconCls
   */
  public native function getIconCls():String;

  /**
   * Returns the value of <code>title</code>.
   * @see #title
   */
  public native function getTitle():*;

  /**
   * Returns the value of <code>titleAlign</code>.
   * @see #titleAlign
   */
  public native function getTitleAlign():String;

  /**
   * Returns the value of <code>titlePosition</code>.
   * @see #titlePosition
   */
  public native function getTitlePosition():Number;

  /**
   * Returns the value of <code>titleRotation</code>.
   * @see #titleRotation
   */
  public native function getTitleRotation():*;

  [ArrayElementType("ext.panel.Tool")]
  /**
   * Gets the tools for this header.
   * @return The tools
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Header.html#method-getTools Original Ext JS documentation of 'getTools'
   */
  public native function getTools():Array;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Sets the value of <code>icon</code>.
   * @param icon The new value.
   * @see #icon
   */
  public native function setIcon(icon:String):void;

  /**
   * Sets the value of <code>iconAlign</code>.
   * @param iconAlign The new value.
   * @see #iconAlign
   */
  public native function setIconAlign(iconAlign:String):void;

  /**
   * Sets the value of <code>iconCls</code>.
   * @param iconCls The new value.
   * @see #iconCls
   */
  public native function setIconCls(iconCls:String):void;

  /**
   * Sets the value of <code>title</code>.
   * @param title The new value.
   * @see #title
   */
  public native function setTitle(title:*):void;

  /**
   * Sets the value of <code>titleAlign</code>.
   * @param titleAlign The new value.
   * @see #titleAlign
   */
  public native function setTitleAlign(titleAlign:String):void;

  /**
   * Sets the value of <code>titlePosition</code>.
   * @param titlePosition The new value.
   * @see #titlePosition
   */
  public native function setTitlePosition(titlePosition:Number):void;

  /**
   * Sets the value of <code>titleRotation</code>.
   * @param titleRotation The new value.
   * @see #titleRotation
   */
  public native function setTitleRotation(titleRotation:*):void;
}
}