package ext.panel {
import ext.Base;
import ext.dom.Element;

import js.HTMLElement;

[Native("Ext.panel.Proxy", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>A custom drag proxy implementation specific to →<code>ext.panel.Panel</code>s. This class
 * is primarily used internally for the Panel's drag drop implementation, and
 * should never need to be created directly.</p>
 * @see ext.panel.Panel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html Original Ext JS documentation of 'Ext.panel.Proxy'
 */
public class PanelProxy extends Base {
  /**
   * Creates new panel proxy.
   * @param panel The →<code>ext.panel.Panel</code> to proxy for
   * @param config Config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see ext.panel.Panel
   */
  public function PanelProxy(panel:Panel, config:PanelProxy = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to insert a placeholder proxy element while dragging the panel, false to drag
   * with no proxy.
   * Most Panels are not absolute positioned and therefore we need to reserve this space.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#cfg-insertProxy Original Ext JS documentation of 'insertProxy'
   */
  public native function get insertProxy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set insertProxy(value:Boolean):void;

  [ExtConfig]
  /**
   * True to move the panel to the dragged position when dropped
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#cfg-moveOnDrag Original Ext JS documentation of 'moveOnDrag'
   */
  public native function get moveOnDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set moveOnDrag(value:Boolean):void;

  /**
   * @default panel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#property-panel Original Ext JS documentation of 'panel'
   */
  public native function get panel():Panel;

  /**
   * @private
   */
  public native function set panel(value:Panel):void;

  /**
   * Gets the proxy's element
   * @return The proxy's element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-getEl Original Ext JS documentation of 'getEl'
   */
  public native function getEl():Element;

  /**
   * Gets the proxy's ghost Panel
   * @return The proxy's ghost Panel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-getGhost Original Ext JS documentation of 'getGhost'
   */
  public native function getGhost():Panel;

  /**
   * Gets the proxy element. This is the element that represents where the
   * Panel was before we started the drag operation.
   * @return The proxy's element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-getProxy Original Ext JS documentation of 'getProxy'
   */
  public native function getProxy():Element;

  /**
   * Hides the proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-hide Original Ext JS documentation of 'hide'
   */
  public native function hide():void;

  /**
   * Moves the proxy to a different position in the DOM. This is typically
   * called while dragging the Panel to keep the proxy sync'd to the Panel's
   * location.
   * @param parentNode The proxy's parent DOM node
   * @param before The sibling node before which the
   * proxy should be inserted. Defaults to the parent's last child if not
   * specified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-moveProxy Original Ext JS documentation of 'moveProxy'
   */
  public native function moveProxy(parentNode:HTMLElement, before:HTMLElement = null):void;

  /**
   * Shows the proxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Proxy.html#method-show Original Ext JS documentation of 'show'
   */
  public native function show():void;
}
}