package ext.panel {
import ext.Component;

[Native("Ext.panel.Title", require)]
/**
 * A basic title component for a Panel Header
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html Original Ext JS documentation of 'Ext.panel.Title'
 */
public class PanelTitle extends Component {
  /**
   * @param config @inheritDoc
   */
  public function PanelTitle(config:PanelTitle = null) {
    super();
  }

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default {
   *     role: 'presentation',
   *     // Required for Opera
   *     unselectable: 'on'
   * }
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'title'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'textEl',
   *     'iconEl',
   *     'iconWrapEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #getGlyph()
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-icon Original Ext JS documentation of 'icon'
   * @see #getIcon()
   * @see #setIcon()
   */
  public native function get icon():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * alignment of the icon
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-iconAlign Original Ext JS documentation of 'iconAlign'
   * @see #getIconAlign()
   * @see #setIconAlign()
   */
  public native function get iconAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconAlign(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #getIconCls()
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default '<tpl if="iconMarkup && iconBeforeTitle">{iconMarkup}</tpl>' + // unselectable="on" is required for Opera, other browsers
   * // inherit unselectability from the header
   * '<div id="{id}-textEl" data-ref="textEl"' + ' class="{textCls} {textCls}-{ui} {itemCls}{childElCls}" unselectable="on"' + '<tpl if="textElRole"> role="{textElRole}"</tpl>' + '>' + '{text}' + '</div>' + '<tpl if="iconMarkup && !iconBeforeTitle">{iconMarkup}</tpl>'
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the header's title text. Can be one of the following values:
   * <ul>
   * <li><code>'default'</code> - use the default rotation, depending on the dock position of the header</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the dock position of the header:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>1</code></li>
   * </ul>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-rotation Original Ext JS documentation of 'rotation'
   * @see #getRotation()
   * @see #setRotation()
   */
  public native function get rotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rotation(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * DOM tabIndex attribute for this component's →<code>focusEl</code>.
   * @default 0
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The title's text (can contain html tags/entities)
   * @default '&#160;'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The alignment of the title text within the available space between the
   * icon and the tools.
   * @default 'left'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Title.html#cfg-textAlign Original Ext JS documentation of 'textAlign'
   * @see #getTextAlign()
   * @see #setTextAlign()
   */
  public native function get textAlign():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set textAlign(value:String):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Returns the value of <code>glyph</code>.
   * @see #glyph
   */
  public native function getGlyph():*;

  /**
   * Returns the value of <code>icon</code>.
   * @see #icon
   */
  public native function getIcon():String;

  /**
   * Returns the value of <code>iconAlign</code>.
   * @see #iconAlign
   */
  public native function getIconAlign():String;

  /**
   * Returns the value of <code>iconCls</code>.
   * @see #iconCls
   */
  public native function getIconCls():String;

  /**
   * Returns the value of <code>rotation</code>.
   * @see #rotation
   */
  public native function getRotation():*;

  /**
   * Returns the value of <code>text</code>.
   * @see #text
   */
  public native function getText():String;

  /**
   * Returns the value of <code>textAlign</code>.
   * @see #textAlign
   */
  public native function getTextAlign():String;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>glyph</code>.
   * @param glyph The new value.
   * @see #glyph
   */
  public native function setGlyph(glyph:*):void;

  /**
   * Sets the value of <code>icon</code>.
   * @param icon The new value.
   * @see #icon
   */
  public native function setIcon(icon:String):void;

  /**
   * Sets the value of <code>iconAlign</code>.
   * @param iconAlign The new value.
   * @see #iconAlign
   */
  public native function setIconAlign(iconAlign:String):void;

  /**
   * Sets the value of <code>iconCls</code>.
   * @param iconCls The new value.
   * @see #iconCls
   */
  public native function setIconCls(iconCls:String):void;

  /**
   * Sets the value of <code>rotation</code>.
   * @param rotation The new value.
   * @see #rotation
   */
  public native function setRotation(rotation:*):void;

  /**
   * Sets the value of <code>text</code>.
   * @param text The new value.
   * @see #text
   */
  public native function setText(text:String):void;

  /**
   * Sets the value of <code>textAlign</code>.
   * @param textAlign The new value.
   * @see #textAlign
   */
  public native function setTextAlign(textAlign:String):void;
}
}