package ext.panel {
import ext.Component;
import ext.data.Model;
import ext.data.Store;
import ext.grid.header.HeaderContainer;
import ext.grid.locking.ILockable;
import ext.selection.SelectionModel;
import ext.view.TableView;

[Native("Ext.panel.Table", require)]
/**
 * @see ext.panel.events.TablePanel_store_operationEvent.BEFORE_LOAD
 * @eventType ext.panel.events.TablePanel_store_operationEvent.BEFORE_LOAD
 */
[Event(name='onBeforeLoad', type='ext.panel.events.TablePanel_store_operationEvent')]
/**
 * @see ext.panel.events.TablePanel_store_filtersEvent.FILTER_CHANGE
 * @eventType ext.panel.events.TablePanel_store_filtersEvent.FILTER_CHANGE
 */
[Event(name='onFilterChange', type='ext.panel.events.TablePanel_store_filtersEvent')]
/**
 * @see ext.panel.events.TablePanel_store_grouperEvent.GROUP_CHANGE
 * @eventType ext.panel.events.TablePanel_store_grouperEvent.GROUP_CHANGE
 */
[Event(name='onGroupChange', type='ext.panel.events.TablePanel_store_grouperEvent')]
/**
 * @see ext.panel.events.TablePanel_records_successful_operationEvent.LOAD
 * @eventType ext.panel.events.TablePanel_records_successful_operationEvent.LOAD
 */
[Event(name='onLoad', type='ext.panel.events.TablePanel_records_successful_operationEvent')]
/**
 * @see ext.panel.events.TablePanel_columnEvent.LOCK_COLUMN
 * @eventType ext.panel.events.TablePanel_columnEvent.LOCK_COLUMN
 */
[Event(name='onLockColumn', type='ext.panel.events.TablePanel_columnEvent')]
/**
 * @see ext.panel.events.TablePanel_lockedColumns_normalColumnsEvent.PROCESS_COLUMNS
 * @eventType ext.panel.events.TablePanel_lockedColumns_normalColumnsEvent.PROCESS_COLUMNS
 */
[Event(name='onProcessColumns', type='ext.panel.events.TablePanel_lockedColumns_normalColumnsEvent')]
/**
 * @see ext.panel.events.TablePanel_columnEvent.UNLOCK_COLUMN
 * @eventType ext.panel.events.TablePanel_columnEvent.UNLOCK_COLUMN
 */
[Event(name='onUnlockColumn', type='ext.panel.events.TablePanel_columnEvent')]
/**
 * @see ext.panel.events.TablePanelEvent.VIEW_READY
 * @eventType ext.panel.events.TablePanelEvent.VIEW_READY
 */
[Event(name='onViewReady', type='ext.panel.events.TablePanelEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CLICK
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CLICK
 */
[Event(name='onBeforeCellClick', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CONTEXT_MENU
 */
[Event(name='onBeforeCellContextMenu', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_DBLCLICK
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_DBLCLICK
 */
[Event(name='onBeforeCellDblclick', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_KEY_DOWN
 */
[Event(name='onBeforeCellKeyDown', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_DOWN
 */
[Event(name='onBeforeCellMouseDown', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_UP
 */
[Event(name='onBeforeCellMouseUp', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_CLICK
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_CLICK
 */
[Event(name='onBeforeContainerClick', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_CONTEXT_MENU
 */
[Event(name='onBeforeContainerContextMenu', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_DBLCLICK
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_DBLCLICK
 */
[Event(name='onBeforeContainerDblclick', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEY_DOWN
 */
[Event(name='onBeforeContainerKeyDown', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEYPRESS
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEYPRESS
 */
[Event(name='onBeforeContainerKeypress', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEY_UP
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_KEY_UP
 */
[Event(name='onBeforeContainerKeyUp', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_DOWN
 */
[Event(name='onBeforeContainerMouseDown', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_OUT
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_OUT
 */
[Event(name='onBeforeContainerMouseOut', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_OVER
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_OVER
 */
[Event(name='onBeforeContainerMouseOver', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_eEvent.BEFORE_CONTAINER_MOUSE_UP
 */
[Event(name='onBeforeContainerMouseUp', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_indexEvent.BEFORE_DESELECT
 * @eventType ext.panel.events.TablePanel_record_indexEvent.BEFORE_DESELECT
 */
[Event(name='onBeforeDeselect', type='ext.panel.events.TablePanel_record_indexEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_CLICK
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_CLICK
 */
[Event(name='onBeforeItemClick', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_CONTEXT_MENU
 */
[Event(name='onBeforeItemContextMenu', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_DBLCLICK
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_DBLCLICK
 */
[Event(name='onBeforeItemDblclick', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEY_DOWN
 */
[Event(name='onBeforeItemKeyDown', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEYPRESS
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEYPRESS
 */
[Event(name='onBeforeItemKeypress', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEY_UP
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_KEY_UP
 */
[Event(name='onBeforeItemKeyUp', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_LONG_PRESS
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_LONG_PRESS
 */
[Event(name='onBeforeItemLongPress', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_DOWN
 */
[Event(name='onBeforeItemMouseDown', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_ENTER
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_ENTER
 */
[Event(name='onBeforeItemMouseEnter', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_LEAVE
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_LEAVE
 */
[Event(name='onBeforeItemMouseLeave', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.BEFORE_ITEM_MOUSE_UP
 */
[Event(name='onBeforeItemMouseUp', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CLICK
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CLICK
 */
[Event(name='onBeforeRowBodyClick', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CONTEXT_MENU
 */
[Event(name='onBeforeRowBodyContextMenu', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_DBLCLICK
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_DBLCLICK
 */
[Event(name='onBeforeRowBodyDblclick', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_DOWN
 */
[Event(name='onBeforeRowBodyKeyDown', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEYPRESS
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEYPRESS
 */
[Event(name='onBeforeRowBodyKeypress', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_UP
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_UP
 */
[Event(name='onBeforeRowBodyKeyUp', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_LONG_PRESS
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_LONG_PRESS
 */
[Event(name='onBeforeRowBodyLongPress', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_DOWN
 */
[Event(name='onBeforeRowBodyMouseDown', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_UP
 */
[Event(name='onBeforeRowBodyMouseUp', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_keyEvent_prevRow_nextRow_forwardEvent.BEFORE_ROW_EXIT
 * @eventType ext.panel.events.TablePanel_keyEvent_prevRow_nextRow_forwardEvent.BEFORE_ROW_EXIT
 */
[Event(name='onBeforeRowExit', type='ext.panel.events.TablePanel_keyEvent_prevRow_nextRow_forwardEvent')]
/**
 * @see ext.panel.events.TablePanel_record_indexEvent.BEFORE_SELECT
 * @eventType ext.panel.events.TablePanel_record_indexEvent.BEFORE_SELECT
 */
[Event(name='onBeforeSelect', type='ext.panel.events.TablePanel_record_indexEvent')]
/**
 * @see ext.panel.events.TablePanel_An_extensionEvent.BEFORE_SELECTION_EXTEND
 * @eventType ext.panel.events.TablePanel_An_extensionEvent.BEFORE_SELECTION_EXTEND
 */
[Event(name='onBeforeSelectionExtend', type='ext.panel.events.TablePanel_An_extensionEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CLICK
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CLICK
 */
[Event(name='onCellClick', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CONTEXT_MENU
 */
[Event(name='onCellContextMenu', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_DBLCLICK
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_DBLCLICK
 */
[Event(name='onCellDblclick', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_KEY_DOWN
 */
[Event(name='onCellKeyDown', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_DOWN
 */
[Event(name='onCellMouseDown', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_UP
 */
[Event(name='onCellMouseUp', type='ext.panel.events.TablePanel_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_columnEvent.COLUMN_HIDE
 * @eventType ext.panel.events.TablePanel_ct_columnEvent.COLUMN_HIDE
 */
[Event(name='onColumnHide', type='ext.panel.events.TablePanel_ct_columnEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_fromIdx_toIdxEvent.COLUMN_MOVE
 * @eventType ext.panel.events.TablePanel_ct_column_fromIdx_toIdxEvent.COLUMN_MOVE
 */
[Event(name='onColumnMove', type='ext.panel.events.TablePanel_ct_column_fromIdx_toIdxEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_widthEvent.COLUMN_RESIZE
 * @eventType ext.panel.events.TablePanel_ct_column_widthEvent.COLUMN_RESIZE
 */
[Event(name='onColumnResize', type='ext.panel.events.TablePanel_ct_column_widthEvent')]
/**
 * @see ext.panel.events.TablePanel_ctEvent.COLUMNS_CHANGED
 * @eventType ext.panel.events.TablePanel_ctEvent.COLUMNS_CHANGED
 */
[Event(name='onColumnsChanged', type='ext.panel.events.TablePanel_ctEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_columnEvent.COLUMNS_HOW
 * @eventType ext.panel.events.TablePanel_ct_columnEvent.COLUMNS_HOW
 */
[Event(name='onColumnsHow', type='ext.panel.events.TablePanel_ct_columnEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_CLICK
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_CLICK
 */
[Event(name='onContainerClick', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_CONTEXT_MENU
 */
[Event(name='onContainerContextMenu', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_DBLCLICK
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_DBLCLICK
 */
[Event(name='onContainerDblclick', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_KEY_DOWN
 */
[Event(name='onContainerKeyDown', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_KEYPRESS
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_KEYPRESS
 */
[Event(name='onContainerKeypress', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_KEY_UP
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_KEY_UP
 */
[Event(name='onContainerKeyUp', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_DOWN
 */
[Event(name='onContainerMouseDown', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_OUT
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_OUT
 */
[Event(name='onContainerMouseOut', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_OVER
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_OVER
 */
[Event(name='onContainerMouseOver', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_eEvent.CONTAINER_MOUSE_UP
 */
[Event(name='onContainerMouseUp', type='ext.panel.events.TablePanel_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_indexEvent.DESELECT
 * @eventType ext.panel.events.TablePanel_record_indexEvent.DESELECT
 */
[Event(name='onDeselect', type='ext.panel.events.TablePanel_record_indexEvent')]
/**
 * @see ext.panel.events.TablePanel_columnEvent.FILTER_ACTIVATE
 * @eventType ext.panel.events.TablePanel_columnEvent.FILTER_ACTIVATE
 */
[Event(name='onFilterActivate', type='ext.panel.events.TablePanel_columnEvent')]
/**
 * @see ext.panel.events.TablePanel_store_filtersEvent.FILTER_CHANGE
 * @eventType ext.panel.events.TablePanel_store_filtersEvent.FILTER_CHANGE
 */
[Event(name='onFilterChange', type='ext.panel.events.TablePanel_store_filtersEvent')]
/**
 * @see ext.panel.events.TablePanel_columnEvent.FILTER_DEACTIVATE
 * @eventType ext.panel.events.TablePanel_columnEvent.FILTER_DEACTIVATE
 */
[Event(name='onFilterDeactivate', type='ext.panel.events.TablePanel_columnEvent')]
/**
 * @see ext.panel.events.TablePanel_store_grouperEvent.GROUP_CHANGE
 * @eventType ext.panel.events.TablePanel_store_grouperEvent.GROUP_CHANGE
 */
[Event(name='onGroupChange', type='ext.panel.events.TablePanel_store_grouperEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_CLICK
 * @eventType ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_CLICK
 */
[Event(name='onHeaderClick', type='ext.panel.events.TablePanel_ct_column_e_tEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_CONTEXT_MENU
 */
[Event(name='onHeaderContextMenu', type='ext.panel.events.TablePanel_ct_column_e_tEvent')]
/**
 * @see ext.panel.events.TablePanel_menu_headerCtEvent.HEADER_MENU_CREATE
 * @eventType ext.panel.events.TablePanel_menu_headerCtEvent.HEADER_MENU_CREATE
 */
[Event(name='onHeaderMenuCreate', type='ext.panel.events.TablePanel_menu_headerCtEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_TRIGGER_CLICK
 * @eventType ext.panel.events.TablePanel_ct_column_e_tEvent.HEADER_TRIGGER_CLICK
 */
[Event(name='onHeaderTriggerClick', type='ext.panel.events.TablePanel_ct_column_e_tEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_CLICK
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_CLICK
 */
[Event(name='onItemClick', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_CONTEXT_MENU
 */
[Event(name='onItemContextMenu', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_DBLCLICK
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_DBLCLICK
 */
[Event(name='onItemDblclick', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEY_DOWN
 */
[Event(name='onItemKeyDown', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEYPRESS
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEYPRESS
 */
[Event(name='onItemKeypress', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEY_UP
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_KEY_UP
 */
[Event(name='onItemKeyUp', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_LONG_PRESS
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_LONG_PRESS
 */
[Event(name='onItemLongPress', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_DOWN
 */
[Event(name='onItemMouseDown', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_ENTER
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_ENTER
 */
[Event(name='onItemMouseEnter', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_LEAVE
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_LEAVE
 */
[Event(name='onItemMouseLeave', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_record_item_index_eEvent.ITEM_MOUSE_UP
 */
[Event(name='onItemMouseUp', type='ext.panel.events.TablePanel_record_item_index_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_CLICK
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_CLICK
 */
[Event(name='onRowBodyClick', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_CONTEXT_MENU
 */
[Event(name='onRowBodyContextMenu', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_DBLCLICK
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_DBLCLICK
 */
[Event(name='onRowBodyDblclick', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEY_DOWN
 */
[Event(name='onRowBodyKeyDown', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEYPRESS
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEYPRESS
 */
[Event(name='onRowBodyKeypress', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEY_UP
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_KEY_UP
 */
[Event(name='onRowBodyKeyUp', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_LONG_PRESS
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_LONG_PRESS
 */
[Event(name='onRowBodyLongPress', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_DOWN
 */
[Event(name='onRowBodyMouseDown', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_UP
 */
[Event(name='onRowBodyMouseUp', type='ext.panel.events.TablePanel_view_rowBodyEl_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_CLICK
 * @eventType ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_CLICK
 */
[Event(name='onRowClick', type='ext.panel.events.TablePanel_record_element_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_tr_rowIndex_eEvent.ROW_CONTEXT_MENU
 * @eventType ext.panel.events.TablePanel_record_tr_rowIndex_eEvent.ROW_CONTEXT_MENU
 */
[Event(name='onRowContextMenu', type='ext.panel.events.TablePanel_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_DBLCLICK
 * @eventType ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_DBLCLICK
 */
[Event(name='onRowDblclick', type='ext.panel.events.TablePanel_record_element_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_KEY_DOWN
 * @eventType ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_KEY_DOWN
 */
[Event(name='onRowKeyDown', type='ext.panel.events.TablePanel_record_element_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_tr_rowIndex_eEvent.ROW_MOUSE_DOWN
 * @eventType ext.panel.events.TablePanel_record_tr_rowIndex_eEvent.ROW_MOUSE_DOWN
 */
[Event(name='onRowMouseDown', type='ext.panel.events.TablePanel_record_tr_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_MOUSE_UP
 * @eventType ext.panel.events.TablePanel_record_element_rowIndex_eEvent.ROW_MOUSE_UP
 */
[Event(name='onRowMouseUp', type='ext.panel.events.TablePanel_record_element_rowIndex_eEvent')]
/**
 * @see ext.panel.events.TablePanel_record_indexEvent.SELECT
 * @eventType ext.panel.events.TablePanel_record_indexEvent.SELECT
 */
[Event(name='onSelect', type='ext.panel.events.TablePanel_record_indexEvent')]
/**
 * @see ext.panel.events.TablePanel_selectedEvent.SELECTION_CHANGE
 * @eventType ext.panel.events.TablePanel_selectedEvent.SELECTION_CHANGE
 */
[Event(name='onSelectionChange', type='ext.panel.events.TablePanel_selectedEvent')]
/**
 * @see ext.panel.events.TablePanel_An_extensionEvent.SELECTION_EXTENDER_DRAG
 * @eventType ext.panel.events.TablePanel_An_extensionEvent.SELECTION_EXTENDER_DRAG
 */
[Event(name='onSelectionExtenderDrag', type='ext.panel.events.TablePanel_An_extensionEvent')]
/**
 * @see ext.panel.events.TablePanel_ct_column_directionEvent.SORT_CHANGE
 * @eventType ext.panel.events.TablePanel_ct_column_directionEvent.SORT_CHANGE
 */
[Event(name='onSortChange', type='ext.panel.events.TablePanel_ct_column_directionEvent')]
/**
 * @see ext.panel.events.TablePanelEvent.VIEW_READY
 * @eventType ext.panel.events.TablePanelEvent.VIEW_READY
 */
[Event(name='onViewReady', type='ext.panel.events.TablePanelEvent')]
/**
 * This class is the base class for both →<code>ext.tree.TreePanel</code> and
 * →<code>ext.grid.GridPanel</code>.
 * <p>TablePanel aggregates:</p>
 * <ul>
 * <li>a Selection Model</li>
 * <li>a View</li>
 * <li>a Store</li>
 * <li>Ext.grid.header.Container</li>
 * </ul>
 * @see ext.tree.TreePanel
 * @see ext.grid.GridPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html Original Ext JS documentation of 'Ext.panel.Table'
 */
public class TablePanel extends Panel implements ILockable {
  /**
   * @param config @inheritDoc
   */
  public function TablePanel(config:TablePanel = null) {
    super();
  }

  /**
   * An array of objects which register themselves
   * with a grid panel using →<code>registerActionable()</code> which are consulted upon entry
   * into actionable mode.
   * <p>These must implement the following methods:</p>
   * <ul>
   * <li>activateCell Called when actionable mode is requested upon a cell.
   * A →<code>ext.grid.CellContext</code> object is passed. If that cell
   * is actionable by the terms of the callee, the callee should return <code>true</code> if it
   * ascertains that the cell is actionable, and that it now contains focusable elements
   * which may be tabbed to.</li>
   * <li>activateRow Called when the user enters actionable mode in a row. The row DOM
   * is passed. Actionables should take any action they need to prime the row for cell
   * activation which happens as users TAB from cell to cell.</li>
   * </ul>
   * @see #registerActionable()
   * @see ext.grid.CellContext
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-actionables Original Ext JS documentation of 'actionables'
   */
  public native function get actionables():Array;

  [ExtConfig]
  /**
   * True to allow deselecting a record. This config is forwarded to
   * →<code>ext.selection.SelectionModel.allowDeselect</code>.
   * @default false
   * @see ext.selection.SelectionModel#allowDeselect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-allowDeselect Original Ext JS documentation of 'allowDeselect'
   */
  public native function get allowDeselect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDeselect(value:Boolean):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'presentation'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * Use <code>true</code> to load the store as soon as this component is fully constructed. It is
   * best to initiate the store load this way to allow this component and potentially
   * its plugins (such as <code>→ext.grid.filters.Filters</code>) to be ready to load.
   * @default false
   * @see ext.grid.filters.Filters
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-autoLoad Original Ext JS documentation of 'autoLoad'
   */
  public native function get autoLoad():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoLoad(value:Boolean):void;

  [ExtConfig]
  /**
   * Buffered rendering is enabled by default.
   * <p>Configure as <code>false</code> to disable buffered rendering.
   * See →<code>null</code>.</p>
   * @default true
   * @since 5.0.0
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-bufferedRenderer Original Ext JS documentation of 'bufferedRenderer'
   */
  public native function get bufferedRenderer():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bufferedRenderer(value:Boolean):void;

  [ExtConfig]
  /**
   * Adds column line styling
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-columnLines Original Ext JS documentation of 'columnLines'
   */
  public native function get columnLines():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columnLines(value:Boolean):void;

  [ExtConfig]
  /**
   * An array of <i>column</i> (→<code>ext.grid.column.Column</code>) definition objects which define all columns
   * that appear in this grid. Each column definition provides the header text for the column,
   * and a definition of where the data for that column comes from.
   * <p>This can also be a configuration object for a
   * →<code>ext.grid.header.HeaderContainer</code> which may override certain default
   * configurations if necessary. For example, the special layout may be overridden to use
   * a simpler layout, or one can set default values shared by all columns:</p>
   * <pre>
   * columns: {
   *     items: [
   *         {
   *             text: "Column A",
   *             dataIndex: "field_A"
   *         }, {
   *             text: "Column B",
   *             dataIndex: "field_B"
   *         },
   *         ...
   *     ],
   *     defaults: {
   *         flex: 1
   *     }
   * }
   * </pre>
   * @see ext.grid.column.Column
   * @see ext.grid.header.HeaderContainer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-columns Original Ext JS documentation of 'columns'
   */
  public native function get columns():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columns(value:Array):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'store'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to enable deferred row rendering.
   * <p>This allows the View to execute a refresh quickly, with the update of the row structure
   * deferred so that layouts with GridPanels appear, and lay out more quickly.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-deferRowRender Original Ext JS documentation of 'deferRowRender'
   */
  public native function get deferRowRender():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deferRowRender(value:Boolean):void;

  [ExtConfig]
  /**
   * True to disable selection model.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-disableSelection Original Ext JS documentation of 'disableSelection'
   */
  public native function get disableSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * Default text (HTML tags are accepted) to display in the
   * Panel body when the Store is empty. When specified, and the Store is empty, the
   * text will be rendered inside a DIV with the CSS class "x-grid-empty". The emptyText
   * will not display until the first load of the associated store by default. If you
   * want the text to be displayed prior to the first store load use the
   * →<code>ext.view.TableView.deferEmptyText</code> config in the →<code>viewConfig</code>
   * config.
   * @see ext.view.TableView#deferEmptyText
   * @see #viewConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   */
  public native function get emptyText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set emptyText(value:String):void;

  [ExtConfig]
  /**
   * False to disable column hiding within this grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-enableColumnHide Original Ext JS documentation of 'enableColumnHide'
   */
  public native function get enableColumnHide():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableColumnHide(value:Boolean):void;

  [ExtConfig]
  /**
   * False to disable column dragging within this grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-enableColumnMove Original Ext JS documentation of 'enableColumnMove'
   */
  public native function get enableColumnMove():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableColumnMove(value:Boolean):void;

  [ExtConfig]
  /**
   * False to disable column resizing within this grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-enableColumnResize Original Ext JS documentation of 'enableColumnResize'
   */
  public native function get enableColumnResize():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableColumnResize(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to enable locking support for this grid. Alternatively, locking will also
   * be automatically enabled if any of the columns in the →<code>columns</code> configuration
   * contain a →<code>ext.grid.column.Column.locked</code> config option.
   * <p>A locking grid is processed in a special way. The configuration options are cloned and <i>two</i>
   * grids are created to be the locked (left) side and the normal (right) side. This Panel
   * becomes merely a <i>container</i> (→<code>ext.container.Container</code>) which arranges both in an
   * →<code>ext.layout.container.HBoxLayout</code> layout.</p>
   * <p><i>Plugins</i> (→<code>plugins</code>) may be targeted at either locked, or unlocked grid, or, both,
   * in which case the plugin is cloned and used on both sides.</p>
   * <p>Plugins may also be targeted at the containing locking Panel.</p>
   * <p>This is configured by specifying a <code>lockableScope</code> property in your plugin which may have
   * the following values:</p>
   * <ul>
   * <li><code>"both"</code> (the default) - The plugin is added to both grids</li>
   * <li><code>"top"</code> - The plugin is added to the containing Panel</li>
   * <li><code>"locked"</code> - The plugin is added to the locked (left) grid</li>
   * <li><code>"normal"</code> - The plugin is added to the normal (right) grid</li>
   * </ul>
   * <p>If <code>both</code> is specified, then each copy of the plugin gains a property <code>lockingPartner</code>
   * which references its sibling on the other side so that they can synchronize operations
   * if necessary.</p>
   * <p><i>Features</i> (→<code>features</code>) may also be configured with <code>lockableScope</code> and may target
   * the locked grid, the normal grid or both grids. Features also get a <code>lockingPartner</code>
   * reference injected.</p>
   * @default false
   * @see #columns
   * @see ext.grid.column.Column#locked
   * @see ext.container.Container
   * @see ext.layout.container.HBoxLayout
   * @see #plugins
   * @see #features
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-enableLocking Original Ext JS documentation of 'enableLocking'
   */
  public native function get enableLocking():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableLocking(value:Boolean):void;

  [ExtConfig]
  [ArrayElementType("ext.grid.feature.IFeature")]
  /**
   * An array of grid Features to be added to this grid.
   * <p>Features config behaves much like →<code>plugins</code>.
   * A feature can be added by either directly referencing the instance:</p>
   * <pre>
   * features: [
   *     Ext.create('Ext.grid.feature.GroupingSummary', {groupHeaderTpl: 'Subject: {name}'})
   * ],
   * </pre>
   * <p>By using config object with ftype:</p>
   * <pre>
   * features: [{ftype: 'groupingsummary', groupHeaderTpl: 'Subject: {name}'}],
   * </pre>
   * <p>Or with just a ftype:</p>
   * <pre>
   * features: ['grouping', 'groupingsummary'],
   * </pre>
   * <p>See →<code>null</code> for list of all ftypes.</p>
   * @see #plugins
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-features Original Ext JS documentation of 'features'
   */
  public native function get features():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set features(value:Array):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The focused cell, model or index. Typically used with <i>binding</i> (→<code>bind</code>).
   * <p>If bound to a record (such as a selection), the first cell will be focused.</p>
   * @default null
   * @see #bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-focused Original Ext JS documentation of 'focused'
   * @see #getFocused()
   * @see #setFocused()
   */
  public native function get focused():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set focused(value:*):void;

  [ExtConfig]
  /**
   * True to force the columns to fit into the available width. Headers are first sized according
   * to configuration, whether that be a specific width, or flex. Then they are all proportionally
   * changed in width so that the entire content width is used. For more accurate control,
   * it is more optimal to specify a flex setting on the columns that are to be stretched
   * and explicit widths on columns that are not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-forceFit Original Ext JS documentation of 'forceFit'
   */
  public native function get forceFit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forceFit(value:Boolean):void;

  /**
   * True to indicate that a view has been injected into the panel.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-hasView Original Ext JS documentation of 'hasView'
   */
  public native function get hasView():Boolean;

  /**
   * @private
   */
  public native function set hasView(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * To show no borders around grid headers, configure this as <code>false</code>.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-headerBorders Original Ext JS documentation of 'headerBorders'
   * @see #getHeaderBorders()
   * @see #setHeaderBorders()
   */
  public native function get headerBorders():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set headerBorders(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * By default, visibility of headers is managed automatically based upon
   * whether there is textual content to display.
   * This configuration is only necessary if you want to disable automatic
   * header visibility management.
   * <p>If no columns have a <i>text</i> (→<code>ext.grid.column.Column.title</code>) config
   * (for example in the case of a →<code>ext.tree.TreePanel</code> with no
   * columns specified), and no columns have
   * <i>child columns</i> (→<code>ext.grid.column.Column.columns</code>) then headers are hidden.</p>
   * <p>If this status changes - if the column set ever goes from none having
   * text, to one having text or vice versa), then the visibility of headers
   * will be recalculated.</p>
   * <p>Configure as <code>true</code> to hide column headers. Configure as <code>false</code> to show
   * column headers even if none of them have text.</p>
   * @default null
   * @see ext.grid.column.Column#title
   * @see ext.tree.TreePanel
   * @see ext.grid.column.Column#columns
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-hideHeaders Original Ext JS documentation of 'hideHeaders'
   * @see #getHideHeaders()
   * @see #setHideHeaders()
   */
  public native function get hideHeaders():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hideHeaders(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * By default, a lockable grid uses an →<code>ext.layout.container.HBoxLayout</code> layout to arrange
   * the two grids (possibly separated by a splitter).
   * <p>Using this config it is possible to specify a different layout to arrange the two grids.</p>
   * @see ext.layout.container.HBoxLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #getLayout()
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * TableViews are buffer rendered in 5.x and above which means that only the visible subset
   * of data rows are rendered into the DOM. These are removed and added as scrolling demands.
   * <p>This configures the number of extra rows to render on the leading side of scrolling
   * <b>outside the →<code>numFromEdge</code></b> buffer as scrolling proceeds.</p>
   * @default 20
   * @see #numFromEdge
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-leadingBufferZone Original Ext JS documentation of 'leadingBufferZone'
   */
  public native function get leadingBufferZone():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set leadingBufferZone(value:Number):void;

  [ExtConfig]
  /**
   * The text to display on the column menu to lock a column.
   * @default 'Lock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockText Original Ext JS documentation of 'lockText'
   */
  public native function get lockText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockText(value:String):void;

  [ExtConfig]
  /**
   * Any special configuration options for the locked part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedGridConfig Original Ext JS documentation of 'lockedGridConfig'
   */
  public native function get lockedGridConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedGridConfig(value:Object):void;

  [ExtConfig]
  /**
   * A view configuration to be applied to the locked side of the grid. Any conflicting
   * configurations between lockedViewConfig and viewConfig will be overwritten by the
   * lockedViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedViewConfig Original Ext JS documentation of 'lockedViewConfig'
   */
  public native function get lockedViewConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedViewConfig(value:Object):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to have columns remember their sorted state after other columns have been
   * clicked upon to sort.
   * <p>As subsequent columns are clicked upon, they become the new primary sort key.</p>
   * <p>The maximum number of sorters allowed in a Store is configurable via its underlying data
   * collection. See →<code>ext.util.Collection.multiSortLimit</code></p>
   * @default false
   * @see ext.util.Collection#multiSortLimit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-multiColumnSort Original Ext JS documentation of 'multiColumnSort'
   */
  public native function get multiColumnSort():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multiColumnSort(value:Boolean):void;

  [Deprecated(replacement="mode", since="4.1.1")]
  [ExtConfig]
  /**
   * True to enable 'MULTI' selection mode on selection model.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-multiSelect Original Ext JS documentation of 'multiSelect'
   */
  public native function get multiSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multiSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * Any special configuration options for the normal part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalGridConfig Original Ext JS documentation of 'normalGridConfig'
   */
  public native function get normalGridConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set normalGridConfig(value:Object):void;

  [ExtConfig]
  /**
   * A view configuration to be applied to the normal/unlocked side of the grid. Any
   * conflicting configurations between normalViewConfig and viewConfig will be
   * overwritten by the normalViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalViewConfig Original Ext JS documentation of 'normalViewConfig'
   */
  public native function get normalViewConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set normalViewConfig(value:Object):void;

  [ExtConfig]
  /**
   * This configures the zone which causes new rows to be appended to the view. As soon
   * as the edge of the rendered grid is this number of rows from the edge of the viewport,
   * the view is moved.
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-numFromEdge Original Ext JS documentation of 'numFromEdge'
   */
  public native function get numFromEdge():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set numFromEdge(value:Number):void;

  /**
   * If you are writing a grid plugin or a {Ext.grid.feature.Feature Feature} which creates
   * a column-based structure which needs a view refresh when columns are moved, then set
   * this property in the grid.
   * <p>An example is the built in <i>Summary</i> (→<code>ext.grid.feature.AbstractSummary</code>) Feature.
   * This creates summary rows, and the summary columns must be in the same order
   * as the data columns. This plugin sets the <code>→optimizedColumnMove</code> to `false.</p>
   * @see ext.grid.feature.AbstractSummary
   * @see #optimizedColumnMove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#property-optimizedColumnMove Original Ext JS documentation of 'optimizedColumnMove'
   */
  public native function get optimizedColumnMove():Boolean;

  /**
   * @private
   */
  public native function set optimizedColumnMove(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to ensure that measurements (such as locking grid's row-height synchronization)
   * accurately measure rows with sub-pixel sizes. This can be an issue for some types
   * of row content on browsers that support sub-pixel sizing. Note that setting this to <code>true</code>
   * may cause a decrease in performance for large amounts of rendered content and therefore
   * should only be used when needed.
   * @default false
   * @since 6.5.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-preciseHeight Original Ext JS documentation of 'preciseHeight'
   */
  public native function get preciseHeight():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preciseHeight(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'selection'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Set this to true to <b>always</b> leave a scrollbar sized space at the end of the grid content
   * when fitting content into the width of the grid.
   * <p>If the grid's record count fluctuates enough to hide and show the scrollbar regularly,
   * this setting avoids the multiple layouts associated with switching from scrollbar present
   * to scrollbar not present.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-reserveScrollbar Original Ext JS documentation of 'reserveScrollbar'
   */
  public native function get reserveScrollbar():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reserveScrollbar(value:Boolean):void;

  [ExtConfig]
  /**
   * Adds row line styling
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-rowLines Original Ext JS documentation of 'rowLines'
   */
  public native function get rowLines():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rowLines(value:Boolean):void;

  [ExtConfig]
  /**
   * The type or a config object specifying the type of the ViewModel to instantiate when creating
   * ViewModels for records to which <i>widgets in widget columns</i> (→<code>ext.grid.column.WidgetColumn</code>),
   * and widgets in a →<code>ext.grid.plugin.RowWidgetPlugin</code> row bind.
   * @see ext.grid.column.WidgetColumn
   * @see ext.grid.plugin.RowWidgetPlugin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-rowViewModel Original Ext JS documentation of 'rowViewModel'
   */
  public native function get rowViewModel():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rowViewModel(value:*):void;

  [Deprecated(replacement="scrollable", since="5.1.0")]
  [ExtConfig]
  /**
   * Scrollers configuration. Valid values are 'both', 'horizontal' or 'vertical'.
   * True implies 'both'. False implies 'none'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-scroll Original Ext JS documentation of 'scroll'
   */
  public native function get scroll():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scroll(value:*):void;

  [ExtConfig]
  /**
   * True to constrain column dragging so that a column cannot be dragged in or out of it's
   * current group. Only relevant while →<code>enableColumnMove</code> is enabled.
   * @default false
   * @see #enableColumnMove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-sealedColumns Original Ext JS documentation of 'sealedColumns'
   */
  public native function get sealedColumns():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sealedColumns(value:Boolean):void;

  [ExtConfig]
  /**
   * A <i>selection model</i> (→<code>ext.selection.SelectionModel</code>) instance or config object, or the selection
   * model class's alias string.
   * <p>In latter case its <code>type</code> property determines to which type of selection model this config
   * is applied.</p>
   * @default rowmodel
   * @see ext.selection.SelectionModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-selModel Original Ext JS documentation of 'selModel'
   */
  public native function get selModel():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selModel(value:*):void;

  [Deprecated(replacement="selModel", since="5.1.0")]
  [ExtConfig]
  /**
   * An xtype of selection model to use. This is used to create selection model if just
   * a config object or nothing at all given in →<code>selModel</code> config.
   * @see #selModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-selType Original Ext JS documentation of 'selType'
   */
  public native function get selType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selType(value:String):void;

  [ExtConfig]
  /**
   * The selected model. Typically used with <i>binding</i> (→<code>bind</code>).
   * @see #bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-selection Original Ext JS documentation of 'selection'
   * @see #setSelection()
   */
  public native function get selection():Model;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set selection(value:Model):void;

  [Deprecated(replacement="mode", since="4.1.1")]
  [ExtConfig]
  /**
   * True to enable 'SIMPLE' selection mode on selection model.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-simpleSelect Original Ext JS documentation of 'simpleSelect'
   */
  public native function get simpleSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set simpleSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * False to disable column sorting via clicking the header and via the Sorting menu items.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-sortableColumns Original Ext JS documentation of 'sortableColumns'
   */
  public native function get sortableColumns():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortableColumns(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to place a resizing <i>splitter</i> (→<code>ext.resizer.Splitter</code>)
   * between the locked and unlocked columns. May also be a configuration object for the Splitter.
   * @default false
   * @see ext.resizer.Splitter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-split Original Ext JS documentation of 'split'
   */
  public native function get split():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set split(value:*):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * Adds the following stateEvents:</p>
   * <ul>
   * <li>→<code>event:onLockColumn</code></li>
   * <li>→<code>event:onUnlockColumn</code></li>
   * </ul>
   * @see #stateEvents
   * @see #stateful
   * @see #event:onLockColumn
   * @see #event:onUnlockColumn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  override public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set stateEvents(value:Array):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * <b>This is a required setting</b>. The data source to which the grid / tree is bound. Acceptable values for this
   * property are:
   * <ul>
   * <li><b>any →<code>ext.data.Store</code> class / subclass</b></li>
   * <li><b>an <i>ID of a store</i> (→<code>ext.data.Store.storeId</code>)</b></li>
   * <li><b>a →<code>ext.data.Store</code> config object</b>. When passing a config you can
   * specify the store type by alias. Passing a config object with a store type will
   * dynamically create a new store of that type when the grid / tree is instantiated.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   * Ext.define('MyApp.store.Customers', {
   *     extend: 'Ext.data.Store',
   *     alias: 'store.customerstore',
   *     fields: ['name']
   * });
   *
   * Ext.create({
   *     xtype: 'gridpanel',
   *     renderTo: document.body,
   *     store: {
   *         type: 'customerstore',
   *         data: [{
   *             name: 'Foo'
   *         }]
   *     },
   *     columns: [{
   *         text: 'Name',
   *         dataIndex: 'name'
   *     }]
   * });
   * </pre>
   * @see ext.data.Store
   * @see ext.data.Store#storeId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set store(value:*):void;

  [ExtConfig]
  /**
   * The xtype of the subgrid to specify. If this is not specified lockable will
   * determine the subgrid xtype to create by the following rule. Use the superclasses
   * xtype if the superclass is NOT tablepanel, otherwise use the xtype itself.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-subGridXType Original Ext JS documentation of 'subGridXType'
   */
  public native function get subGridXType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set subGridXType(value:String):void;

  [ExtConfig]
  /**
   * Synchronize rowHeight between the normal and locked grid view. This is turned on
   * by default. If your grid is guaranteed to have rows of all the same height, you
   * should set this to false to optimize performance.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-syncRowHeight Original Ext JS documentation of 'syncRowHeight'
   */
  public native function get syncRowHeight():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set syncRowHeight(value:Boolean):void;

  [ExtConfig]
  /**
   * TableViews are buffer rendered in 5.x and above which means that only the visible subset
   * of data rows are rendered into the DOM. These are removed and added as scrolling demands.
   * <p>This configures the number of extra rows to render on the trailing side of scrolling
   * <b>outside the →<code>numFromEdge</code></b> buffer as scrolling proceeds.</p>
   * @default 10
   * @see #numFromEdge
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-trailingBufferZone Original Ext JS documentation of 'trailingBufferZone'
   */
  public native function get trailingBufferZone():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trailingBufferZone(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default [
   *     'selection'
   * ]
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  /**
   * The text to display on the column menu to unlock a column.
   * @default 'Unlock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-unlockText Original Ext JS documentation of 'unlockText'
   */
  public native function get unlockText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set unlockText(value:String):void;

  [Deprecated(replacement="variableRowHeight", since="5.0.0")]
  [ExtConfig]
  /**
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-variableRowHeight Original Ext JS documentation of 'variableRowHeight'
   */
  public native function get variableRowHeight():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set variableRowHeight(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The →<code>ext.view.TableView</code> used by the grid. Use →<code>viewConfig</code> to just supply
   * some config options to view (instead of creating an entire View instance).
   * @see ext.view.TableView
   * @see #viewConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-view Original Ext JS documentation of 'view'
   * @see #getView()
   */
  public native function get view():TableView;

  [ExtConfig("viewConfig")]
  /**
   * @private
   */
  public native function set view(value:TableView):void;

  [ExtConfig]
  /**
   * A config object that will be applied to the grid's UI view. Any of the config options
   * available for →<code>ext.view.TableView</code> can be specified here. This option is ignored
   * if →<code>view</code> is specified.
   * @see ext.view.TableView
   * @see #view
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-viewConfig Original Ext JS documentation of 'viewConfig'
   */
  public native function get viewConfig():TableView;

  [ExtConfig]
  /**
   * @private
   */
  public native function set viewConfig(value:TableView):void;

  [ExtConfig]
  /**
   * An xtype of view to use. This is automatically set to 'tableview' by
   * <i>Grid</i> (→<code>ext.grid.GridPanel</code>) and to 'treeview' by <i>Tree</i> (→<code>ext.tree.TreePanel</code>).
   * @see ext.grid.GridPanel
   * @see ext.tree.TreePanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#cfg-viewType Original Ext JS documentation of 'viewType'
   */
  public native function get viewType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set viewType(value:String):void;

  /**
   * Disables interaction with, and masks this grid's column headers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-disableColumnHeaders Original Ext JS documentation of 'disableColumnHeaders'
   */
  public native function disableColumnHeaders():void;

  /**
   * Enables interaction with, and unmasks this grid's column headers after a call
   * to {#disableColumnHeaders}.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-enableColumnHeaders Original Ext JS documentation of 'enableColumnHeaders'
   */
  public native function enableColumnHeaders():void;

  /**
   * Scrolls the specified record into view.
   * @param record The record, record id, or the zero-based
   * position in the dataset to scroll to.
   * @param options An object containing options to modify the operation.
   * <ul>
   * <li><code>column</code> (optional) —
   * The column to scroll into view.
   * </li>
   * <li><code>animate:Boolean</code> (optional) —
   * Pass <code>true</code> to animate the row into view.
   * </li>
   * <li><code>highlight:Boolean</code> (optional) —
   * Pass <code>true</code> to highlight the row with a glow animation
   * when it is in view.
   * </li>
   * <li><code>select:Boolean</code> (optional) —
   * Pass as <code>true</code> to select the specified row.
   * </li>
   * <li><code>focus:Boolean</code> (optional) —
   * Pass as <code>true</code> to focus the specified row.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * A function to execute when the record is in view.
   * This may be necessary if the first parameter is a record index and the view is backed by a
   * <i>buffered store</i> (→<code>ext.data.BufferedStore</code>) which does not contain that record.
   * <ul>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> if acquiring the record's view node
   * was successful.
   * </li>
   * <li><code>record:ext.data.Model</code> (optional) —
   * If successful, the target record.
   * </li>
   * <li><code>node:js.HTMLElement</code> (optional) —
   * If successful, the record's view node.
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the callback function
   * is executed.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-ensureVisible Original Ext JS documentation of 'ensureVisible'
   * @see ext.data.BufferedStore
   */
  public native function ensureVisible(record:*, options:Object = null):void;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * Returns an array of all columns which exist in the grid's View, visible or not.
   * This goes down to the leaf column header level, and does not return <b>grouped</b>
   * headers which contain sub headers.
   * <p>It includes hidden headers even though they are not rendered. This is for
   * collection of menu items for the column hide/show menu.</p>
   * <p>Headers which have a hidden ancestor have a <code>hiddenAncestor: true</code> property
   * injected so that descendants are known to be hidden without interrogating that
   * header's ownerCt axis for a hidden ancestor.</p>
   * <p>See also →<code>ext.grid.header.HeaderContainer.getVisibleGridColumns()</code></p>
   * @return columns An array of columns. Returns an
   * empty array if no columns are found.
   * @see ext.grid.header.HeaderContainer#getVisibleGridColumns()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getColumns Original Ext JS documentation of 'getColumns'
   */
  public native function getColumns():Array;

  /**
   * Returns the value of <code>focused</code>.
   * @see #focused
   */
  public native function getFocused():*;

  /**
   * Returns the value of <code>headerBorders</code>.
   * @see #headerBorders
   */
  public native function getHeaderBorders():Boolean;

  /**
   * Gets the <i>headercontainer</i> (→<code>ext.grid.header.HeaderContainer</code>) for this grid / tree.
   * @return headercontainer
   * <p><b>Note:</b> While a locked grid / tree will return an instance of
   * →<code>null</code> you will code to the
   * →<code>ext.grid.header.HeaderContainer</code> API.</p>
   * @see ext.grid.header.HeaderContainer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getHeaderContainer Original Ext JS documentation of 'getHeaderContainer'
   * @see null
   */
  public native function getHeaderContainer():HeaderContainer;

  /**
   * Returns the value of <code>hideHeaders</code>.
   * @see #hideHeaders
   */
  public native function getHideHeaders():Boolean;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns the grid's selection. See <code>→ext.selection.SelectionModel.getSelection()</code>.
   * Returns an array of the currently selected records.
   * @return The selected records
   * @see ext.selection.SelectionModel#getSelection()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getSelection Original Ext JS documentation of 'getSelection'
   */
  public native function getSelection():Array;

  /**
   * Returns the selection model being used by this grid's <i>view</i> (→<code>ext.view.TableView</code>).
   * @return The selection model being used by this grid's
   * <i>view</i> (→<code>ext.view.TableView</code>).
   * @see ext.view.TableView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getSelectionModel Original Ext JS documentation of 'getSelectionModel'
   */
  public native function getSelectionModel():SelectionModel;

  /**
   * Returns the store associated with this Panel.
   * @return The store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getStore Original Ext JS documentation of 'getStore'
   */
  public native function getStore():Store;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Gets the view for this panel.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getView Original Ext JS documentation of 'getView'
   */
  public native function getView():TableView;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * Returns an array of the <b>visible</b> columns in the grid. This goes down to the
   * lowest column header level, and does not return <b>grouped</b> headers which contain
   * sub headers.
   * <p>See also →<code>ext.grid.header.HeaderContainer.getGridColumns()</code></p>
   * @return columns An array of visible columns. Returns
   * an empty array if no visible columns are found.
   * @see ext.grid.header.HeaderContainer#getGridColumns()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-getVisibleColumns Original Ext JS documentation of 'getVisibleColumns'
   */
  public native function getVisibleColumns():Array;

  /**
   * Reconfigures the grid or tree with a new store and/or columns. Stores and columns
   * may also be passed as params.
   * <pre>
   * grid.reconfigure(store, columns);
   * </pre>
   * <p>Additionally, you can pass just a store or columns.</p>
   * <pre>
   * tree.reconfigure(store);
   * // or
   * grid.reconfigure(columns);
   * // or
   * tree.reconfigure(null, columns);
   * </pre>
   * <p>If you're using locked columns, the →<code>enableLocking</code> config should be set
   * to <code>true</code> before the reconfigure method is executed.</p>
   * @param store The new store instance or store config. You can
   * pass <code>null</code> if no new store.
   * @param columns An array of column configs
   * @see #enableLocking
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-reconfigure Original Ext JS documentation of 'reconfigure'
   */
  public native function reconfigure(store:* = undefined, columns:Array = null):void;

  /**
   * @param actionable An object which has an interest in the implementation
   * of actionable mode in this grid.
   * <p>An actionable object may be a Plugin which upon activation injects tabbable elements
   * or Components into a grid row.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-registerActionable Original Ext JS documentation of 'registerActionable'
   */
  public native function registerActionable(actionable:Object):void;

  /**
   * @param scroll True to allow the Component to auto scroll.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-setAutoScroll Original Ext JS documentation of 'setAutoScroll'
   */
  override public native function setAutoScroll(scroll:Boolean):Component;

  /**
   * Sets the value of <code>focused</code>.
   * @param focused The new value.
   * @see #focused
   */
  public native function setFocused(focused:*):void;

  /**
   * Sets the value of <code>headerBorders</code>.
   * @param headerBorders The new value.
   * @see #headerBorders
   */
  public native function setHeaderBorders(headerBorders:Boolean):void;

  /**
   * Sets the value of <code>hideHeaders</code>.
   * @param hideHeaders The new value.
   * @see #hideHeaders
   */
  public native function setHideHeaders(hideHeaders:Boolean):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of the selection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-setSelection Original Ext JS documentation of 'setSelection'
   */
  public native function setSelection(selection:Model):void;

  /**
   * A convenience method that fires →<code>event:onReconfigure</code> with the store param.
   * To set the store AND change columns, use the <i>reconfigure method</i> (→<code>reconfigure()</code>).
   * @param store The new store.
   * @see #event:onReconfigure
   * @see #reconfigure()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#method-setStore Original Ext JS documentation of 'setStore'
   */
  public native function setStore(store:Store = null):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * @inheritDoc
   */
  public native function syncRowHeights():void;
}
}