package ext.panel.events {
import ext.panel.Panel;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.panel.events.Panel_newTitle_oldTitleEvent")]
public class Panel_newTitle_oldTitleEvent extends FlExtEvent {
  /**
   * Fires after the Panel title has been set or changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Panel.html#event-titlechange Original Ext JS documentation of 'titlechange'
   * @see ext.panel.Panel
   * @eventType onTitleChange
   */
  public static const TITLE_CHANGE:String = "onTitleChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "newTitle", "oldTitle", "eOpts"];

  public function Panel_newTitle_oldTitleEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new title.
   */
  public native function get newTitle():String;

  /**
   * The previous panel title.
   */
  public native function get oldTitle():String;

  /**
   * the Panel which has been resized.
   */
  public native function get source():Panel;
}
}