package ext.panel.events {
import ext.grid.GridPanel;
import ext.grid.column.Column;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.panel.events.TablePanel_columnEvent")]
public class TablePanel_columnEvent extends FlExtEvent {
  /**
   * Fires when an inactive filter becomes active
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#event-filteractivate Original Ext JS documentation of 'filteractivate'
   * @see ext.panel.TablePanel
   * @eventType onFilterActivate
   */
  public static const FILTER_ACTIVATE:String = "onFilterActivate";
  /**
   * Fires when an active filter becomes inactive
   * @since 6.5.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#event-filterdeactivate Original Ext JS documentation of 'filterdeactivate'
   * @see ext.panel.TablePanel
   * @eventType onFilterDeactivate
   */
  public static const FILTER_DEACTIVATE:String = "onFilterDeactivate";
  /**
   * Fires when a column is locked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#event-lockcolumn Original Ext JS documentation of 'lockcolumn'
   * @see ext.panel.TablePanel
   * @eventType onLockColumn
   */
  public static const LOCK_COLUMN:String = "onLockColumn";
  /**
   * Fires when a column is unlocked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#event-unlockcolumn Original Ext JS documentation of 'unlockcolumn'
   * @see ext.panel.TablePanel
   * @eventType onUnlockColumn
   */
  public static const UNLOCK_COLUMN:String = "onUnlockColumn";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "column", "eOpts"];

  public function TablePanel_columnEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The column being locked.
   */
  public native function get column():Column;

  /**
   * The gridpanel.
   */
  public native function get source():GridPanel;
}
}