package ext.panel.events {
import ext.grid.column.Column;
import ext.grid.header.HeaderContainer;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.panel.events.TablePanel_ct_columnEvent")]
public class TablePanel_ct_columnEvent extends FlExtEvent {
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#event-columnshow Original Ext JS documentation of 'columnshow'
   * @see ext.panel.TablePanel
   * @eventType onColumnsHow
   */
  public static const COLUMNS_HOW:String = "onColumnsHow";
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#event-columnhide Original Ext JS documentation of 'columnhide'
   * @see ext.panel.TablePanel
   * @eventType onColumnHide
   */
  public static const COLUMN_HIDE:String = "onColumnHide";
  public static const __PARAMETER_SEQUENCE__:Array = ["ct", "column", "eOpts"];

  public function TablePanel_ct_columnEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The Column header Component which provides
   * the column definition
   */
  public native function get column():Column;

  /**
   * The grid's header Container which encapsulates
   * all column headers.
   */
  public native function get ct():HeaderContainer;
}
}