package ext.panel.events {
import ext.grid.header.HeaderContainer;
import ext.menu.Menu;
import ext.panel.TablePanel;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.panel.events.TablePanel_menu_headerCtEvent")]
public class TablePanel_menu_headerCtEvent extends FlExtEvent {
  /**
   * Fired immediately after the column header menu is created.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Table.html#event-headermenucreate Original Ext JS documentation of 'headermenucreate'
   * @see ext.panel.TablePanel
   * @eventType onHeaderMenuCreate
   */
  public static const HEADER_MENU_CREATE:String = "onHeaderMenuCreate";
  public static const __PARAMETER_SEQUENCE__:Array = ["grid", "menu", "headerCt", "eOpts"];

  public function TablePanel_menu_headerCtEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * This grid instance
   */
  public native function get grid():TablePanel;

  /**
   * This header container
   */
  public native function get headerCt():HeaderContainer;

  /**
   * The Menu that was created
   */
  public native function get menu():Menu;
}
}