package ext.panel.events {
import ext.Component;
import ext.event.Event;
import ext.panel.Tool;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.panel.events.Tool_e_ownerEvent")]
public class Tool_e_ownerEvent extends FlExtEvent {
  /**
   * Fires when the tool is clicked
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.panel.Tool.html#event-click Original Ext JS documentation of 'click'
   * @see ext.panel.Tool
   * @eventType onClick
   */
  public static const CLICK:String = "onClick";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "e", "owner", "eOpts"];

  public function Tool_e_ownerEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The event object
   */
  public native function get e():Event;

  /**
   * The logical owner of the tool. In a typical
   * <code>→ext.panel.Panel</code>, this is set to the owning panel. This value comes from the
   * <code>→toolOwner</code> config.
   * Note that if the tool handler destroys the tool and/or its owner, the event
   * will not fire.
   * @see ext.panel.Panel
   * @see ext.panel.Tool#toolOwner
   */
  public native function get owner():Component;

  public native function get source():Tool;
}
}