package ext.picker {
import ext.Component;

[Native("Ext.picker.Color", require)]
/**
 * @see ext.picker.events.ColorPicker_colorEvent.SELECT
 * @eventType ext.picker.events.ColorPicker_colorEvent.SELECT
 */
[Event(name='onSelect', type='ext.picker.events.ColorPicker_colorEvent')]
/**
 * Color picker provides a simple color palette for choosing colors. The picker can be rendered
 * to any container. The available default to a standard 40-color palette; this can be customized
 * with the →<code>colors</code> config.
 * <p>Typically you will need to implement a handler function to be notified when the user chooses
 * a color from the picker; you can register the handler using the →<code>event:onSelect</code> event,
 * or by implementing the →<code>handler</code> method.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.picker.Color', {
 *     value: '993300',  // initial selected color
 *     renderTo: Ext.getBody(),
 *     listeners: {
 *         select: function(picker, selColor) {
 *             alert(selColor);
 *         }
 *     }
 * });
 * </pre>
 * @see #colors
 * @see #event:onSelect
 * @see #handler
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html Original Ext JS documentation of 'Ext.picker.Color'
 */
public class ColorPicker extends Component {
  /**
   * @param config @inheritDoc
   */
  public function ColorPicker(config:ColorPicker = null) {
    super();
  }

  [ExtConfig]
  /**
   * If set to true then reselecting a color that is already selected fires the
   * →<code>event:onSelect</code> event
   * @default false
   * @see #event:onSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-allowReselect Original Ext JS documentation of 'allowReselect'
   */
  public native function get allowReselect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowReselect(value:Boolean):void;

  [ExtConfig]
  /**
   * The DOM event that will cause a color to be selected. This can be any valid event name
   * (dblclick, contextmenu).
   * @default 'click'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-clickEvent Original Ext JS documentation of 'clickEvent'
   */
  public native function get clickEvent():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clickEvent(value:String):void;

  [ArrayElementType("String")]
  /**
   * An array of 6-digit color hex code strings (without the # symbol). This array can contain
   * any number of colors, and each hex code should be unique. The width of the picker
   * is controlled via CSS by adjusting the width property of the 'x-color-picker' class
   * (or assigning a custom class), so you can balance the number of colors with the width setting
   * until the box is symmetrical.
   * <p>You can override individual colors if needed:</p>
   * <pre>
   * var cp = new Ext.picker.Color();
   * cp.colors[0] = 'FF0000';  // change the first box to red
   * </pre>
   * <p>Or you can provide a custom array of your own for complete control:</p>
   * <pre>
   * var cp = new Ext.picker.Color();
   * cp.colors = ['000000', '993300', '333300'];
   * </pre>
   * @default [
   *     '000000',
   *     '993300',
   *     '333300',
   *     '003300',
   *     '003366',
   *     '000080',
   *     '333399',
   *     '333333',
   *     '800000',
   *     'FF6600',
   *     '808000',
   *     '008000',
   *     '008080',
   *     '0000FF',
   *     '666699',
   *     '808080',
   *     'FF0000',
   *     'FF9900',
   *     '99CC00',
   *     '339966',
   *     '33CCCC',
   *     '3366FF',
   *     '800080',
   *     '969696',
   *     'FF00FF',
   *     'FFCC00',
   *     'FFFF00',
   *     '00FF00',
   *     '00FFFF',
   *     '00CCFF',
   *     '993366',
   *     'C0C0C0',
   *     'FF99CC',
   *     'FFCC99',
   *     'FFFF99',
   *     'CCFFCC',
   *     'CCFFFF',
   *     '99CCFF',
   *     'CC99FF',
   *     'FFFFFF'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#property-colors Original Ext JS documentation of 'colors'
   */
  public native function get colors():Array;

  /**
   * @private
   */
  public native function set colors(value:Array):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the containing element.
   * @default 'x-color-picker'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-componentCls Original Ext JS documentation of 'componentCls'
   */
  override public native function get componentCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set componentCls(value:String):void;

  [ExtConfig]
  /**
   * A function that will handle the select event of this picker. The handler is passed
   * the following parameters:
   * <ul>
   * <li>
   * <p><code>picker</code>: ColorPicker</p>
   * <p>The <i>picker</i> (→<code>ext.picker.ColorPicker</code>).</p>
   * </li>
   * <li>
   * <p><code>color</code>: String</p>
   * <p>The 6-digit color hex code (without the # symbol).</p>
   * </li>
   * </ul>
   * @see ext.picker.ColorPicker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the color picker's items
   * @default Ext.baseCSSPrefix + 'color-picker-item'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemCls(value:String):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> reference) in which the <code>→handler</code> function will be called.
   * <p>Defaults to this Color picker instance.</p>
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the selected element
   * @default 'x-color-picker-selected'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-selectedCls Original Ext JS documentation of 'selectedCls'
   */
  public native function get selectedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectedCls(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The initial color to highlight (should be a valid 6-digit color hex code
   * without the # symbol). Note that the hex codes are case-sensitive.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   */
  public native function get value():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set value(value:String):void;

  /**
   * Clears any selection and sets the value to <code>null</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Get the currently selected color value.
   * @return value The selected value. Null if nothing is selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():String;

  /**
   * Selects the specified color in the picker (fires the →<code>event:onSelect</code> event)
   * @param color A valid 6-digit color hex code (# will be stripped if included)
   * @param suppressEvent True to stop the select event from firing.
   * @default false
   * @see #event:onSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Color.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(color:String, suppressEvent:Boolean = false):void;
}
}