package ext.picker {
import ext.Component;

[Native("Ext.picker.Date", require)]
/**
 * @see ext.picker.events.DatePicker_dateEvent.SELECT
 * @eventType ext.picker.events.DatePicker_dateEvent.SELECT
 */
[Event(name='onSelect', type='ext.picker.events.DatePicker_dateEvent')]
/**
 * A date picker. This class is used by the Ext.form.field.Date field to allow browsing
 * and selection of valid dates in a popup next to the field, but may also be used
 * with other components.
 * <p>Typically you will need to implement a handler function to be notified when the user chooses
 * a date from the picker; you can register the handler using the →<code>event:onSelect</code> event,
 * or by implementing the →<code>handler</code> method.</p>
 * <p>By default the user will be allowed to pick any date; this can be changed by using the
 * →<code>minDate</code>, →<code>maxDate</code>, →<code>disabledDays</code>, →<code>disabledDatesRE</code>,
 * and/or →<code>disabledDates</code> configs.</p>
 * <p>All the string values documented below may be overridden by including an Ext locale file
 * in your page.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Choose a future date:',
 *     width: 330,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     items: [{
 *         xtype: 'datepicker',
 *         minDate: new Date(),
 *         handler: function(picker, date) {
 *             // do something with the selected date
 *         }
 *     }]
 * });
 * </pre>
 * @see #event:onSelect
 * @see #handler
 * @see #minDate
 * @see #maxDate
 * @see #disabledDays
 * @see #disabledDatesRE
 * @see #disabledDates
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html Original Ext JS documentation of 'Ext.picker.Date'
 */
public class DatePicker extends Component {
  /**
   * @param config @inheritDoc
   */
  public function DatePicker(config:DatePicker = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>→alignTo()</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default false
   * @see ext.Component#alignTo()
   * @see #alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  override public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date falls on a disabled date.
   * @default "This date is disabled"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaDisabledDatesText Original Ext JS documentation of 'ariaDisabledDatesText'
   */
  public native function get ariaDisabledDatesText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDisabledDatesText(value:String):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date falls on a disabled day of week.
   * @default "This day of week is disabled"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaDisabledDaysText Original Ext JS documentation of 'ariaDisabledDaysText'
   */
  public native function get ariaDisabledDaysText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDisabledDaysText(value:String):void;

  [ExtConfig]
  /**
   * The text that will be announced by Assistive Technologies such as screen readers
   * when user is navigating to the cell which date is later than
   * →<code>maxDate</code>.
   * @default "This date is after the maximum date"
   * @see #maxDate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaMaxText Original Ext JS documentation of 'ariaMaxText'
   */
  public native function get ariaMaxText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaMaxText(value:String):void;

  [ExtConfig]
  /**
   * The text that will be announced by Assistive Technologies such as screen readers
   * when user is navigating to the cell which date is less than
   * →<code>minDate</code>.
   * @default "This date is before the minimum date"
   * @see #minDate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaMinText Original Ext JS documentation of 'ariaMinText'
   */
  public native function get ariaMinText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaMinText(value:String):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'region'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * The text to display for the aria title.
   * @default 'Date Picker: {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaTitle Original Ext JS documentation of 'ariaTitle'
   */
  public native function get ariaTitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaTitle(value:String):void;

  [ExtConfig]
  /**
   * The date format to display for the current value in the →<code>ariaTitle</code>.
   * @default 'F d'
   * @see #ariaTitle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-ariaTitleDateFormat Original Ext JS documentation of 'ariaTitleDateFormat'
   */
  public native function get ariaTitleDateFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaTitleDateFormat(value:String):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'datepicker'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * Specifies the border size for this component. The border can be a single numeric value
   * to apply to all sides or it can be a CSS style specification for each style,
   * for example: '10 5 3 10' (top, right, bottom, left).
   * <p>For components that have no border by default, setting this won't make the border appear
   * by itself. You also need to specify border color and style:</p>
   * <pre>
   * border: 5,
   * style: {
   *     borderColor: 'red',
   *     borderStyle: 'solid'
   * }
   * </pre>
   * <p>To turn off the border, use <code>border: false</code>.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-border Original Ext JS documentation of 'border'
   * @see #setBorder()
   */
  override public native function get border():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set border(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>→event:onSelect</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>→event:onSelect</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>→event:onSelect</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>→event:onSelect</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'innerEl',
   *     'eventEl',
   *     'prevEl',
   *     'nextEl',
   *     'middleBtnEl',
   *     'footerEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see #event:onSelect
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ArrayElementType("String")]
  [Deprecated(replacement="ext.SDateUtil", since="6.5.0")]
  [ExtConfig]
  /**
   * An array of textual day names which can be overriden for localization support
   * (defaults to Ext.Date.dayNames)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-dayNames Original Ext JS documentation of 'dayNames'
   */
  public native function get dayNames():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dayNames(value:Array):void;

  [ExtConfig]
  /**
   * A default date for this picker, only used when a value is not set. (JavaScript date object)
   * Note: This value with be constrained to the minDate/maxDate if they are specified.
   * @default new Date()
   * @since 6.5.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-defaultValue Original Ext JS documentation of 'defaultValue'
   */
  public native function get defaultValue():Date;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultValue(value:Date):void;

  [ExtConfig]
  /**
   * True to disable animations when showing the month picker.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disableAnim Original Ext JS documentation of 'disableAnim'
   */
  public native function get disableAnim():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disableAnim(value:Boolean):void;

  [ExtConfig]
  /**
   * The class to apply to disabled cells.
   * @default 'x-datepicker-disabled'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledCellCls Original Ext JS documentation of 'disabledCellCls'
   */
  public native function get disabledCellCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledCellCls(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of 'dates' to disable, as strings. These strings will be used to build
   * a dynamic regular expression so they are very powerful. Some examples:
   * <ul>
   * <li>['03/08/2003', '09/16/2003'] would disable those exact dates</li>
   * <li>['03/08', '09/16'] would disable those days for every year</li>
   * <li>['^03/08'] would only match the beginning (useful if you are using short years)</li>
   * <li>['03/../2006'] would disable every day in March 2006</li>
   * <li>['^03'] would disable every day in every March</li>
   * </ul>
   * <p>Note that the format of the dates included in the array should exactly match the
   * →<code>format</code> config. In order to support regular expressions, if you are using
   * a date format that has '.' in it, you will have to escape the dot when restricting dates.
   * For example: ['03\.08\.03'].</p>
   * @see #format
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledDates Original Ext JS documentation of 'disabledDates'
   * @see #setDisabledDates()
   */
  public native function get disabledDates():Array;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabledDates(value:Array):void;

  [ExtConfig]
  /**
   * JavaScript regular expression used to disable a pattern of dates. The →<code>disabledDates</code>
   * config will generate this regex internally, but if you specify disabledDatesRE it will take
   * precedence over the disabledDates value.
   * @see #disabledDates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledDatesRE Original Ext JS documentation of 'disabledDatesRE'
   */
  public native function get disabledDatesRE():RegExp;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledDatesRE(value:RegExp):void;

  [ExtConfig]
  /**
   * The tooltip text to display when the date falls on a disabled date.
   * @default 'Disabled'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledDatesText Original Ext JS documentation of 'disabledDatesText'
   */
  public native function get disabledDatesText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledDatesText(value:String):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * An array of days to disable, 0-based. For example, [0, 6] disables Sunday and Saturday.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledDays Original Ext JS documentation of 'disabledDays'
   * @see #setDisabledDays()
   */
  public native function get disabledDays():Array;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabledDays(value:Array):void;

  [ExtConfig]
  /**
   * The tooltip to display when the date falls on a disabled day.
   * @default 'Disabled'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-disabledDaysText Original Ext JS documentation of 'disabledDaysText'
   */
  public native function get disabledDaysText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledDaysText(value:String):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.button.Button.ui</code> to use for the date picker's footer buttons.
   * @default 'default'
   * @see ext.button.Button#ui
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-footerButtonUI Original Ext JS documentation of 'footerButtonUI'
   */
  public native function get footerButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set footerButtonUI(value:String):void;

  [ExtConfig]
  /**
   * The default date format string which can be overriden for localization support.
   * The format must be valid according to →<code>ext.DateUtil.parse()</code> (defaults to
   * →<code>ext.DateUtil.defaultFormat</code>).
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * Optional. A function that will handle the select event of this picker. The handler
   * is passed the following parameters:
   * <ul>
   * <li><code>picker</code>: Ext.picker.Date</li>
   * </ul>
   * <p>This Date picker.</p>
   * <ul>
   * <li><code>date</code>: Date</li>
   * </ul>
   * <p>The selected date.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:Function):void;

  [ExtConfig]
  /**
   * Specifies optional custom key event handlers for the →<code>ext.util.KeyNav</code> attached to
   * this date picker. Must conform to the config format recognized by the →<code>ext.util.KeyNav</code>
   * constructor. Handlers specified in this object will replace default handlers
   * of the same name.
   * @see ext.util.KeyNav
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-keyNavConfig Original Ext JS documentation of 'keyNavConfig'
   */
  public native function get keyNavConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyNavConfig(value:Object):void;

  [ExtConfig]
  /**
   * The format for displaying a date in a longer format.
   * @default 'F d, Y'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-longDayFormat Original Ext JS documentation of 'longDayFormat'
   */
  public native function get longDayFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set longDayFormat(value:String):void;

  [ExtConfig]
  /**
   * Maximum allowable date (JavaScript date object)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-maxDate Original Ext JS documentation of 'maxDate'
   * @see #setMaxDate()
   */
  public native function get maxDate():Date;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set maxDate(value:Date):void;

  [ExtConfig]
  /**
   * The error text to display if the maxDate validation fails.
   * @default 'This date is after the maximum date'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-maxText Original Ext JS documentation of 'maxText'
   */
  public native function get maxText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxText(value:String):void;

  [ExtConfig]
  /**
   * Minimum allowable date (JavaScript date object)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-minDate Original Ext JS documentation of 'minDate'
   * @see #setMinDate()
   */
  public native function get minDate():Date;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set minDate(value:Date):void;

  [ExtConfig]
  /**
   * The error text to display if the minDate validation fails.
   * @default 'This date is before the minimum date'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-minText Original Ext JS documentation of 'minText'
   */
  public native function get minText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minText(value:String):void;

  [ArrayElementType("String")]
  [Deprecated(replacement="ext.SDateUtil", since="6.5.0")]
  [ExtConfig]
  /**
   * An array of textual month names which can be overriden for localization support
   * (defaults to Ext.Date.monthNames)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-monthNames Original Ext JS documentation of 'monthNames'
   */
  public native function get monthNames():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set monthNames(value:Array):void;

  [ExtConfig]
  /**
   * The date format for the header month.
   * @default 'F Y'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-monthYearFormat Original Ext JS documentation of 'monthYearFormat'
   */
  public native function get monthYearFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set monthYearFormat(value:String):void;

  [ExtConfig]
  /**
   * The header month selector tooltip.
   * @default 'Choose a month (Control+Up/Down to move years)'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-monthYearText Original Ext JS documentation of 'monthYearText'
   */
  public native function get monthYearText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set monthYearText(value:String):void;

  [ExtConfig]
  /**
   * The next month navigation button tooltip.
   * @default 'Next Month (Control+Right)'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-nextText Original Ext JS documentation of 'nextText'
   */
  public native function get nextText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nextText(value:String):void;

  [ExtConfig]
  /**
   * The previous month navigation button tooltip.
   * @default 'Previous Month (Control+Left)'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-prevText Original Ext JS documentation of 'prevText'
   */
  public native function get prevText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prevText(value:String):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default [
   *     '<div id="{id}-innerEl" data-ref="innerEl" role="presentation">',
   *     '<div class="{baseCls}-header">',
   *     '<div id="{id}-prevEl" data-ref="prevEl" class="{baseCls}-prev {baseCls}-arrow" role="presentation" title="{prevText}"></div>',
   *     '<div id="{id}-middleBtnEl" data-ref="middleBtnEl" class="{baseCls}-month" role="heading">{%this.renderMonthBtn(values, out)%}</div>',
   *     '<div id="{id}-nextEl" data-ref="nextEl" class="{baseCls}-next {baseCls}-arrow" role="presentation" title="{nextText}"></div>',
   *     '</div>',
   *     '<table role="grid" id="{id}-eventEl" data-ref="eventEl" class="{baseCls}-inner" cellspacing="0" tabindex="0" aria-readonly="true">',
   *     '<thead>',
   *     '<tr role="row">',
   *     '<tpl for="dayNames">',
   *     '<th role="columnheader" class="{parent.baseCls}-column-header" aria-label="{.}">',
   *     '<div role="presentation" class="{parent.baseCls}-column-header-inner">{.:this.firstInitial}</div>',
   *     '</th>',
   *     '</tpl>',
   *     '</tr>',
   *     '</thead>',
   *     '<tbody>',
   *     '<tr role="row">',
   *     '<tpl for="days">',
   *     '{#:this.isEndOfWeek}',
   *     '<td role="gridcell">',
   *     '<div hidefocus="on" class="{parent.baseCls}-date"></div>',
   *     '</td>',
   *     '</tpl>',
   *     '</tr>',
   *     '</tbody>',
   *     '</table>',
   *     '<tpl if="showToday">',
   *     '<div id="{id}-footerEl" data-ref="footerEl" role="presentation" class="{baseCls}-footer">{%this.renderTodayBtn(values, out)%}</div>',
   *     '</tpl>',
   *     // These elements are used with Assistive Technologies such as screen readers
   *     '<div id="{id}-todayText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{todayText}.</div>',
   *     '<div id="{id}-ariaMinText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaMinText}.</div>',
   *     '<div id="{id}-ariaMaxText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaMaxText}.</div>',
   *     '<div id="{id}-ariaDisabledDaysText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaDisabledDaysText}.</div>',
   *     '<div id="{id}-ariaDisabledDatesText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaDisabledDatesText}.</div>',
   *     '</div>',
   *     {
   *         firstInitial: function(value) {
   *             return Ext.picker.Date.prototype.getDayInitial(value);
   *         },
   *         isEndOfWeek: function(value) {
   *             // convert from 1 based index to 0 based
   *             // by decrementing value once.
   *             value--;
   *             // eslint-disable-next-line vars-on-top
   *             var end = value % 7 === 0 && value !== 0;
   *             return end ? '</tr><tr role="row">' : '';
   *         },
   *         renderTodayBtn: function(values, out) {
   *             Ext.DomHelper.generateMarkup(values.$comp.todayBtn.getRenderTree(), out);
   *         },
   *         renderMonthBtn: function(values, out) {
   *             Ext.DomHelper.generateMarkup(values.$comp.monthBtn.getRenderTree(), out);
   *         }
   *     }
   * ]
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> reference) in which the <code>→handler</code> function will be called.
   * <p>Defaults to this DatePicker instance.</p>
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * The class to apply to the selected cell.
   * @default 'x-datepicker-selected'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-selectedCls Original Ext JS documentation of 'selectedCls'
   */
  public native function get selectedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectedCls(value:String):void;

  [ExtConfig]
  /**
   * False to hide the footer area containing the Today button and disable the keyboard handler
   * for spacebar that selects the current date.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-showToday Original Ext JS documentation of 'showToday'
   */
  public native function get showToday():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showToday(value:Boolean):void;

  [ExtConfig]
  /**
   * Day index at which the week should begin, 0-based.
   * <p>Defaults to the value of →<code>null</code>.</p>
   * @default undefined
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-startDay Original Ext JS documentation of 'startDay'
   */
  public native function get startDay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startDay(value:Number):void;

  [ExtConfig]
  /**
   * The text to display on the button that selects the current date.
   * @default 'Today'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-todayText Original Ext JS documentation of 'todayText'
   */
  public native function get todayText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set todayText(value:String):void;

  [ExtConfig]
  /**
   * A string used to format the message for displaying in a tooltip over the button
   * that selects the current date. The <code>{0}</code> token in string is replaced by today's date.
   * @default '{0} (Spacebar)'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#cfg-todayTip Original Ext JS documentation of 'todayTip'
   */
  public native function get todayTip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set todayTip(value:String):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Gets a single character to represent the day of the week
   * @return The character
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-getDayInitial Original Ext JS documentation of 'getDayInitial'
   */
  public native function getDayInitial(value:*):String;

  /**
   * Gets the current selected value of the date field
   * @return The selected date
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():Date;

  /**
   * Hides the month picker, if it's visible.
   * @param animate Indicates whether to animate this action. If the animate
   * parameter is not specified, the behavior will use →<code>disableAnim</code> to determine
   * whether to animate or not.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-hideMonthPicker Original Ext JS documentation of 'hideMonthPicker'
   * @see #disableAnim
   */
  public native function hideMonthPicker(animate:Boolean = false):DatePicker;

  /**
   * Sets the current value to today.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-selectToday Original Ext JS documentation of 'selectToday'
   */
  public native function selectToday():DatePicker;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Replaces any existing disabled dates with new values and refreshes the DatePicker.
   * @param dd An array of date strings (see the →<code>disabledDates</code> config
   * for details on supported values), or a JavaScript regular expression used to disable
   * a pattern of dates.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-setDisabledDates Original Ext JS documentation of 'setDisabledDates'
   * @see #disabledDates
   */
  public native function setDisabledDates(dd:*):void;

  /**
   * Replaces any existing disabled days (by index, 0-6) with new values and refreshes
   * the DatePicker.
   * @param disabledDays An array of disabled day indexes.
   * See the →<code>disabledDays</code> config for details on supported values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-setDisabledDays Original Ext JS documentation of 'setDisabledDays'
   * @see #disabledDays
   */
  public native function setDisabledDays(disabledDays:Array):void;

  /**
   * Replaces any existing →<code>maxDate</code> with the new value and refreshes the DatePicker.
   * @param maxDate The maximum date that can be selected
   * @see #maxDate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-setMaxDate Original Ext JS documentation of 'setMaxDate'
   */
  public native function setMaxDate(maxDate:Date):void;

  /**
   * Replaces any existing →<code>minDate</code> with the new value and refreshes the DatePicker.
   * @param minDate The minimum date that can be selected
   * @see #minDate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-setMinDate Original Ext JS documentation of 'setMinDate'
   */
  public native function setMinDate(minDate:Date):void;

  /**
   * Sets the value of the date field
   * @param value The date to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  public native function setValue(value:Date):void;

  /**
   * Show the month picker
   * @param animate Indicates whether to animate this action. If the animate
   * parameter is not specified, the behavior will use →<code>disableAnim</code> to determine
   * whether to animate or not.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-showMonthPicker Original Ext JS documentation of 'showMonthPicker'
   * @see #disableAnim
   */
  public native function showMonthPicker(animate:Boolean = false):DatePicker;

  /**
   * Show the next month.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-showNextMonth Original Ext JS documentation of 'showNextMonth'
   */
  public native function showNextMonth(e:Object):DatePicker;

  /**
   * Show the next year.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-showNextYear Original Ext JS documentation of 'showNextYear'
   */
  public native function showNextYear():DatePicker;

  /**
   * Show the previous month.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-showPrevMonth Original Ext JS documentation of 'showPrevMonth'
   */
  public native function showPrevMonth(e:Object):DatePicker;

  /**
   * Show the previous year.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Date.html#method-showPrevYear Original Ext JS documentation of 'showPrevYear'
   */
  public native function showPrevYear():DatePicker;
}
}