package ext.picker {
import ext.Component;

[Native("Ext.picker.Month", require)]
/**
 * @see ext.picker.events.MonthPickerEvent.CANCEL_CLICK
 * @eventType ext.picker.events.MonthPickerEvent.CANCEL_CLICK
 */
[Event(name='onCancelClick', type='ext.picker.events.MonthPickerEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.MONTH_CLICK
 * @eventType ext.picker.events.MonthPicker_valueEvent.MONTH_CLICK
 */
[Event(name='onMonthClick', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.MONTH_DBLCLICK
 * @eventType ext.picker.events.MonthPicker_valueEvent.MONTH_DBLCLICK
 */
[Event(name='onMonthDblclick', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.OK_CLICK
 * @eventType ext.picker.events.MonthPicker_valueEvent.OK_CLICK
 */
[Event(name='onOkClick', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.SELECT
 * @eventType ext.picker.events.MonthPicker_valueEvent.SELECT
 */
[Event(name='onSelect', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.YEAR_CLICK
 * @eventType ext.picker.events.MonthPicker_valueEvent.YEAR_CLICK
 */
[Event(name='onYearClick', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * @see ext.picker.events.MonthPicker_valueEvent.YEAR_DBLCLICK
 * @eventType ext.picker.events.MonthPicker_valueEvent.YEAR_DBLCLICK
 */
[Event(name='onYearDblclick', type='ext.picker.events.MonthPicker_valueEvent')]
/**
 * A month / year picker component. This class is used by the
 * <i>Date picker</i> (→<code>ext.picker.DatePicker</code>) to allow browsing and selection of year and
 * months combinations, but may also be used as a standalone component.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'monthpicker',
 *     renderTo: document.body,
 *     value: new Date(),
 *     onSelect: function() {
 *         Ext.Msg.alert('Selected', this.getValue());
 *     },
 *     listeners: {
 *         okclick: 'onSelect',
 *         monthdblclick: 'onSelect',
 *         yeardblclick: 'onSelect',
 *         cancelclick: function () {
 *             this.setValue(new Date());
 *         }
 *     }
 * });
 * </pre>
 * @see ext.picker.DatePicker
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html Original Ext JS documentation of 'Ext.picker.Month'
 */
public class MonthPicker extends Component {
  /**
   * @param config @inheritDoc
   */
  public function MonthPicker(config:MonthPicker = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>→alignTo()</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default false
   * @see ext.Component#alignTo()
   * @see #alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  override public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to the picker element.
   * @default Ext.baseCSSPrefix + 'monthpicker'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * The text to display on the Cancel button.
   * @default 'Cancel'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-cancelText Original Ext JS documentation of 'cancelText'
   */
  public native function get cancelText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cancelText(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>→event:onSelect</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>→event:onSelect</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>→event:onSelect</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>→event:onSelect</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'bodyEl',
   *     'prevEl',
   *     'nextEl',
   *     'monthEl',
   *     'yearEl',
   *     'buttons'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see #event:onSelect
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.button.Button.ui</code> to use for the month picker's footer buttons.
   * @default 'default'
   * @see ext.button.Button#ui
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-footerButtonUI Original Ext JS documentation of 'footerButtonUI'
   */
  public native function get footerButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set footerButtonUI(value:String):void;

  [ExtConfig]
  /**
   * The text to display on the OK button.
   * @default 'OK'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-okText Original Ext JS documentation of 'okText'
   */
  public native function get okText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set okText(value:String):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default [
   *     '<div id="{id}-bodyEl" data-ref="bodyEl" class="{baseCls}-body">',
   *     '<div id="{id}-monthEl" data-ref="monthEl" class="{baseCls}-months">',
   *     '<tpl for="months">',
   *     '<div class="{parent.baseCls}-item {parent.baseCls}-month">',
   *     '<a style="{parent.monthStyle}" role="button" hidefocus="on" class="{parent.baseCls}-item-inner">{.}</a>',
   *     '</div>',
   *     '</tpl>',
   *     '</div>',
   *     '<div id="{id}-yearEl" data-ref="yearEl" class="{baseCls}-years">',
   *     '<div class="{baseCls}-yearnav">',
   *     '<div class="{baseCls}-yearnav-button-ct">',
   *     '<a id="{id}-prevEl" data-ref="prevEl" class="{baseCls}-yearnav-button {baseCls}-yearnav-prev" hidefocus="on" role="button"></a>',
   *     '</div>',
   *     '<div class="{baseCls}-yearnav-button-ct">',
   *     '<a id="{id}-nextEl" data-ref="nextEl" class="{baseCls}-yearnav-button {baseCls}-yearnav-next" hidefocus="on" role="button"></a>',
   *     '</div>',
   *     '</div>',
   *     '<tpl for="years">',
   *     '<div class="{parent.baseCls}-item {parent.baseCls}-year">',
   *     '<a hidefocus="on" class="{parent.baseCls}-item-inner" role="button">{.}</a>',
   *     '</div>',
   *     '</tpl>',
   *     '</div>',
   *     '<div class="' + Ext.baseCSSPrefix + 'clear"></div>',
   *     '<tpl if="showButtons">',
   *     '<div id="{id}-buttons" data-ref="buttons" class="{baseCls}-buttons">{%',
   *     'var me=values.$comp, okBtn=me.okBtn, cancelBtn=me.cancelBtn;',
   *     'okBtn.ownerLayout = cancelBtn.ownerLayout = me.componentLayout;',
   *     'okBtn.ownerCt = cancelBtn.ownerCt = me;',
   *     'Ext.DomHelper.generateMarkup(okBtn.getRenderTree(), out);',
   *     'Ext.DomHelper.generateMarkup(cancelBtn.getRenderTree(), out);',
   *     '%}</div>',
   *     '</tpl>',
   *     '</div>'
   * ]
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  /**
   * The class to be added to selected items in the picker.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#property-selectedCls Original Ext JS documentation of 'selectedCls'
   */
  public native function get selectedCls():String;

  [ExtConfig]
  /**
   * True to show ok and cancel buttons below the picker.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-showButtons Original Ext JS documentation of 'showButtons'
   */
  public native function get showButtons():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showButtons(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The default value to set. See →<code>setValue()</code>
   * @see #setValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   */
  public native function get value():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:*):void;

  /**
   * Modify the year display by passing an offset.
   * @param offset The offset to move by.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#method-adjustYear Original Ext JS documentation of 'adjustYear'
   */
  public native function adjustYear(offset:Number = 10):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  [ArrayElementType("Number")]
  /**
   * Gets the selected value. It is returned as an array [month, year]. It may
   * be a partial value, for example [null, 2010]. The month is returned as
   * 0 based.
   * @return The selected value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():Array;

  /**
   * Checks whether the picker has a selection
   * @return Returns true if both a month and year have been selected
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#method-hasSelection Original Ext JS documentation of 'hasSelection'
   */
  public native function hasSelection():Boolean;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Set the value for the picker.
   * @param value The value to set. It can be a Date object,
   * where the month/year will be extracted, or it can be an array, with the month
   * as the first index and the year as the second.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  public native function setValue(value:*):MonthPicker;
}
}