package ext.picker {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.view.BoundListView;

[Native("Ext.picker.Time", require)]
/**
 * A time picker which provides a list of times from which to choose. This is used
 * by the →<code>ext.form.field.TimeField</code> class to allow browsing and selection of valid times,
 * but could also be used with other components.
 * <p>By default, all times starting at midnight and incrementing every 15 minutes will be presented.
 * This list of available times can be controlled using the →<code>minValue</code>, →<code>maxValue</code>,
 * and →<code>increment</code> configuration properties. The format of the times presented in the list
 * can be customized with the →<code>format</code> config.</p>
 * <p>To handle when the user selects a time from the list, you can subscribe to the
 * →<code>event:onSelectionChange</code> event.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.picker.Time', {
 *    width: 60,
 *    minValue: Ext.Date.parse('04:30:00 AM', 'h:i:s A'),
 *    maxValue: Ext.Date.parse('08:00:00 AM', 'h:i:s A'),
 *    renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.form.field.TimeField
 * @see #minValue
 * @see #maxValue
 * @see #increment
 * @see #format
 * @see #event:onSelectionChange
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html Original Ext JS documentation of 'Ext.picker.Time'
 */
public class TimePicker extends BoundListView {
  /**
   * @param config @inheritDoc
   */
  public function TimePicker(config:TimePicker = null) {
    super();
  }

  [ExtConfig]
  /**
   * The default time format string which can be overriden for localization support. The format
   * must be valid according to →<code>ext.DateUtil.parse()</code>.
   * <p>Defaults to <code>'g:i A'</code>, e.g., <code>'3:15 PM'</code>. For 24-hour time format try <code>'H:i'</code> instead.</p>
   * @default undefined
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * The number of minutes between each time value in the list.
   * @default 15
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#cfg-increment Original Ext JS documentation of 'increment'
   */
  public native function get increment():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set increment(value:Number):void;

  [ExtConfig]
  /**
   * The maximum time to be shown in the list of times. This must be a Date object
   * (only the time fields will be used); no parsing of String values will be done.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#cfg-maxValue Original Ext JS documentation of 'maxValue'
   * @see #setMaxValue()
   */
  public native function get maxValue():Date;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set maxValue(value:Date):void;

  [ExtConfig]
  /**
   * The minimum time to be shown in the list of times. This must be a Date object
   * (only the time fields will be used); no parsing of String values will be done.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#cfg-minValue Original Ext JS documentation of 'minValue'
   * @see #setMinValue()
   */
  public native function get minValue():Date;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set minValue(value:Date):void;

  [ExtConfig]
  /**
   * This class creates its own store based upon time range and increment configuration.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#cfg-store Original Ext JS documentation of 'store'
   * @see #setStore()
   */
  override public native function get store():Store;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set store(value:Store):void;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  override public native function getStore():AbstractStore;

  /**
   * Set the →<code>maxValue</code> and update the list of available times. This must be a Date object
   * (only the time fields will be used); no parsing of String values will be done.
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#method-setMaxValue Original Ext JS documentation of 'setMaxValue'
   */
  public native function setMaxValue(value:Date):void;

  /**
   * Set the →<code>minValue</code> and update the list of available times. This must be a Date object
   * (only the time fields will be used); no parsing of String values will be done.
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#method-setMinValue Original Ext JS documentation of 'setMinValue'
   */
  public native function setMinValue(value:Date):void;

  /**
   * Sets the value of <code>store</code>.
   * @see #store
   */
  override public native function setStore(store:Object):void;

  /**
   * Update the list of available times in the list to be constrained within the →<code>minValue</code>
   * and →<code>maxValue</code>.
   * @see #minValue
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Time.html#method-updateList Original Ext JS documentation of 'updateList'
   */
  public native function updateList():void;
}
}