package ext.picker.events {
import ext.picker.MonthPicker;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.picker.events.MonthPicker_valueEvent")]
public class MonthPicker_valueEvent extends FlExtEvent {
  /**
   * Fires when a month is clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-monthclick Original Ext JS documentation of 'monthclick'
   * @see ext.picker.MonthPicker
   * @eventType onMonthClick
   */
  public static const MONTH_CLICK:String = "onMonthClick";
  /**
   * Fires when a month is clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-monthdblclick Original Ext JS documentation of 'monthdblclick'
   * @see ext.picker.MonthPicker
   * @eventType onMonthDblclick
   */
  public static const MONTH_DBLCLICK:String = "onMonthDblclick";
  /**
   * Fires when the ok button is pressed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-okclick Original Ext JS documentation of 'okclick'
   * @see ext.picker.MonthPicker
   * @eventType onOkClick
   */
  public static const OK_CLICK:String = "onOkClick";
  /**
   * Fires when a month/year is selected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-select Original Ext JS documentation of 'select'
   * @see ext.picker.MonthPicker
   * @eventType onSelect
   */
  public static const SELECT:String = "onSelect";
  /**
   * Fires when a year is clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-yearclick Original Ext JS documentation of 'yearclick'
   * @see ext.picker.MonthPicker
   * @eventType onYearClick
   */
  public static const YEAR_CLICK:String = "onYearClick";
  /**
   * Fires when a year is clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.picker.Month.html#event-yeardblclick Original Ext JS documentation of 'yeardblclick'
   * @see ext.picker.MonthPicker
   * @eventType onYearDblclick
   */
  public static const YEAR_DBLCLICK:String = "onYearDblclick";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "value", "eOpts"];

  public function MonthPicker_valueEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():MonthPicker;

  /**
   * The current value
   */
  public native function get value():Array;
}
}