package ext.plugin {

[Native("Ext.plugin.LazyItems", require)]
/**
 * This plugin defers the execution cost of the instantiation and initialization of child components
 * of un-rendered items.
 * <p>For example, in a →<code>ext.tab.TabPanel.deferredRender</code>
 * →<code>ext.tab.TabPanel</code>, the un-rendered tabs do not have to incur the cost
 * of instantiating and initializing their descendant components until render.</p>
 * <p>This plugin allows that.</p>
 * <p>Add the items to the plugin:</p>
 * <pre>
 * {
 *     xtype: 'tabpanel',
 *     items: [{
 *         title: 'Tab One',
 *         plugins: {
 *             lazyitems: {
 *                 items: [... tab child items...]
 *             }
 *         }
 *     }, {
 *         title: 'Tab One',
 *         plugins: {
 *             lazyitems: {
 *                 items: [... tab child items...]
 *             }
 *         }
 *     }]
 * }
 * </pre>
 * @see ext.tab.TabPanel#deferredRender
 * @see ext.tab.TabPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.LazyItems.html Original Ext JS documentation of 'Ext.plugin.LazyItems'
 */
public class LazyItemsPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function LazyItemsPlugin(config:LazyItemsPlugin = null) {
    super();
  }
}
}