package ext.plugin {

[Native("Ext.plugin.MouseEnter", require)]
/**
 * This plugin calls a callback whenever the mouse enters or leaves descendant
 * elements of its host component identified by a →<code>ext.plugin.MouseEnterPlugin.delegate</code>
 * query selector string.
 * <p>This is useful for components which render arbitrary and transient child elements
 * such as DataViews and Charts. It allows notification of mousenter events from
 * child nodes without having to add listeners to each child element.</p>
 * @see ext.plugin.MouseEnterPlugin#delegate
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html Original Ext JS documentation of 'Ext.plugin.MouseEnter'
 */
public class MouseEnterPlugin extends AbstractPlugin {
  /**
   * @inheritDoc
   */
  public function MouseEnterPlugin(config:AbstractPlugin = null) {
    super();
  }

  [ExtConfig]
  /**
   * The time in milliseconds to wait before processing the mouse event.
   * This can prevent unwanted processing when the user swipes the mouse rapidly across
   * the component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-delay Original Ext JS documentation of 'delay'
   */
  public native function get delay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delay(value:Number):void;

  [ExtConfig]
  /**
   * A query selector string to identify descendant elements
   * which trigger a call to the handler.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-delegate Original Ext JS documentation of 'delegate'
   */
  public native function get delegate():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delegate(value:String):void;

  [ExtConfig]
  /**
   * The element, or component element reference
   * name to which to add the mouse listener.
   * @default "el"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-element Original Ext JS documentation of 'element'
   */
  public native function get element():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set element(value:*):void;

  [ExtConfig]
  /**
   * A callback to invoke when a the mouse enters a
   * descendant delegate.
   * <ul>
   * <li><code>e:ext.event.Event</code> (optional) —
   * The <code>mouseover</code> event which triggered the mouse enter.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The delegate element into which the mouse just entered.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * A callback to invoke when a the mouse leaves a
   * descendant delegate.
   * <ul>
   * <li><code>e:ext.event.Event</code> (optional) —
   * The <code>mouseover</code> event which triggered the mouse leave.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The delegate element which the mouse just left.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-leaveHandler Original Ext JS documentation of 'leaveHandler'
   */
  public native function get leaveHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set leaveHandler(value:*):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> pointer) in which to execute the callback(s).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.MouseEnter.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;
}
}