package ext.plugin {

[Native("Ext.plugin.Viewport", require)]
/**
 * This plugin can be applied to any <code>Component</code> (although almost always to a <code>Container</code>)
 * to make it fill the browser viewport. This plugin is used internally by the more familiar
 * <code>→ext.container.Viewport</code> class.
 * <p>The <code>Viewport</code> container is commonly used but it can be an issue if you need to fill the
 * viewport with a container that derives from another class (e.g., <code>→ext.tab.TabPanel</code>). Prior
 * to this plugin, you would have to do this:</p>
 * <pre>
 *  Ext.create('Ext.container.Viewport', {
 *      layout: 'fit', // full the viewport with the tab panel
 *
 *      items: [{
 *          xtype: 'tabpanel',
 *          items: [{
 *              ...
 *          }]
 *      }]
 *  });
 * </pre>
 * <p>With this plugin you can create the <code>tabpanel</code> as the viewport:</p>
 * <pre>
 *  Ext.create('Ext.tab.Panel', {
 *      plugins: {
 *          viewport: true
 *      },
 *
 *      items: [{
 *          ...
 *      }]
 *  });
 * </pre>
 * <p>More importantly perhaps is that as a plugin, the view class can be reused in other
 * contexts such as the content of a <code>window (→ext.window.Window)</code>.</p>
 * <p>The Viewport renders itself to the document body, and automatically sizes itself to the size of
 * the browser viewport and manages window resizing. There may only be one Viewport created
 * in a page.</p>
 * <p><b><i>Responsive Design</i></b></p>
 * <p>This plugin enables →<code>ext.mixin.Responsive.responsiveConfig</code> for the components
 * by requiring <code>→ext.Responsive</code>.</p>
 * @see ext.container.Viewport
 * @see ext.tab.TabPanel
 * @see ext.window.Window
 * @see ext.mixin.Responsive#responsiveConfig
 * @see ext.Responsive
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.plugin.Viewport.html Original Ext JS documentation of 'Ext.plugin.Viewport'
 */
public class ViewportPlugin extends AbstractPlugin {
  /**
   * @param config @inheritDoc
   */
  public function ViewportPlugin(config:ViewportPlugin = null) {
    super();
  }
}
}