package ext.promise {
import ext.Base;
import ext.IPromise;

[Native("Ext.promise.Deferred", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Deferreds are the mechanism used to create new Promises. A Deferred has a single
 * associated Promise that can be safely returned to external consumers to ensure they do
 * not interfere with the resolution or rejection of the deferred operation.</p>
 * <p>A Deferred is typically used within the body of a function that performs an asynchronous
 * operation. When that operation succeeds, the Deferred should be resolved; if that
 * operation fails, the Deferred should be rejected.</p>
 * <p>Each Deferred has an associated Promise. A Promise delegates <code>→then()</code> calls to its
 * Deferred's <code>→then()</code> method. In this way, access to Deferred operations are divided between
 * producer (Deferred) and consumer (Promise) roles.</p>
 * <p>When a Deferred's <code>→resolve()</code> method is called, it fulfills with the optionally specified
 * value. If <code>→resolve()</code> is called with a then-able (i.e.a Function or Object with a <code>→then()</code>
 * function, such as another Promise) it assimilates the then-able's result; the Deferred
 * provides its own <code>→resolve()</code> and <code>→reject()</code> methods as the onFulfilled or onRejected
 * arguments in a call to that then-able's <code>→then()</code> function. If an error is thrown while
 * calling the then-able's <code>→then()</code> function (prior to any call back to the specified
 * <code>→resolve()</code> or <code>→reject()</code> methods), the Deferred rejects with that error. If a Deferred's
 * <code>→resolve()</code> method is called with its own Promise, it rejects with a TypeError.</p>
 * <p>When a Deferred's <code>→reject()</code> method is called, it rejects with the optionally specified
 * reason.</p>
 * <p>Each time a Deferred's <code>→then()</code> method is called, it captures a pair of optional
 * onFulfilled and onRejected callbacks and returns a Promise of the Deferred's future
 * value as transformed by those callbacks.</p>
 * @see #then()
 * @see #resolve()
 * @see #reject()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html Original Ext JS documentation of 'Ext.promise.Deferred'
 */
public class Deferred extends Base implements IPromise {
  /**
   * Promise of the future value of this Deferred.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html#property-promise Original Ext JS documentation of 'promise'
   */
  public native function get promise():IPromise;

  /**
   * @private
   */
  public native function set promise(value:IPromise):void;

  /**
   * Reject this Deferred with the specified reason.
   * <p>Once a Deferred has been rejected, it is considered to be complete
   * and subsequent calls to <code>→resolve()</code> or <code>→reject()</code> are ignored.</p>
   * @param reason Rejection reason.
   * @see #resolve()
   * @see #reject()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html#method-reject Original Ext JS documentation of 'reject'
   */
  public native function reject(reason:Error):void;

  /**
   * Resolve this Deferred with the (optional) specified value.
   * <p>If called with a then-able (i.e.a Function or Object with a <code>→then()</code>
   * function, such as another Promise) it assimilates the then-able's
   * result; the Deferred provides its own <code>→resolve()</code> and <code>→reject()</code> methods
   * as the onFulfilled or onRejected arguments in a call to that
   * then-able's <code>→then()</code> function. If an error is thrown while calling
   * the then-able's <code>→then()</code> function (prior to any call back to the
   * specified <code>→resolve()</code> or <code>→reject()</code> methods), the Deferred rejects with
   * that error. If a Deferred's <code>→resolve()</code> method is called with its own
   * Promise, it rejects with a TypeError.</p>
   * <p>Once a Deferred has been fulfilled or rejected, it is considered to be complete
   * and subsequent calls to <code>→resolve()</code> or <code>→reject()</code> are ignored.</p>
   * @param value Value to resolve as either a fulfillment value or rejection
   * reason.
   * @see #then()
   * @see #resolve()
   * @see #reject()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html#method-resolve Original Ext JS documentation of 'resolve'
   */
  public native function resolve(value:*):void;

  /**
   * @inheritDoc
   */
  public native function then(onFulfilled:Function = null, onRejected:Function = null, onProgress:Function = null):IPromise;

  /**
   * Updates progress for this Deferred, if it is still pending, triggering it to
   * execute the <code>onProgress</code> callback and propagate the resulting transformed progress
   * value to Deferreds that originate from this Deferred.
   * @param progress The progress value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.promise.Deferred.html#method-update Original Ext JS documentation of 'update'
   */
  public native function update(progress:*):void;
}
}