package ext.resizer {
import ext.dd.DragTracker;
import ext.dom.Element;
import ext.mixin.Observable;

[Native("Ext.resizer.Resizer", require)]
/**
 * @see ext.resizer.events.Resizer_width_height_eEvent.BEFORE_RESIZE
 * @eventType ext.resizer.events.Resizer_width_height_eEvent.BEFORE_RESIZE
 */
[Event(name='onBeforeResize', type='ext.resizer.events.Resizer_width_height_eEvent')]
/**
 * @see ext.resizer.events.Resizer_width_height_eEvent.RESIZE
 * @eventType ext.resizer.events.Resizer_width_height_eEvent.RESIZE
 */
[Event(name='onResize', type='ext.resizer.events.Resizer_width_height_eEvent')]
/**
 * @see ext.resizer.events.Resizer_width_height_eEvent.RESIZE_DRAG
 * @eventType ext.resizer.events.Resizer_width_height_eEvent.RESIZE_DRAG
 */
[Event(name='onResizeDrag', type='ext.resizer.events.Resizer_width_height_eEvent')]
/**
 * Applies drag handles to an element or component to make it resizable. The drag handles
 * are inserted into the element (or component's element) and positioned absolute.
 * <p>Textarea and img elements will be wrapped with an additional div because these elements
 * do not support child nodes. The original element can be accessed through the originalTarget
 * property.</p>
 * <p>Here is the list of valid resize handles:</p>
 * <pre>
 * Value   Description
 * ------  -------------------
 *  'n'     north
 *  's'     south
 *  'e'     east
 *  'w'     west
 *  'nw'    northwest
 *  'sw'    southwest
 *  'se'    southeast
 *  'ne'    northeast
 *  'all'   all
 * </pre>
 * <p>Here's an example showing the creation of a typical Resizer:</p>
 * <pre>
 * Ext.create('Ext.resizer.Resizer', {
 *     target: 'elToResize',
 *     handles: 'all',
 *     minWidth: 200,
 *     minHeight: 100,
 *     maxWidth: 500,
 *     maxHeight: 400,
 *     pinned: true
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html Original Ext JS documentation of 'Ext.resizer.Resizer'
 */
public class Resizer extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function Resizer(config:Resizer = null) {
    super();
  }

  [ExtConfig]
  /**
   * An element, or a →<code>ext.util.Region</code> into which the resize operation
   * must be constrained.
   * @see ext.util.Region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-constrainTo Original Ext JS documentation of 'constrainTo'
   */
  public native function get constrainTo():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainTo(value:*):void;

  [ExtConfig]
  /**
   * Specify as true to update the →<code>target</code> (Element or →<code>ext.Component</code>)
   * dynamically during dragging. This is <code>true</code> by default, but the
   * →<code>ext.Component</code> class passes <code>false</code> when it is configured as
   * →<code>ext.Component.resizable</code>.
   * <p>If specified as <code>false</code>, a proxy element is displayed during the resize operation,
   * and the →<code>target</code> is updated on mouseup.</p>
   * @default true
   * @see #target
   * @see ext.Component
   * @see ext.Component#resizable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-dynamic Original Ext JS documentation of 'dynamic'
   */
  public native function get dynamic():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dynamic(value:Boolean):void;

  /**
   * Outer element for resizing behavior.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#property-el Original Ext JS documentation of 'el'
   */
  public native function get el():Element;

  /**
   * @private
   */
  public native function set el(value:Element):void;

  [ExtConfig]
  /**
   * String consisting of the resize handles to display. Defaults to 's e se' for Elements
   * and fixed position Components. Defaults to 8 point resizing for floating Components
   * (such as Windows). Specify either <code>'all'</code> or any of <code>'n s e w ne nw se sw'</code>.
   * @default 's e se'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-handles Original Ext JS documentation of 'handles'
   */
  public native function get handles():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handles(value:String):void;

  [ExtConfig]
  /**
   * Optional. The height to set target to in pixels
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-height Original Ext JS documentation of 'height'
   */
  public native function get height():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set height(value:Number):void;

  [ExtConfig]
  /**
   * The increment to snap the height resize in pixels.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-heightIncrement Original Ext JS documentation of 'heightIncrement'
   */
  public native function get heightIncrement():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set heightIncrement(value:Number):void;

  [ExtConfig]
  /**
   * The maximum height for the element
   * @default 10000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-maxHeight Original Ext JS documentation of 'maxHeight'
   */
  public native function get maxHeight():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxHeight(value:Number):void;

  [ExtConfig]
  /**
   * The maximum width for the element
   * @default 10000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-maxWidth Original Ext JS documentation of 'maxWidth'
   */
  public native function get maxWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum height for the element
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-minHeight Original Ext JS documentation of 'minHeight'
   */
  public native function get minHeight():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minHeight(value:Number):void;

  [ExtConfig]
  /**
   * The minimum width for the element
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   */
  public native function get minWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minWidth(value:Number):void;

  /**
   * Reference to the original resize target if the element of the original
   * resize target was a →<code>ext.form.field.Field</code>, or an IMG or a TEXTAREA
   * which must be wrapped in a DIV.
   * @default me.target
   * @see ext.form.field.Field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#property-originalTarget Original Ext JS documentation of 'originalTarget'
   */
  public native function get originalTarget():*;

  /**
   * @private
   */
  public native function set originalTarget(value:*):void;

  [ExtConfig]
  /**
   * True to ensure that the resize handles are always visible, false indicates resizing
   * by cursor changes only
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-pinned Original Ext JS documentation of 'pinned'
   */
  public native function get pinned():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pinned(value:Boolean):void;

  [ExtConfig]
  /**
   * True to preserve the original ratio between height and width during resize
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-preserveRatio Original Ext JS documentation of 'preserveRatio'
   */
  public native function get preserveRatio():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preserveRatio(value:Boolean):void;

  /**
   * @default new Ext.resizer.ResizeTracker({
   *     disabled: me.disabled,
   *     target: resizeTarget,
   *     el: me.el,
   *     constrainTo: me.constrainTo,
   *     handleCls: me.handleCls,
   *     overCls: me.overCls,
   *     throttle: me.throttle,
   *     // If we have wrapped something, instruct the ResizerTracker to use that wrapper
   *     // as a proxy and we should resize the wrapped target dynamically.
   *     proxy: me.originalTarget ? me.el : null,
   *     dynamic: me.originalTarget ? true : me.dynamic,
   *     originalTarget: me.originalTarget,
   *     delegate: '.' + me.handleCls,
   *     preserveRatio: me.preserveRatio,
   *     heightIncrement: me.heightIncrement,
   *     widthIncrement: me.widthIncrement,
   *     minHeight: me.minHeight,
   *     maxHeight: me.maxHeight,
   *     minWidth: me.minWidth,
   *     maxWidth: me.maxWidth
   * })
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#property-resizeTracker Original Ext JS documentation of 'resizeTracker'
   */
  public native function get resizeTracker():DragTracker;

  /**
   * @private
   */
  public native function set resizeTracker(value:DragTracker):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The Element or Component to resize.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-target Original Ext JS documentation of 'target'
   * @see #getTarget()
   */
  public native function get target():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:*):void;

  [ExtConfig]
  /**
   * True for transparent handles. This is only applied at config time.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-transparent Original Ext JS documentation of 'transparent'
   */
  public native function get transparent():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set transparent(value:Boolean):void;

  [ExtConfig]
  /**
   * Optional. The width to set the target to in pixels
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-width Original Ext JS documentation of 'width'
   */
  public native function get width():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set width(value:Number):void;

  [ExtConfig]
  /**
   * The increment to snap the width resize in pixels.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#cfg-widthIncrement Original Ext JS documentation of 'widthIncrement'
   */
  public native function get widthIncrement():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set widthIncrement(value:Number):void;

  /**
   * Returns the element that was configured with the el or target config property.
   * If a component was configured with the target property then this will return the element
   * of this component.
   * <p>Textarea and img elements will be wrapped with an additional div because these elements
   * do not support child nodes. The original element can be accessed through the originalTarget
   * property.</p>
   * @return element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#method-getEl Original Ext JS documentation of 'getEl'
   */
  public native function getEl():Element;

  /**
   * Returns the element or component that was configured with the target config property.
   * <p>Textarea and img elements will be wrapped with an additional div because these elements
   * do not support child nodes. The original element can be accessed through the originalTarget
   * property.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget():*;

  /**
   * Perform a manual resize and fires the 'resize' event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#method-resizeTo Original Ext JS documentation of 'resizeTo'
   */
  public native function resizeTo(width:Number, height:Number):void;
}
}