package ext.resizer {
import ext.Component;

[Native("Ext.resizer.Splitter", require)]
/**
 * This class functions <b>between siblings of a →<code>ext.layout.container.VBoxLayout</code> or
 * →<code>ext.layout.container.HBoxLayout</code> layout</b> to resize both immediate siblings.
 * <p>A Splitter will preserve the flex ratio of any flexed siblings it is required to resize.
 * It does this by setting the <code>→flex</code> property of <i>all</i> flexed siblings to equal their pixel size.
 * The actual numerical <code>→flex</code> property in the Components will change, but the <b>ratio</b>
 * to the total flex value will be preserved.</p>
 * <p>A Splitter may be configured to show a centered mini-collapse tool orientated to collapse
 * the →<code>collapseTarget</code>. The Splitter will then call that sibling Panel's
 * →<code>ext.panel.Panel.collapse()</code> or →<code>ext.panel.Panel.expand()</code>
 * method to perform the appropriate operation (depending on the sibling collapse state).
 * To create the mini-collapse tool but take care of collapsing yourself, configure the splitter
 * with <code>→performCollapse: false</code>.</p>
 * @see ext.layout.container.VBoxLayout
 * @see ext.layout.container.HBoxLayout
 * @see #flex
 * @see #collapseTarget
 * @see ext.panel.Panel#collapse()
 * @see ext.panel.Panel#expand()
 * @see #performCollapse
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html Original Ext JS documentation of 'Ext.resizer.Splitter'
 */
public class Splitter extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Splitter(config:Splitter = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to enable dblclick to toggle expand and collapse on the →<code>collapseTarget</code> Panel.
   * @default true
   * @see #collapseTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-collapseOnDblClick Original Ext JS documentation of 'collapseOnDblClick'
   */
  public native function get collapseOnDblClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseOnDblClick(value:Boolean):void;

  [ExtConfig]
  /**
   * A string describing the relative position of the immediate sibling Panel to collapse.
   * May be 'prev' or 'next'.
   * <p>Or the immediate sibling Panel to collapse.</p>
   * <p>The orientation of the mini-collapse tool will be inferred from this setting.</p>
   * <p><b>Note that only Panels may be collapsed.</b></p>
   * @default 'next'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-collapseTarget Original Ext JS documentation of 'collapseTarget'
   */
  public native function get collapseTarget():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseTarget(value:*):void;

  [ExtConfig]
  /**
   * A class to add to the splitter when it is collapsed. See →<code>collapsible</code>.
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-collapsedCls Original Ext JS documentation of 'collapsedCls'
   */
  public native function get collapsedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsedCls(value:String):void;

  [ExtConfig]
  /**
   * True to show a mini-collapse tool in the Splitter to toggle expand and collapse
   * on the →<code>collapseTarget</code> Panel.
   * Defaults to the →<code>ext.panel.Panel.collapsible</code> setting of the Panel.
   * @default null
   * @see #collapseTarget
   * @see ext.panel.Panel#collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-collapsible Original Ext JS documentation of 'collapsible'
   */
  public native function get collapsible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsible(value:Boolean):void;

  [ExtConfig]
  /**
   * Provides a default maximum width or height for the two components
   * that the splitter is between.
   * @default 1000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-defaultSplitMax Original Ext JS documentation of 'defaultSplitMax'
   */
  public native function get defaultSplitMax():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultSplitMax(value:Number):void;

  [ExtConfig]
  /**
   * Provides a default minimum width or height for the two components
   * that the splitter is between.
   * @default 40
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-defaultSplitMin Original Ext JS documentation of 'defaultSplitMin'
   */
  public native function get defaultSplitMin():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultSplitMin(value:Number):void;

  /**
   * Orientation of this Splitter. <code>'vertical'</code> when used in an hbox layout, <code>'horizontal'</code>
   * when used in a vbox layout.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#property-orientation Original Ext JS documentation of 'orientation'
   */
  public native function get orientation():String;

  /**
   * @private
   */
  public native function set orientation(value:String):void;

  [ExtConfig]
  /**
   * Set to false to prevent this Splitter's mini-collapse tool from managing the collapse
   * state of the →<code>collapseTarget</code>.
   * @see #collapseTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-performCollapse Original Ext JS documentation of 'performCollapse'
   */
  public native function get performCollapse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set performCollapse(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The size of the splitter. This becomes the height for vertical splitters and
   * width for horizontal splitters.
   * @default 5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-size Original Ext JS documentation of 'size'
   * @see #getSize()
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;

  [ExtConfig]
  /**
   * Any configuration options to be passed to the underlying →<code>ext.resizer.SplitterTracker</code>.
   * @see ext.resizer.SplitterTracker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#cfg-tracker Original Ext JS documentation of 'tracker'
   */
  public native function get tracker():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tracker(value:Object):void;

  /**
   * Returns the config object (with an <code>xclass</code> property) for the splitter tracker. This
   * is overridden by →<code>null</code> to create a
   * →<code>null</code>.
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Splitter.html#method-getTrackerConfig Original Ext JS documentation of 'getTrackerConfig'
   */
  protected native function getTrackerConfig():SplitterTracker;
}
}