package ext.resizer.events {
import ext.event.Event;
import ext.resizer.Resizer;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.resizer.events.Resizer_width_height_eEvent")]
public class Resizer_width_height_eEvent extends FlExtEvent {
  /**
   * Fired before resize is allowed. Return false to cancel resize.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#event-beforeresize Original Ext JS documentation of 'beforeresize'
   * @see ext.resizer.Resizer
   * @eventType onBeforeResize
   */
  public static const BEFORE_RESIZE:String = "onBeforeResize";
  /**
   * Fired after a resize.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#event-resize Original Ext JS documentation of 'resize'
   * @see ext.resizer.Resizer
   * @eventType onResize
   */
  public static const RESIZE:String = "onResize";
  /**
   * Fires during resizing.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.resizer.Resizer.html#event-resizedrag Original Ext JS documentation of 'resizedrag'
   * @see ext.resizer.Resizer
   * @eventType onResizeDrag
   */
  public static const RESIZE_DRAG:String = "onResizeDrag";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "width", "height", "e", "eOpts"];

  public function Resizer_width_height_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The mousedown event
   */
  public native function get e():Event;

  /**
   * The start height
   */
  public native function get height():Number;

  public native function get source():Resizer;

  /**
   * The start width
   */
  public native function get width():Number;
}
}