package ext.route {
import ext.Base;
import ext.promise.ExtPromise;

[Native("Ext.route.Route", require)]
/**
 * Enables reactive actions to handle changes in the hash by using the
 * →<code>ext.route.RouteMixin.routes</code> configuration in a controller.
 * An example configuration would be:
 * <pre>
 * Ext.define('MyApp.view.main.MainController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.app-main',
 *
 *     routes: {
 *         'user/:{id}': 'onUser'
 *     },
 *
 *     onUser: function (values) {
 *         var id = values.id;
 *         // ...
 *     }
 * });
 * </pre>
 * <p>The <code>routes</code> object can also receive an object to further configure
 * the route, for example you can configure a <code>before</code> action that will
 * be executed before the <code>action</code> or can cancel the route execution:</p>
 * <pre>
 * Ext.define('MyApp.view.main.MainController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.app-main',
 *
 *     routes: {
 *         'user/:{id}': {
 *             action: 'onUser',
 *             before: 'onBeforeUser',
 *             name: 'user'
 *         }
 *     },
 *
 *     onBeforeUser: function (values) {
 *         return Ext.Ajax
 *             .request({
 *                 url: '/check/permission',
 *                 params: {
 *                     route: 'user',
 *                     meta: {
 *                         id: values.id
 *                     }
 *                 }
 *             });
 *     },
 *
 *     onUser: function (values) {
 *         var id = values.id;
 *         // ...
 *     }
 * });
 * </pre>
 * <p>URL Parameters in a route can also define a type that will be used
 * when matching hashes when finding routes that recognize a hash and
 * also parses the value into numbers:</p>
 * <pre>
 * Ext.define('MyApp.view.main.MainController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.app-main',
 *
 *     routes: {
 *         'user/:{id:num}': {
 *             action: 'onUser',
 *             before: 'onBeforeUser',
 *             name: 'user'
 *         }
 *     },
 *
 *     onBeforeUser: function (values) {
 *         return Ext.Ajax
 *             .request({
 *                 url: '/check/permission',
 *                 params: {
 *                     route: 'user',
 *                     meta: {
 *                         id: values.id
 *                     }
 *                 }
 *             });
 *     },
 *
 *     onUser: function (values) {
 *         var id = values.id;
 *         // ...
 *     }
 * });
 * </pre>
 * <p>In this example, the id parameter added <code>:num</code> to the parameter which
 * will now mean the route will only recognize a value for the id parameter
 * that is a number such as <code>#user/123</code> and will not recognize <code>#user/abc</code>.
 * The id passed to the action and before handlers will also get cast into
 * a number instead of a string. If a type is not provided, it will use
 * the <i>default matcher</i> (→<code>defaultMatcher</code>).</p>
 * <p>For more on types, see the →<code>types</code> config.</p>
 * <p>For backwards compatibility, there is <code>positional</code> mode which is like
 * <code>named</code> mode but how you define the url parameters and how they are passed
 * to the action and before handlers is slightly different:</p>
 * <pre>
 * Ext.define('MyApp.view.main.MainController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.app-main',
 *
 *     routes: {
 *         'user/:id:action': {
 *             action: 'onUser',
 *             before: 'onBeforeUser',
 *             name: 'user',
 *             conditions: {
 *                 ':action': '(edit|delete)?'
 *             }
 *         }
 *     },
 *
 *     onBeforeUser: function (id, action) {
 *         return Ext.Ajax
 *             .request({
 *                 url: '/check/permission',
 *                 params: {
 *                     route: 'user',
 *                     meta: {
 *                         action: action,
 *                         id: id
 *                     }
 *                 }
 *             });
 *     },
 *
 *     onUser: function (id) {
 *         // ...
 *     }
 * });
 * </pre>
 * <p>The parameters are defined without curly braces (<code>:id</code>, <code>:action</code>) and
 * they are passed as individual arguments to the action and before handlers.</p>
 * <p>It's important to note you cannot mix positional and named parameter formats
 * in the same route since how they are passed to the handlers is different.</p>
 * <p>Routes can define sections of a route pattern that are optional by surrounding
 * the section that is to be optional with parenthesis. For example, if a route
 * should match both <code>#user</code> and <code>#user/1234</code> to either show a grid of all users
 * or details or a single user, you can define the route such as:</p>
 * <pre>
 * Ext.define('MyApp.view.main.MainController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.app-main',
 *
 *     routes: {
 *         'user(/:{id:num})': {
 *             action: 'onUser',
 *             name: 'user'
 *         }
 *     },
 *
 *     onUser: function (params) {
 *         if (params.id) {
 *             // load user details
 *         } else {
 *             // load grid of users
 *         }
 *     }
 * });
 * </pre>
 * @see ext.route.RouteMixin#routes
 * @see #defaultMatcher
 * @see #types
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html Original Ext JS documentation of 'Ext.route.Route'
 */
public class Route extends Base {
  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow this route to be triggered on
   * a controller that is not active.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-allowInactive Original Ext JS documentation of 'allowInactive'
   * @see #getAllowInactive()
   * @see #setAllowInactive()
   */
  public native function get allowInactive():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set allowInactive(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to allow the tokens to be matched with
   * case-insensitive.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-caseInsensitive Original Ext JS documentation of 'caseInsensitive'
   * @see #getCaseInsensitive()
   * @see #setCaseInsensitive()
   */
  public native function get caseInsensitive():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set caseInsensitive(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Optional set of conditions for each token in the url string. Each key should
   * be one of the tokens, each value should be a regex that the token should accept.
   * <p>For <code>positional</code> mode, if you have a route with a url like <code>'files/:fileName'</code> and
   * you want it to match urls like <code>files/someImage.jpg</code> then you can set these
   * conditions to allow the :fileName token to accept strings containing a period:</p>
   * <pre>
   * conditions: {
   *     ':fileName': '([0-9a-zA-Z\.]+)'
   * }
   * </pre>
   * <p>For <code>named</code> mode, if you have a route with a url like <code>'files/:{fileName}'</code>
   * and you want it to match urls like <code>files/someImage.jpg</code> then you can set these
   * conditions to allow the :{fileName} token to accept strings containing a period:</p>
   * <pre>
   * conditions: {
   *     'fileName': '([0-9a-zA-Z\.]+)'
   * }
   * </pre>
   * <p>You can also define a condition to parse the value or even split it on a character:</p>
   * <pre>
   * conditions: {
   *     'fileName': {
   *         re: '([0-9a-zA-Z\.]+)',
   *         split: '.', // split the value so you get an array ['someImage', 'jpg']
   *         parse: function (values) {
   *             return values[0]; // return a string without the extension
   *         }
   *     }
   * }
   * </pre>
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-conditions Original Ext JS documentation of 'conditions'
   * @see #getConditions()
   * @see #setConditions()
   */
  public native function get conditions():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set conditions(value:Object):void;

  /**
   * The default RegExp string
   * to use to match parameters with.
   * @default '([%a-zA-Z0-9\\-\\_\\s,]+)'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#property-defaultMatcher Original Ext JS documentation of 'defaultMatcher'
   */
  public native function get defaultMatcher():String;

  /**
   * @private
   */
  public native function set defaultMatcher(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The array of connected handlers to this route. Each handler must defined a
   * <code>scope</code> and can define an <code>action</code>, <code>before</code> and/or <code>exit</code> handler:
   * <pre>
   * handlers: [{
   *     action: function() {
   *         //...
   *     },
   *     scope: {}
   * }, {
   *     action: function() {
   *         //...
   *     },
   *     before: function() {
   *         //...
   *     },
   *     scope: {}
   * }, {
   *     exit: function() {
   *         //...
   *     },
   *     scope: {}
   * }]
   * </pre>
   * <p>The <code>action</code>, <code>before</code> and <code>exit</code> handlers can be a string that will be resolved
   * from the <code>scope</code>:</p>
   * <pre>
   * handlers: [{
   *     action: 'onAction',
   *     before: 'onBefore',
   *     exit: 'onExit',
   *     scope: {
   *         onAction: function () {
   *             //...
   *         },
   *         onBefore: function () {
   *             //...
   *         },
   *         onExit: function () {
   *             //...
   *         }
   *     }
   * }]
   * </pre>
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-handlers Original Ext JS documentation of 'handlers'
   * @see #getHandlers()
   * @see #setHandlers()
   */
  public native function get handlers():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set handlers(value:Array):void;

  /**
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#property-isRoute Original Ext JS documentation of 'isRoute'
   */
  public native function get isRoute():Boolean;

  /**
   * @private
   */
  public native function set isRoute(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of this route. The name can be used when using
   * →<code>ext.route.RouteMixin.redirectTo()</code>.
   * @see ext.route.RouteMixin#redirectTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   * @see #setName()
   */
  public native function get name():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * A regular expression to match against float numbers for
   * <code>alphanum</code>, <code>num</code> and <code>...</code> →<code>types</code> in order to cast into floats.
   * @default /^[0-9]&#42;(?:\.[0-9]&#42;)?$/
   * @since 6.6.0
   * @see #types
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#property-numRe Original Ext JS documentation of 'numRe'
   */
  public native function get numRe():RegExp;

  /**
   * @private
   */
  public native function set numRe(value:RegExp):void;

  /**
   * An object of types that will be used to match and parse values from a matched
   * url. There are four default types:
   * <ul>
   * <li><code>alpha</code> This will only match values that have only alpha characters using
   * the regex <code>([a-zA-Z]+)</code>.</li>
   * <li><code>alphanum</code> This will only match values that have alpha and numeric characters
   * using the regex <code>([a-zA-Z0-9]+|[0-9]&#42;(?:\\.[0-9]&#42;)?)</code>. If a value is a number,
   * which a number can have a period (<code>10.4</code>), the value will be case into a float
   * using <code>parseFloat</code>.</li>
   * <li><code>num</code> This will only match values that have numeric characters using the regex
   * <code>([0-9]&#42;(?:\\.[0-9]&#42;)?)</code>. The value, which can have a period (<code>10.4</code>), will be
   * case into a float using <code>parseFloat</code>.</li>
   * <li><code>...</code> This is meant to be the last argument in the url and will match all
   * characters using the regex <code>(.+)?</code>. If a value is matched, this is an optional
   * type, the value will be split by <code>/</code> and an array will be sent to the handler
   * methods. If no value was matched, the value will be <code>undefined</code>.</li>
   * </ul>
   * <p>When defining routes, a type is optional and will use the
   * <i>default matcher</i> (→<code>defaultMatcher</code>) but the url parameter must be enclosed
   * in curly braces which will send a single object to the route handlers:</p>
   * <pre>
   * Ext.define('MyApp.view.MainController', {
   *     extend: 'Ext.app.ViewController',
   *     alias: 'controller.myapp-main',
   *
   *     routes: {
   *         'view/:{view}/:{child:alphanum}:{args...}': {
   *             action: 'onView',
   *             before: 'onBeforeView',
   *             name: 'view'
   *         }
   *     },
   *
   *     onBeforeView: function (values) {
   *         return Ext.Ajax.request({
   *             url: 'check/permission',
   *             params: {
   *                 view: values.view,
   *                 info: { childView: values.child }
   *             }
   *         });
   *     },
   *
   *     onView: function (values) {}
   * });
   * </pre>
   * <p>In this example, there are 3 parameters defined. The <code>:{view}</code> parameter has no
   * type which will match characters using the <i>default matcher</i> (→<code>defaultMatcher</code>)
   * but is required to be in the matched url. The <code>:{child:alphanum}</code> will only match
   * characters that are alpha or numeric but is required to be in the matched url. The
   * <code>:{args...}</code> is the only optional parameter in this route but can match any
   * character and will be an array of values split by <code>/</code> unless there are no values
   * in which case <code>undefined</code> will be sent in the object.</p>
   * <p>If the hash is <code>#view/user/edit</code>, the <code>values</code> argument sent to the handlers would be:</p>
   * <pre>
   * {
   *     view: 'user',
   *     child: 'edit',
   *     args: undefined
   * }
   * </pre>
   * <p>Since there were no more values for the <code>args</code> parameter, it's value is <code>undefined</code>.</p>
   * <p>If the hash is <code>#view/user/1234</code>, the <code>values</code> argument sent to the handlers would be:</p>
   * <pre>
   * {
   *     view: 'user',
   *     child: 1234,
   *     args: undefined
   * }
   * </pre>
   * <p>Notice the <code>child</code> value is a number instead of a string.</p>
   * <p>If the hash is <code>#view/user/1234/edit/settings</code>, the <code>values</code> argument sent to the
   * handlers would be:</p>
   * <pre>
   * {
   *     view: 'user',
   *     child: 1234,
   *     args: ['edit', 'settings']
   * }
   * </pre>
   * <p>The <code>args</code> parameter matched the <code>edit/settings</code> and split it by the <code>/</code> producing
   * the array.</p>
   * <p>To add custom types, you can override <code>→ext.route.Route</code>:</p>
   * <pre>
   * Ext.define('Override.route.Route', {
   *     override: 'Ext.route.Route',
   *
   *     config: {
   *         types: {
   *             uuid: {
   *                 re: '([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12})'
   *             }
   *         }
   *     }
   * });
   * </pre>
   * <p>You can now use the <code>uuid</code> type in your routes:</p>
   * <pre>
   * Ext.define('MyApp.view.MainController', {
   *     extend: 'Ext.app.ViewController',
   *     alias: 'controller.myapp-main',
   *
   *     routes: {
   *         'user/:{userid:uuid}': {
   *             action: 'onUser',
   *             caseInsensitive: true,
   *             name: 'user'
   *         }
   *     },
   *
   *     onUser: function (values) {}
   * });
   * </pre>
   * <p>This would match if the hash was like <code>#user/C56A4180-65AA-42EC-A945-5FD21DEC0538</code>
   * and the <code>values</code> object would then be:</p>
   * <pre>
   * {
   *     user: 'C56A4180-65AA-42EC-A945-5FD21DEC0538'
   * }
   * </pre>
   * @since 6.6.0
   * @see #defaultMatcher
   * @see ext.route.Route
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#property-types Original Ext JS documentation of 'types'
   */
  public native function get types():Object;

  /**
   * @private
   */
  public native function set types(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>. The url regex to match against.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#cfg-url Original Ext JS documentation of 'url'
   * @see #getUrl()
   * @see #setUrl()
   */
  public native function get url():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set url(value:String):void;

  /**
   * Adds a handler to the →<code>handlers</code> stack.
   * @param handler An object to describe the handler. A handler should define a <code>fn</code> and <code>scope</code>.
   * If the <code>fn</code> is a String, the function will be resolved from the <code>scope</code>.
   * @return this
   * @see #handlers
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-addHandler Original Ext JS documentation of 'addHandler'
   */
  public native function addHandler(handler:Object):Route;

  /**
   * Clears the last token properties of this route and all handlers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-clearLastTokens Original Ext JS documentation of 'clearLastTokens'
   */
  public native function clearLastTokens():void;

  /**
   * Takes the configured url string including wildcards and returns a regex that can be
   * used to match against a url.
   * <p>This is only used in <code>positional</code> →<code>mode</code>.</p>
   * @param url The url string.
   * @return The matcher regex.
   * @see #mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-createMatcherRegex Original Ext JS documentation of 'createMatcherRegex'
   */
  public native function createMatcherRegex(url:String):RegExp;

  /**
   * The method to execute the action using the configured before function which will
   * kick off the actual →<code>actions</code> on the →<code>controller</code>.
   * @param token The token this route is being executed with.
   * @param argConfig The object from the →<code>ext.route.Route</code>'s
   * recognize method call.
   * @see #actions
   * @see #controller
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-execute Original Ext JS documentation of 'execute'
   * @see ext.route.Route
   */
  public native function execute(token:String, argConfig:Object):ExtPromise;

  /**
   * Returns the value of <code>allowInactive</code>.
   * @see #allowInactive
   */
  public native function getAllowInactive():Boolean;

  /**
   * Returns the value of <code>caseInsensitive</code>.
   * @see #caseInsensitive
   */
  public native function getCaseInsensitive():Boolean;

  /**
   * Returns the value of <code>conditions</code>.
   * @see #conditions
   */
  public native function getConditions():Object;

  /**
   * Returns the value of <code>handlers</code>.
   * @see #handlers
   */
  public native function getHandlers():Array;

  /**
   * Returns the value of <code>name</code>.
   * @see #name
   */
  public native function getName():String;

  /**
   * Returns the value of <code>url</code>.
   * @see #url
   */
  public native function getUrl():String;

  /**
   * Returns a hash of matching url segments for the given url.
   * @param url The url to extract matches for
   * @return matching url segments
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-matchesFor Original Ext JS documentation of 'matchesFor'
   */
  public native function matchesFor(url:String):Object;

  /**
   * Attempts to recognize a given url string and return a meta data object including
   * any URL parameter matches.
   * @param url The url to recognize.
   * @return The matched data, or <code>false</code> if no match.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-recognize Original Ext JS documentation of 'recognize'
   */
  public native function recognize(url:String):*;

  /**
   * Returns <code>true</code> if this →<code>ext.route.Route</code> matches the given url string.
   * @param url The url to test.
   * @return <code>true</code> if this →<code>ext.route.Route</code> recognizes the url.
   * @see ext.route.Route
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-recognizes Original Ext JS documentation of 'recognizes'
   */
  public native function recognizes(url:String):Boolean;

  /**
   * Removes a handler from the →<code>handlers</code> stack. This normally happens when
   * destroying a class instance.
   * @param scope The class instance to match handlers with.
   * @param handler An optional →<code>ext.route.RouteHandler</code>
   * to only remove from the array of handlers. If no handler is passed, all handlers
   * will be removed.
   * @return this
   * @see #handlers
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Route.html#method-removeHandler Original Ext JS documentation of 'removeHandler'
   * @see ext.route.RouteHandler
   */
  public native function removeHandler(scope:*, handler:RouteHandler = null):Route;

  /**
   * Sets the value of <code>allowInactive</code>.
   * @param allowInactive The new value.
   * @see #allowInactive
   */
  public native function setAllowInactive(allowInactive:Boolean):void;

  /**
   * Sets the value of <code>caseInsensitive</code>.
   * @param caseInsensitive The new value.
   * @see #caseInsensitive
   */
  public native function setCaseInsensitive(caseInsensitive:Boolean):void;

  /**
   * Sets the value of <code>conditions</code>.
   * @param conditions The new value.
   * @see #conditions
   */
  public native function setConditions(conditions:Object):void;

  /**
   * Sets the value of <code>handlers</code>.
   * @param handlers The new value.
   * @see #handlers
   */
  public native function setHandlers(handlers:Array):void;

  /**
   * Sets the value of <code>name</code>.
   * @param name The new value.
   * @see #name
   */
  public native function setName(name:String):void;

  /**
   * Sets the value of <code>url</code>.
   * @param url The new value.
   * @see #url
   */
  public native function setUrl(url:String):void;
}
}