package ext.route {
import ext.Base;
import ext.Promise;
import ext.promise.ExtPromise;

[Native("Ext.route.Action", require)]
/**
 * Class that can manage the execution of route handlers. All →<code>befores</code> handlers
 * will be executed prior to the →<code>actions</code> handlers. If at any point this <code>Action</code>
 * class is stopped, no other handler (before or action) will be executed.
 * @see #befores
 * @see #actions
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html Original Ext JS documentation of 'Ext.route.Action'
 */
public class RouteAction extends Base {
  [ArrayElementType("Function")]
  [ExtConfig]
  [Bindable]
  /**
   * The action handlers to execute in response to the route executing.
   * The individual functions will be executed with the scope of the class
   * that connected the route and the arguments will be the configured URL
   * parameters in order they appear in the token.
   * <p>See →<code>befores</code> also.</p>
   * @see #befores
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#cfg-actions Original Ext JS documentation of 'actions'
   * @see #getActions()
   * @see #setActions()
   */
  public native function get actions():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set actions(value:Array):void;

  [ArrayElementType("Function")]
  [ExtConfig]
  [Bindable]
  /**
   * The before handlers to execute prior to the →<code>actions</code> handlers.
   * The individual functions will be executed with the scope of the class
   * that connected the route and the arguments will be the configured URL
   * parameters in the order they appear in the token plus this <code>Action</code> instance
   * as the last argument.
   * <p><b>IMPORTANT</b> A before function must have a resolution. You can do this
   * by executing the →<code>resume()</code> or →<code>stop()</code> function or you can
   * return a promise and resolve/reject it.</p>
   * <pre>
   * var action = new Ext.route.Action({
   *     before: {
   *         fn: function (action) {
   *             action.resume(); //or action.stop();
   *         }
   *     }
   * });
   * action.run();
   *
   * var action = new Ext.route.Action({
   *     before: {
   *         fn: function () {
   *             return new Ext.Promise(function (resolve, reject) {
   *                 resolve(); //or reject();
   *             });
   *         }
   *     }
   * });
   * action.run();
   * </pre>
   * <p>See →<code>actions</code> also.</p>
   * @see #actions
   * @see #resume()
   * @see #stop()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#cfg-befores Original Ext JS documentation of 'befores'
   * @see #getBefores()
   * @see #setBefores()
   */
  public native function get befores():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set befores(value:Array):void;

  /**
   * Whether or not this class has started executing any →<code>befores</code> or →<code>actions</code>.
   * @default false
   * @see #befores
   * @see #actions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#property-started Original Ext JS documentation of 'started'
   */
  public native function get started():Boolean;

  /**
   * Whether or not this class was stopped by a →<code>befores</code> function.
   * @default false
   * @see #befores
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#property-stopped Original Ext JS documentation of 'stopped'
   */
  public native function get stopped():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * The URL parameters that were matched by the →<code>ext.route.Route</code>.
   * @default []
   * @see ext.route.Route
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#cfg-urlParams Original Ext JS documentation of 'urlParams'
   * @see #getUrlParams()
   * @see #setUrlParams()
   */
  public native function get urlParams():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set urlParams(value:Array):void;

  /**
   * Add a function to the →<code>actions</code> stack.
   * <pre>
   * action.action(function() {}, this);
   * </pre>
   * <p>By default, the function will be added to the end of the →<code>actions</code> stack. If
   * instead the function should be placed at the beginning of the stack, you can pass
   * <code>true</code> as the first argument:</p>
   * <pre>
   * action.action(true, function() {}, this);
   * </pre>
   * @param first Pass <code>true</code> to add the function to the beginning of the
   * →<code>befores</code> stack.
   * @default false
   * @param fn The function to add to the →<code>actions</code>.
   * @param scope The scope of the function to execute with. This is normally
   * the class that is adding the function to the action stack.
   * @return this
   * @see #actions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-action Original Ext JS documentation of 'action'
   * @see #befores
   */
  public native function action(first:Boolean = false, fn:* = undefined, scope:Object = null):RouteAction;

  /**
   * Add a function to the →<code>befores</code> stack.
   * <pre>
   * action.before(function() {}, this);
   * </pre>
   * <p>By default, the function will be added to the end of the →<code>befores</code> stack. If
   * instead the function should be placed at the beginning of the stack, you can pass
   * <code>true</code> as the first argument:</p>
   * <pre>
   * action.before(true, function() {}, this);
   * </pre>
   * @param first Pass <code>true</code> to add the function to the beginning of the
   * →<code>befores</code> stack instead of the end.
   * @default false
   * @param fn The function to add to the →<code>befores</code>.
   * @param scope The scope of the function to execute with. This is normally
   * the class that is adding the function to the before stack.
   * @return this
   * @see #befores
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-before Original Ext JS documentation of 'before'
   */
  public native function before(first:Boolean = false, fn:* = undefined, scope:Object = null):RouteAction;

  [ArrayElementType("Function")]
  /**
   * Returns the value of <code>actions</code>.
   * @see #actions
   */
  public native function getActions():Array;

  [ArrayElementType("Function")]
  /**
   * Returns the value of <code>befores</code>.
   * @see #befores
   */
  public native function getBefores():Array;

  /**
   * Returns the value of <code>urlParams</code>.
   * @see #urlParams
   */
  public native function getUrlParams():Array;

  /**
   * Allow further function execution of other functions if any.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-resume Original Ext JS documentation of 'resume'
   */
  public native function resume():RouteAction;

  /**
   * Starts the execution of →<code>befores</code> and/or →<code>actions</code> functions.
   * @see #befores
   * @see #actions
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-run Original Ext JS documentation of 'run'
   */
  public native function run():ExtPromise;

  /**
   * Sets the value of <code>actions</code>.
   * @param actions The new value.
   * @see #actions
   */
  public native function setActions(actions:Array):void;

  /**
   * Sets the value of <code>befores</code>.
   * @param befores The new value.
   * @see #befores
   */
  public native function setBefores(befores:Array):void;

  /**
   * Sets the value of <code>urlParams</code>.
   * @param urlParams The new value.
   * @see #urlParams
   */
  public native function setUrlParams(urlParams:Array):void;

  /**
   * Prevent other functions from executing and resolve the →<code>deferred</code>.
   * @return this
   * @see #deferred
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-stop Original Ext JS documentation of 'stop'
   */
  public native function stop():RouteAction;

  /**
   * Execute functions when this action has been resolved or rejected.
   * @param resolve The function to execute when this action has been resolved.
   * @param reject The function to execute when a before function stopped this action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Action.html#method-then Original Ext JS documentation of 'then'
   */
  public native function then(resolve:Function, reject:Function):Promise;
}
}