package ext.route {
import ext.Base;

[Native("Ext.route.Handler", require)]
/**
 * This class is used to hold the handler functions for when a route is executed. It also
 * keeps track of the <i>last token</i> (→<code>lastToken</code>) this handler was last executed on.
 * @see #lastToken
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html Original Ext JS documentation of 'Ext.route.Handler'
 */
public class RouteHandler extends Base {
  [ExtConfig]
  /**
   * The handler to execute when the route recognizes a token in the hash.
   * <p>This can be prevented from executing by the →<code>before</code> handler.</p>
   * <p>If defined as a String, the Function will be resolved from the →<code>scope</code>.</p>
   * @see #before
   * @see #scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-action Original Ext JS documentation of 'action'
   */
  public native function get action():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set action(value:*):void;

  [ExtConfig]
  /**
   * The handler to execute before the →<code>action</code> handler. The <code>→before</code> handler
   * can prevent the →<code>action</code> handler by executing the →<code>ext.route.RouteAction.stop()</code>
   * method on the <i>action</i> (→<code>ext.route.RouteAction</code>) argument or by returning a
   * <i>promise</i> (→<code>ext.Promise</code>) and rejecting it:
   * <pre>
   * routes: {
   *     'user/:id': {
   *         before: 'onBefore
   *     }
   * },
   *
   * onBefore: function (id, action) {
   *     action.stop();
   * }
   *
   * // or
   *
   * onBefore: function (id) {
   *     return new Ext.Promise(function (resolve, reject) {
   *         reject();
   *     });
   * }
   * </pre>
   * <p>If using the <code>→action</code> argument, the <code>→action</code> argument will always be the last argument passed
   * after any configured url parameters.</p>
   * <p>If defined as a String, the Function will be resolved from the →<code>scope</code>.</p>
   * @see #action
   * @see #before
   * @see ext.route.RouteAction#stop()
   * @see ext.route.RouteAction
   * @see ext.Promise
   * @see #scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-before Original Ext JS documentation of 'before'
   */
  public native function get before():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set before(value:*):void;

  [ExtConfig]
  /**
   * The handler to execute when the route no longer recognizes a token in the current hash.
   * <p>If defined as a String, the Function will be resolved from the →<code>scope</code>.</p>
   * @see #scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-exit Original Ext JS documentation of 'exit'
   */
  public native function get exit():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set exit(value:*):void;

  [ExtConfig]
  /**
   * If <code>true</code>, the defined routes will get executed when created.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-lazy Original Ext JS documentation of 'lazy'
   */
  public native function get lazy():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lazy(value:Boolean):void;

  /**
   * The route this handler is connected to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#property-route Original Ext JS documentation of 'route'
   */
  public native function get route():Route;

  /**
   * @private
   */
  public native function set route(value:Route):void;

  [ExtConfig]
  /**
   * The scope to call the handlers with. If the handlers are defined with a String,
   * the handlers will be resolved from this scope.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Base;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Base):void;

  [ExtConfig]
  /**
   * Controls if this handler should be removed after first execution. There are
   * a veriety of values that control when in the execution this should be removed:
   * <ul>
   * <li><b>true</b> Remove this handler after a successful and full execution. The handler
   * will be removed after the handler's →<code>action</code> has been executed. If a
   * →<code>before</code> has been rejected, the →<code>action</code> will not be
   * executed meaning this handler will <b>not</b> be removed.</li>
   * <li><b>after</b> Remove this handler after the {@cfg!link #before} has been resolved.
   * If {@cfg!link #before} has been rejected, this handler will <b>not</b> be removed.
   * If no {@cfg!link #before} exists, this handler will be removed prior to the
   * →<code>action</code> being executed.</li>
   * <li><b>before</b> Remove this handler before the →<code>before</code> has been
   * executed. If no →<code>before</code> exists, this handler will be removed prior
   * to the →<code>action</code> being executed.</li>
   * </ul>
   * @see #action
   * @see #before
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Handler.html#cfg-single Original Ext JS documentation of 'single'
   */
  public native function get single():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set single(value:Boolean):void;
}
}