package ext.route {

[Native("Ext.route.Router", require)]
/**
 * The Router is an ordered set of →<code>ext.route.Route</code> definitions that decode a
 * url into a controller function to execute. Each <code>route</code> defines a type of url to match,
 * along with the controller function to call if it is matched. The Router uses the
 * →<code>ext.util.History</code> singleton to find out when the browser's url has changed.
 * <p>Routes are almost always defined inside a →<code>null</code>, as
 * opposed to on the Router itself. End-developers should not usually need to interact
 * directly with the Router as the Controllers manage everything automatically. See the
 * <i>Controller documentation</i> (→<code>null</code>) for more information on specifying
 * routes.</p>
 * @see ext.route.Route
 * @see ext.util.#History ext.util.History
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html Original Ext JS documentation of 'Ext.route.Router'
 */
public const Router:SRouter = new SRouter;
}