package ext.route {
import ext.Base;

[Native]
/**
 * The Router is an ordered set of →<code>ext.route.Route</code> definitions that decode a
 * url into a controller function to execute. Each <code>route</code> defines a type of url to match,
 * along with the controller function to call if it is matched. The Router uses the
 * →<code>ext.util.History</code> singleton to find out when the browser's url has changed.
 * <p>Routes are almost always defined inside a →<code>null</code>, as
 * opposed to on the Router itself. End-developers should not usually need to interact
 * directly with the Router as the Controllers manage everything automatically. See the
 * <i>Controller documentation</i> (→<code>null</code>) for more information on specifying
 * routes.</p>
 * <p>Type of singleton Router.</p>
 * @see ext.route.Route
 * @see ext.util.#History ext.util.History
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html Original Ext JS documentation of 'Ext.route.Router'
 * @see ext.route.#Router ext.route.Router
 */
public class SRouter extends Base {
  [ExtConfig]
  [Bindable]
  /**
   * Sets →<code>ext.util.History.hashbang</code> to enable/disable
   * hashbang support.
   * @default null
   * @see ext.util.SHistory#hashbang ext.util.History.hashbang
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#cfg-hashBang Original Ext JS documentation of 'hashBang'
   * @see #getHashBang()
   * @see #setHashBang()
   */
  public native function get hashBang():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set hashBang(value:Boolean):void;

  /**
   * <code>true</code> if the router is currently suspended.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#property-isSuspended Original Ext JS documentation of 'isSuspended'
   */
  public native function get isSuspended():Boolean;

  /**
   * @private
   */
  public native function set isSuspended(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The token to split the routes to support multiple routes.
   * @default |
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#cfg-multipleToken Original Ext JS documentation of 'multipleToken'
   * @see #getMultipleToken()
   * @see #setMultipleToken()
   */
  public native function get multipleToken():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set multipleToken(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to queue routes to be executed one after the
   * other, false to execute routes immediately.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#cfg-queueRoutes Original Ext JS documentation of 'queueRoutes'
   * @see #getQueueRoutes()
   * @see #setQueueRoutes()
   */
  public native function get queueRoutes():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set queueRoutes(value:Boolean):void;

  /**
   * The connected →<code>ext.route.Route</code>
   * instances.
   * @see ext.route.Route
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#property-routes Original Ext JS documentation of 'routes'
   */
  public native function get routes():Object;

  /**
   * @private
   */
  public native function set routes(value:Object):void;

  /**
   * Clear all the recognized routes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Create the →<code>ext.route.Route</code> instance and connect to the
   * →<code>ext.route.Router</code> singleton.
   * @param url The url to recognize.
   * @param config The config on the controller to execute when the url is
   * matched.
   * @param instance The class instance associated with the
   * →<code>ext.route.Route</code>
   * @return The handler that was added.
   * @see ext.route.Route
   * @see ext.route.#Router ext.route.Router
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-connect Original Ext JS documentation of 'connect'
   */
  public native function connect(url:String, config:String, instance:Base):RouteHandler;

  /**
   * Disconnects all route handlers for a class instance.
   * @param instance The class instance to disconnect route handlers from.
   * @param config An optional config object to match a handler for. This will check all route
   * handlers connected to the instance for match based on the action and before
   * configurations. This can also be the actual <i>handler</i> (→<code>ext.route.RouteHandler</code>)
   * instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-disconnect Original Ext JS documentation of 'disconnect'
   * @see ext.route.RouteHandler
   */
  public native function disconnect(instance:Base, config:* = undefined):void;

  /**
   * Convenience method which just calls the supplied function with the
   * →<code>ext.route.Router</code> singleton. Example usage:
   * <pre>
   * Ext.route.Router.draw(function(map) {
   *     map.connect('activate/:token', {controller: 'users', action: 'activate'});
   *     map.connect('home',            {controller: 'index', action: 'home'});
   * });
   * </pre>
   * @param fn The function to call
   * @see ext.route.#Router ext.route.Router
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-draw Original Ext JS documentation of 'draw'
   */
  public native function draw(fn:Function):void;

  [ArrayElementType("ext.route.Route")]
  /**
   * Gets all routes by →<code>ext.route.Route.name</code>.
   * @return If no routes found, <code>undefined</code> will be returned otherwise
   * the array of <i>Routes</i> (→<code>ext.route.Route</code>) will be returned.
   * @see ext.route.Route#name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-getByName Original Ext JS documentation of 'getByName'
   * @see ext.route.Route
   */
  public native function getByName(name:*):Array;

  /**
   * Returns the value of <code>hashBang</code>.
   * @see #hashBang
   */
  public native function getHashBang():Boolean;

  /**
   * Returns the value of <code>multipleToken</code>.
   * @see #multipleToken
   */
  public native function getMultipleToken():String;

  /**
   * Returns the value of <code>queueRoutes</code>.
   * @see #queueRoutes
   */
  public native function getQueueRoutes():Boolean;

  /**
   * Recognizes a url string connected to the Router, return the controller/action pair
   * plus any additional config associated with it.
   * @param url The url to recognize.
   * @return If the url was recognized, the controller and action to
   * call, else <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-recognize Original Ext JS documentation of 'recognize'
   */
  public native function recognize(url:String):*;

  /**
   * Resumes the execution of routes (see →<code>suspend()</code>).
   * @param discardQueue <code>true</code> to prevent any previously queued
   * tokens from being enacted on.
   * @see SRouter#suspend()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-resume Original Ext JS documentation of 'resume'
   */
  public native function resume(discardQueue:Boolean = false):void;

  /**
   * Sets the value of <code>hashBang</code>.
   * @param hashBang The new value.
   * @see #hashBang
   */
  public native function setHashBang(hashBang:Boolean):void;

  /**
   * Sets the value of <code>multipleToken</code>.
   * @param multipleToken The new value.
   * @see #multipleToken
   */
  public native function setMultipleToken(multipleToken:String):void;

  /**
   * Sets the value of <code>queueRoutes</code>.
   * @param queueRoutes The new value.
   * @see #queueRoutes
   */
  public native function setQueueRoutes(queueRoutes:Boolean):void;

  /**
   * Suspends the handling of tokens (see →<code>resume()</code>).
   * @param trackTokens <code>false</code> to prevent any tokens to be
   * queued while being suspended.
   * @see SRouter#resume()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.route.Router.html#method-suspend Original Ext JS documentation of 'suspend'
   */
  public native function suspend(trackTokens:Boolean = false):void;
}
}