package ext.rtl {

[Native("Ext.rtl.Component", require)]
/**
 * This override adds RTL support and the <code>→rtl</code> config option to AbstactComponent.
 * @see #rtl
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.rtl.Component.html Original Ext JS documentation of 'Ext.rtl.Component'
 */
public class RtlComponent {
  [ExtConfig]
  /**
   * True to layout this component and its descendants in "rtl" (right-to-left) mode.
   * Can be explicitly set to false to override a true value inherited from an ancestor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.rtl.Component.html#cfg-rtl Original Ext JS documentation of 'rtl'
   */
  public native function get rtl():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rtl(value:Boolean):void;
}
}