package ext.scroll {
import ext.Evented;
import ext.Promise;
import ext.mixin.IBufferableMixin;
import ext.mixin.IFactoryable;

[Native("Ext.scroll.Scroller", require)]
/**
 * @see ext.scroll.events.ScrollerEvent.REFRESH
 * @eventType ext.scroll.events.ScrollerEvent.REFRESH
 */
[Event(name='onRefresh', type='ext.scroll.events.ScrollerEvent')]
/**
 * @see ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent.SCROLL
 * @eventType ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent.SCROLL
 */
[Event(name='onScroll', type='ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent')]
/**
 * @see ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent.SCROLL_END
 * @eventType ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent.SCROLL_END
 */
[Event(name='onScrollEnd', type='ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent')]
/**
 * @see ext.scroll.events.Scroller_x_yEvent.SCROLL_START
 * @eventType ext.scroll.events.Scroller_x_yEvent.SCROLL_START
 */
[Event(name='onScrollStart', type='ext.scroll.events.Scroller_x_yEvent')]
/**
 * Ext.scroll.Scroller allows any element to have scrollable content, both on desktop and
 * touch-screen devices, and defines a set of useful methods for manipulating the scroll
 * position and controlling the scrolling behavior.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html Original Ext JS documentation of 'Ext.scroll.Scroller'
 */
public class Scroller extends Evented implements IFactoryable, IBufferableMixin {
  /**
   * Creates and returns an appropriate Scroller instance for the current device.
   * @param config Configuration options for the Scroller
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#static-method-create Original Ext JS documentation of 'create'
   */
  public static native function create(config:Object, type:* = undefined):Scroller;

  /**
   * @param config @inheritDoc
   */
  public function Scroller(config:Scroller = null) {
    super();
  }

  [Deprecated(replacement="x", since="5.1.0")]
  [ExtConfig]
  [Bindable]
  /**
   * @default 'auto'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-direction Original Ext JS documentation of 'direction'
   * @see #getDirection()
   * @see #setDirection()
   */
  public native function get direction():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set direction(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The element to make scrollable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-element Original Ext JS documentation of 'element'
   * @see #getElement()
   * @see #setElement()
   */
  public native function get element():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set element(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to enable scrolling of "right-to-left" content. This is typically
   * configured automatically by an →<code>ext.Component</code> based on its inherited
   * →<code>ext.Component.rtl</code> state
   * @default false
   * @see ext.Component
   * @see ext.Component#rtl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-rtl Original Ext JS documentation of 'rtl'
   * @see #getRtl()
   * @see #setRtl()
   */
  public native function get rtl():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rtl(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * for the scroller's →<code>element</code>.
   * <p>For more details see →<code>ext.dom.Element.setTouchAction()</code></p>
   * @see #element
   * @see ext.dom.Element#setTouchAction()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-touchAction Original Ext JS documentation of 'touchAction'
   * @see #getTouchAction()
   * @see #setTouchAction()
   */
  public native function get touchAction():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set touchAction(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <ul>
   * <li><code>true</code> or <code>'auto'</code> to enable horizontal auto-scrolling. In auto-scrolling mode
   * scrolling is only enabled when the →<code>element</code> has overflowing content.</li>
   * <li><code>false</code> to disable horizontal scrolling</li>
   * <li><code>'scroll'</code> to always enable horizontal scrolling regardless of content size.</li>
   * </ul>
   * @default true
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-x Original Ext JS documentation of 'x'
   * @see #getX()
   * @see #setX()
   */
  public native function get x():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set x(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <ul>
   * <li><code>true</code> or <code>'auto'</code> to enable vertical auto-scrolling. In auto-scrolling mode
   * scrolling is only enabled when the →<code>element</code> has overflowing content.</li>
   * <li><code>false</code> to disable vertical scrolling</li>
   * <li><code>'scroll'</code> to always enable vertical scrolling regardless of content size.</li>
   * </ul>
   * @default true
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#cfg-y Original Ext JS documentation of 'y'
   * @see #getY()
   * @see #setY()
   */
  public native function get y():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set y(value:*):void;

  /**
   * Adds a "partner" scroller. Partner scrollers reflect each other's scroll position
   * at all times - if either scroller is scrolled, the scroll position of its partner
   * will be be automatically synchronized.
   * <p>A scroller may have multiple partners.</p>
   * @param partner
   * @param axis The axis to synchronize (<code>'x'</code>, '<code>→y</code>', or '<code>both</code>')
   * @default 'both'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-addPartner Original Ext JS documentation of 'addPartner'
   * @see #y
   */
  public native function addPartner(partner:Scroller, axis:String = 'both'):void;

  /**
   * Ensures a descendant element of the scroller is visible by scrolling to it.
   * @since 6.5.1
   * @param el The descendant element to scroll into view. May also be the options object with
   * the <code>→element</code> key defining the descendant element.
   * @param options An object containing options to modify the operation.
   * <ul>
   * <li><code>align:Object</code> (optional) —
   * The alignment for the scroll.
   * <ul>
   * <li><code>x:String</code> (optional) —
   * The alignment of the x scroll. If not
   * specified, the minimum will be done to make the element visible. The behavior is <code>undefined</code>
   * if the request cannot be honored. If the alignment is suffixed with a <code>?</code>, the alignment will
   * only take place if the item is not already in the visible area.
   * </li>
   * <li><code>y:String</code> (optional) —
   * The alignment of the y scroll. If not
   * specified, the minimum will be done to make the element visible. The behavior is <code>undefined</code>
   * if the request cannot be honored. If the alignment is suffixed with a <code>?</code>, the alignment will
   * only take place if the item is not already in the visible area.
   * </li>
   * </ul>
   * </li>
   * <li><code>animation:Boolean</code> (optional) —
   * Pass <code>true</code> to animate the row into view.
   * </li>
   * <li><code>highlight:Boolean</code> (default = <code>false</code>) —
   * Pass <code>true</code> to highlight the row with a glow
   * animation when it is in view. Can also be a hex color to use for highlighting
   * (defaults to yellow = '#ffff9c').
   * </li>
   * <li><code>x:Boolean</code> (default = <code>true</code>) —
   * <code>false</code> to disable horizontal scroll.
   * </li>
   * <li><code>y:Boolean</code> (default = <code>true</code>) —
   * <code>false</code> to disable vertical scroll.
   * </li>
   * </ul>
   * @return A promise for when the scroll completes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-ensureVisible Original Ext JS documentation of 'ensureVisible'
   * @see #element
   */
  public native function ensureVisible(el:*, options:Object = null):Promise;

  /**
   * Gets the <code>clientWidth</code> and <code>clientHeight</code> of the →<code>element</code> for this scroller.
   * @return An object with <code>→x</code> and <code>→y</code> properties.
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getClientSize Original Ext JS documentation of 'getClientSize'
   * @see #x
   * @see #y
   */
  public native function getClientSize():Object;

  [Deprecated(replacement="x", since="5.1.0")]
  /**
   * Returns the value of <code>direction</code>.
   * @see #direction
   */
  public native function getDirection():String;

  /**
   * Returns the value of <code>element</code>.
   * @see #element
   */
  public native function getElement():*;

  /**
   * Returns the maximum scroll position for this scroller
   * @return position
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The maximum scroll position on the x axis
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The maximum scroll position on the y axis
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getMaxPosition Original Ext JS documentation of 'getMaxPosition'
   */
  public native function getMaxPosition():Object;

  /**
   * Returns the maximum scroll position for this scroller for scrolling that is initiated
   * by the user via mouse or touch. This differs from getMaxPosition in that getMaxPosition
   * returns the true maximum scroll position regardless of which axes are enabled for
   * user scrolling.
   * @return position
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The maximum scroll position on the x axis
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The maximum scroll position on the y axis
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getMaxUserPosition Original Ext JS documentation of 'getMaxUserPosition'
   */
  public native function getMaxUserPosition():Object;

  /**
   * Returns the current scroll position
   * @return An object with <code>→x</code> and <code>→y</code> properties.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getPosition Original Ext JS documentation of 'getPosition'
   * @see #x
   * @see #y
   */
  public native function getPosition():Object;

  /**
   * Returns the value of <code>rtl</code>.
   * @see #rtl
   */
  public native function getRtl():Boolean;

  /**
   * Returns the amount of space consumed by scrollbars in the DOM
   * @return size An object containing the scrollbar sizes.
   * <ul>
   * <li><code>width:Number</code> (optional) —
   * The width of the vertical scrollbar.
   * </li>
   * <li><code>height:Number</code> (optional) —
   * The height of the horizontal scrollbar.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getScrollbarSize Original Ext JS documentation of 'getScrollbarSize'
   */
  public native function getScrollbarSize():Object;

  [Deprecated(message="This method is deprecated.  Please use Ext.scroll.Scroller&#39;s\ngetScrollable() method instead.\n", since="5.0")]
  /**
   * Returns this scroller.
   * <p>In Sencha Touch 2, access to a Component's Scroller was provided via
   * a Ext.scroll.View class that was returned from the Component's getScrollable()
   * method:</p>
   * <pre>
   * component.getScrollable().getScroller();
   * </pre>
   * <p>in 5.0 all the functionality of Ext.scroll.View has been rolled into
   * Ext.scroll.Scroller, and Ext.scroll.View has been removed. Component's
   * getScrollable() method now returns a Ext.scroll.Scroller. This method is
   * provided for compatibility.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getScroller Original Ext JS documentation of 'getScroller'
   */
  public native function getScroller():*;

  /**
   * Returns the size of the scrollable content
   * @return size
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The width of the scrollable content
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The height of the scrollable content
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-getSize Original Ext JS documentation of 'getSize'
   */
  public native function getSize():Object;

  /**
   * Returns the value of <code>touchAction</code>.
   * @see #touchAction
   */
  public native function getTouchAction():Object;

  /**
   * Returns the value of <code>x</code>.
   * @see #x
   */
  public native function getX():*;

  /**
   * Returns the value of <code>y</code>.
   * @see #y
   */
  public native function getY():*;

  /**
   * Determines if the passed element is within the visible x and y scroll viewport.
   * @param el The dom node, Ext.dom.Element, or
   * id (string) of the dom element that is to be verified to be in view
   * @return Which ranges the element is in.
   * <ul>
   * <li><code>x:Boolean</code> (optional) —
   * <code>true</code> if the passed element is within the x visible range.
   * </li>
   * <li><code>y:Boolean</code> (optional) —
   * <code>true</code> if the passed element is within the y visible range.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-isInView Original Ext JS documentation of 'isInView'
   */
  public native function isInView(el:*):Object;

  /**
   * Refreshes the scroller size and maxPosition.
   * @param immediate <code>true</code> to refresh immediately. By default refreshes
   * are deferred until the next →<code>ext.GlobalEvents.event:onIdle</code> event to
   * ensure any pending writes have been flushed to the dom and any reflows have
   * taken place.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-refresh Original Ext JS documentation of 'refresh'
   * @see ext.SGlobalEvents#event:onIdle ext.GlobalEvents.event:onIdle
   */
  public native function refresh(immediate:Boolean):Scroller;

  /**
   * Scrolls by the passed delta values, optionally animating.
   * <p>All of the following are equivalent:</p>
   * <pre>
   *  scroller.scrollBy(10, 10, true);
   *  scroller.scrollBy([10, 10], true);
   *  scroller.scrollBy({ x: 10, y: 10 }, true);
   * </pre>
   * <p>A null value for either <code>→x</code> or <code>→y</code> will result in no scrolling on the given axis,
   * for example:</p>
   * <pre>
   * scroller.scrollBy(null, 10);
   * </pre>
   * <p>will scroll by 10 on the y axis and leave the x axis at its current scroll position</p>
   * @param deltaX Either the x delta, an Array specifying x
   * and y deltas or an object with "x" and "y" properties.
   * @param deltaY Either the y delta, or an animate flag or
   * config object.
   * @param animate Animate flag/config object if the delta values were
   * passed separately.
   * @return A promise for when the scroll completes.
   * @see #x
   * @see #y
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-scrollBy Original Ext JS documentation of 'scrollBy'
   */
  public native function scrollBy(deltaX:*, deltaY:*, animate:*):Promise;

  [Deprecated(replacement="ensureVisible", since="6.5.1")]
  /**
   * Scrolls a descendant element of the scroller into view.
   * @param el the descendant to scroll into view
   * @param hscroll False to disable horizontal scroll.
   * @default true
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @param highlight true to
   * →<code>ext.dom.Element.highlight()</code> the element when it is in view. Can also be a
   * hex color to use for highlighting (defaults to yellow = '#ffff9c').
   * @default false
   * @return A promise for when the scroll completes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-scrollIntoView Original Ext JS documentation of 'scrollIntoView'
   * @see ext.dom.Element#highlight()
   */
  public native function scrollIntoView(el:*, hscroll:Boolean = true, animate:* = undefined, highlight:* = false):Promise;

  /**
   * Scrolls to the given position.
   * <p>All of the following are equivalent:</p>
   * <pre>
   *  scroller.scrollTo(10, 10, true);
   *  scroller.scrollTo([10, 10], true);
   *  scroller.scrollTo({ x: 10, y: 10 }, true);
   * </pre>
   * <p>A null value for either <code>→x</code> or <code>→y</code> will result in no scrolling on the given axis,
   * for example:</p>
   * <pre>
   * scroller.scrollTo(null, 10);
   * </pre>
   * <p>will scroll to 10 on the y axis and leave the x axis at its current scroll position</p>
   * <p>A negative value for either <code>→x</code> or <code>→y</code> represents an offset from the maximum scroll
   * position on the given axis:</p>
   * <pre>
   * // scrolls to 10px from the maximum x scroll position and 20px from maximum y
   * scroller.scrollTo(-10, -20);
   * </pre>
   * <p>A value of Infinity on either axis will scroll to the maximum scroll position on
   * that axis:</p>
   * <pre>
   * // scrolls to the maximum position on both axes
   * scroller.scrollTo(Infinity, Infinity);
   * </pre>
   * @param x The scroll position on the x axis.
   * @param y The scroll position on the y axis.
   * @param animation Whether or not to animate the scrolling to the
   * new position.
   * @return A promise for when the scroll completes.
   * @see #x
   * @see #y
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#method-scrollTo Original Ext JS documentation of 'scrollTo'
   */
  public native function scrollTo(x:Number, y:Number, animation:* = undefined):Promise;

  [Deprecated(replacement="x", since="5.1.0")]
  /**
   * Sets the value of <code>direction</code>.
   * @param direction The new value.
   * @see #direction
   */
  public native function setDirection(direction:String):void;

  /**
   * Sets the value of <code>element</code>.
   * @param element The new value.
   * @see #element
   */
  public native function setElement(element:*):void;

  /**
   * Sets the value of <code>rtl</code>.
   * @param rtl The new value.
   * @see #rtl
   */
  public native function setRtl(rtl:Boolean):void;

  /**
   * Sets the value of <code>touchAction</code>.
   * @param touchAction The new value.
   * @see #touchAction
   */
  public native function setTouchAction(touchAction:Object):void;

  /**
   * Sets the value of <code>x</code>.
   * @param x The new value.
   * @see #x
   */
  public native function setX(x:*):void;

  /**
   * Sets the value of <code>y</code>.
   * @param y The new value.
   * @see #y
   */
  public native function setY(y:*):void;
}
}